const {createJWT, parseJWT} = require('../src/util/token');

describe('Token', () => {
  test('should generate and validate a token sending duration time', () => {
    //id, issuer, subject
    const id = 'trismegistro';
    const subject = {"usuarioId": 395};
    const unixTime = 3600000; // 1 hour validity

    const token = createJWT(id, subject, unixTime); 
    const test = parseJWT(token);
    
    console.log("------------------------>")
    console.log(test)

    const payload = test.subject;
    expect(payload.usuarioId).toBe(395);
  });

  test('should generate and validate a token without sending duration time', () => {
    //id, issuer, subject
    const id = 'trismegistro';
    const subject = {"usuarioId": 395};

    const token = createJWT(id, subject); 
    const test = parseJWT(token);
    
    const payload = test.subject;
    expect(payload.usuarioId).toBe(395);
  });
  
  test('should throw an error for an invalid token', () => {
    expect(() => parseJWT('invalidToken')).toThrow('jwt malformed');
  });
});

