const jwt = require('jsonwebtoken');
const { getDefaultPath } = require('./osutils')

require('dotenv').config({path: getDefaultPath('global') + "/.env"});

const apiKey = process.env.API_KEY;
const tokenAlgorithm = process.env.TOKEN_ALGORITHM
createJWT = (id, subject, ...time) => {
    return createToken(id, "oliverpqh@gmail.com", subject, time);
}

createToken = (id, issuer, subject, ...time) => {
    const ttlMillis = time[0] || process.env.VIGENCIA_TOKEN || 3600000 ; // Time in ms (1 hour default)
    const now = Date.now();
    const signingKey = Buffer.from(apiKey, 'base64');

    // JWT payload (claims)
    const payload = {
        id: id,            // JWT ID
        issuedAt: Math.floor(now / 1000), // Issued at (in seconds)
        subject: subject,        // Subject (the user or object the token represents)
        issuer: issuer          // Issuer (who issued the token)
    };

    // Set expiration if provided
    const options = {
        algorithm: tokenAlgorithm
    };

    if (ttlMillis >= 0) {
        const exp = Math.floor((now + ttlMillis) / 1000); // Expiration time in seconds
        options.expiresIn = exp;
    }

    // Create and sign the JWT with the given payload and secret
    const token = jwt.sign(payload, signingKey, options);

    return token; // Return the signed JWT
}

parseJWT = (token, ...id)  => {
    try {
        // Verify and decode the token using token and private key
        const decoded = jwt.verify(token, Buffer.from(apiKey, 'base64'), {
            algorithms: [tokenAlgorithm] // Ensure it matches the algorithm used when creating the token
        });
        /* // if one day we want to validate the id
        if(id[0]){
            if(decoded.payload.id !== id[0]){
                throw "EL ID NO ES VALIDO";
            }
        }
        */
        return decoded; // This will return the token's claims (payload)
    } catch (err) {
        console.error('Invalid token:', err.message);
        throw err;
    }
}

module.exports = {
    createJWT,
    parseJWT
};