package sacooliveros.whatsappweb.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

import it.auties.whatsapp.api.QrHandler;
import it.auties.whatsapp.api.Whatsapp;
import sacooliveros.whatsappweb.bean.WhatsappBean;

public class WhatsappUtils {

    Logger logger = Logger.getLogger(WhatsappUtils.class.getName());

    public String generateQR() {
        WhatsappBean whatsappBean = new WhatsappBean();
    
        StringBuilder qr = new StringBuilder();
        CountDownLatch latch = new CountDownLatch(1);

        Consumer<String> smallQrConsumer = qrCode -> {
            qr.append(qrCode);
            latch.countDown();
        };

        try {
            CompletableFuture.supplyAsync(() ->{
                        try {
                            whatsappBean.setWhatsapp(Whatsapp.webBuilder().newConnection().unregistered(QrHandler.toString(smallQrConsumer)).connect().get(10, TimeUnit.SECONDS));
                            return true;
                        } catch (Exception e) {
                            return false;
                        }
                    }
            );

            if (!latch.await(10, TimeUnit.SECONDS)) {
                throw new TimeoutException("QR generation timed out");
            }

        } catch (TimeoutException e) {
            logger.log(Level.WARNING, "QR generation timeout", e);
            return "QR generation timeout";
        } catch (Exception e) {
            logger.log(Level.SEVERE, "QR generation failed", e);
            return "QR generation failed";
        }

        return qr.toString();
    }
}
