package sacooliveros.whatsappweb.service;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import io.netty.util.Timeout;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.model.contact.Contact;
import it.auties.whatsapp.model.jid.Jid;
import it.auties.whatsapp.model.jid.JidServer;
import it.auties.whatsapp.model.message.standard.*;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WhatsappService {

    public void send(Map<String, String> payload, Map<String, MultipartFile> files, Whatsapp whatsapp) {
        List<String> numbers = new ArrayList<>(Arrays.asList(payload.get("numbers").split(",")));
        String message = payload.get("message");
        for (String number : numbers) {
            Jid jid = new Jid(number, JidServer.WHATSAPP, null, null);
            Contact contact = new Contact(jid);
            whatsapp.sendChatMessage(contact, message);

            if (files != null) {
                for (MultipartFile file : files.values()) {
                    String extension = Objects.requireNonNull(file.getOriginalFilename())
                            .substring(file.getOriginalFilename().lastIndexOf("."));
                    switch (extension) {
                        case ".jpg", ".jpeg", ".png" -> sendImage(file, whatsapp, contact);
                        case ".mp4" -> sendVideo(file, whatsapp, contact);
                        case ".mp3" -> sendAudio(file, whatsapp, contact);
                        default -> sendDocument(file, whatsapp, contact);
                    }
                }
            }
        }
    }

    public void sendImage(MultipartFile file, Whatsapp whatsapp, Contact contact) {
        try {
            byte[] bytes = file.getBytes();
            ImageMessage imageMessage = new ImageMessageSimpleBuilder()
                    .media(bytes)
                    .build();
            whatsapp.sendMessage(contact, imageMessage).get(10, TimeUnit.SECONDS);
        } catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendVideo(MultipartFile file, Whatsapp whatsapp, Contact contact) {
        try{
            byte[] bytes = file.getBytes();
            VideoOrGifMessage videoMessage = new VideoMessageSimpleBuilder()
                    .media(bytes)
                    .build();
            whatsapp.sendMessage(contact,videoMessage).get(10, TimeUnit.SECONDS);
        } catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendAudio(MultipartFile file, Whatsapp whatsapp, Contact contact) {
        try{
            byte[] bytes = file.getBytes();
            AudioMessage audioMessage = new AudioMessageSimpleBuilder()
                    .media(bytes)
                    .build();
            whatsapp.sendMessage(contact,audioMessage).join();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendDocument(MultipartFile file, Whatsapp whatsapp, Contact contact) {
        try{
            byte[] bytes = file.getBytes();
            DocumentMessage documentMessage = new DocumentMessageSimpleBuilder()
                    .media(bytes)
                    .fileName(file.getOriginalFilename())
                    .build();
            whatsapp.sendMessage(contact,documentMessage).join();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}