package sacooliveros.whatsappweb.bean;

import java.util.Optional;

import jakarta.annotation.PostConstruct;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import it.auties.whatsapp.api.Whatsapp;

@Component
public class WhatsappBean {
    
    Optional<Whatsapp> w = Whatsapp.webBuilder().lastConnection().registered();

    @PostConstruct
    public Whatsapp getWhatsapp() {
        return w.orElse(null);
    }

    @Scheduled(fixedRate = 1000 * 60 )
    public void refreshConnection() {
        if (w.isPresent()) {
            if (!w.get().isConnected()) {
                w.get().connect().join();
            }
        }
    }

    public void setWhatsapp(Whatsapp whatsapp) {
        if(whatsapp != null) {
            w = Optional.of(whatsapp);
        }else{
            Whatsapp.webBuilder().lastConnection().registered().get().disconnect().join();
            w = Optional.empty();
        }
    }

}
