package sacooliveros.whatsappweb.api;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.catalina.connector.Response;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import it.auties.whatsapp.api.Whatsapp;
import sacooliveros.whatsappweb.bean.WhatsappBean;
import sacooliveros.whatsappweb.service.WhatsappService;
import sacooliveros.whatsappweb.utils.WhatsappUtils;

@RestController
@CrossOrigin("*")
@RequestMapping("api/v1")
public class WhatsappRest {

    Logger logger = Logger.getLogger(WhatsappRest.class.getName());

    @Autowired
    WhatsappBean whatsappBean;
    @Autowired
    WhatsappService whatsappService;

    @GetMapping("qr")
    public ResponseEntity<?>  getQR() {
        Whatsapp whatsapp = whatsappBean.getWhatsapp();
        WhatsappUtils utils = new WhatsappUtils();
        if (whatsapp == null) {
            return ResponseEntity.status(Response.SC_OK).body(utils.generateQR());
        }
        whatsapp.connect().join();
        if (whatsapp.isConnected()) {
            return ResponseEntity.status(Response.SC_OK).body("Already connected");
        }else{
            return ResponseEntity.status(Response.SC_OK).body("Connecting...");
        }
    }

    @GetMapping("logout")
    public ResponseEntity<?>  logout() {
        Whatsapp whatsapp = whatsappBean.getWhatsapp();
        if (whatsapp == null) {
            return ResponseEntity.status(Response.SC_OK).body(new JSONObject().put("message", "Not connected.").put("status",false).toMap());
        }
        System.out.println(whatsapp.store().about());
        try {
            if(whatsapp.isConnected()){
                whatsapp.disconnect().join();
                whatsapp.logout().join();
                whatsappBean.setWhatsapp(null);
                return ResponseEntity.status(Response.SC_OK).body(new JSONObject().put("message", "Logout has been done correctly, wait some minutes untill it actually logs out").put("status",false).toMap());
            }else{
                return ResponseEntity.status(Response.SC_OK).body(new JSONObject().put("message", "Not connected.").put("status",false).toMap());
            }

        } catch (Exception e) {
            logger.severe(e.getMessage());
            return ResponseEntity.status(Response.SC_INTERNAL_SERVER_ERROR).body(new JSONObject().put("message", "Logout has failed.").put("status",false).toMap());
        }
    }

    @GetMapping("status")
    public ResponseEntity<?>  status() {
        Whatsapp whatsapp = whatsappBean.getWhatsapp();
        if (whatsapp == null) {
            return ResponseEntity.status(Response.SC_OK).body(new JSONObject().put("message", "Not connected.").put("status",false).toMap());
        }
        try {
            if(whatsapp.isConnected()){
                return ResponseEntity.status(Response.SC_OK).body(new JSONObject().put("message", "Connected").put("status",true).toMap());
            }else{
                return ResponseEntity.status(Response.SC_OK).body(new JSONObject().put("message", "Not connected.").put("status",false).toMap());
            }
        } catch (Exception e) {
            logger.severe(e.getMessage());
            return ResponseEntity.status(Response.SC_INTERNAL_SERVER_ERROR).body(new JSONObject().put("message", "Status has failed.").put("status",false).toMap());
        }
    }

    @PostMapping(value = "send", consumes = MediaType.MULTIPART_FORM_DATA_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<?> send(@RequestParam Map<String, String> payload, @RequestParam Map<String, MultipartFile> files) {
        Whatsapp whatsapp = whatsappBean.getWhatsapp();
        if (whatsapp == null) {
            return ResponseEntity.status(Response.SC_OK).body(new JSONObject().put("message", "Whatsapp hasn't been initialized").put("status",false).toMap());
        }
        try{
            whatsapp.connect().join();
            if (whatsapp.isConnected()) {
                whatsappService.send(payload, files, whatsapp);
                return ResponseEntity.status(Response.SC_OK).body(payload);
            }else{
                return ResponseEntity.status(Response.SC_OK).body(new JSONObject().put("message", "Not connected.").put("status",false).toMap());
            }
        }catch (Exception e){
            logger.severe(e.getMessage());
            return ResponseEntity.status(Response.SC_INTERNAL_SERVER_ERROR).body(new JSONObject().put("message", "Message hasn't been sent.").put("status",false).toMap());
        }
    }

}
