package web.multitask.trismegistoservices.utils;

import lombok.AllArgsConstructor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Component
@AllArgsConstructor
public class RoutineUtils {

    private final web.multitask.trismegistoservices.singleton.threadLocalSingleton threadLocalSingleton;

//    public JSONObject routineExecutor(String routine, String database, Object[] params) {
//
//        String jdbcUrl;
//        JdbcTemplate jdbcTemplate = threadLocalSingleton.getJdbcTemplate();
//        try {
//            jdbcUrl = Objects.requireNonNull(jdbcTemplate.getDataSource()).getConnection().getMetaData().getURL();
//        } catch (Exception e) {
//            return new JSONObject().put("message", e.getMessage()).put("status", false);
//        }
//
//        switch (jdbcUrl.split(":")[1]) {
//            case "mysql":
//                return mysqlProcedure(routine, database, params, jdbcTemplate);
//            case "postgresql":
//                return postgreFunction(routine, database, params, jdbcTemplate);
//            default:
//                return new JSONObject().put("message", "Database not supported").put("status", false);
//        }
//    }

    public JSONObject mysqlProcedure(String routine, String database, JSONArray jsonArray, JdbcTemplate jdbcTemplate) {
        try {

            Object[] params = jsonArray.toList().toArray();
            StringBuilder query = new StringBuilder("CALL " + database + "." + routine);

            if (params.length > 0) {
                query.append("(");
                for (int i = 0; i < params.length; i++) {
                    query.append("?");
                    if (i < params.length - 1) {
                        query.append(",");
                    }
                }
                query.append(")");
            }

            String checkProcedure = "SELECT COUNT(*) FROM information_schema.routines WHERE routine_schema = '" + database + "' AND routine_name = '" + routine + "'";
            List<Map<String, Object>> countProcedure = jdbcTemplate.queryForList(checkProcedure);

            if (countProcedure.get(0).get("COUNT(*)").toString().equals("0")) {
                return new JSONObject().put("message", "Procedure not found").put("status", false);
            }

            List<Map<String, Object>> list = jdbcTemplate.queryForList(query.toString(), params);
            JSONObject result = new JSONObject();
            result.put("data", list);
            result.put("message", "Success");
            result.put("status", true);
            return result;
        } catch (Exception e) {
            return new JSONObject().put("data", new JSONObject()).put("message", e.getMessage()).put("status", false);
        }
    }

    public JSONObject postgreFunction(String routine, String database, Object[] params,JdbcTemplate jdbcTemplate) {
        try {
            StringBuilder query = new StringBuilder("SELECT * FROM " + database + "." + routine);

            if (params.length > 0) {
                query.append("(");
                for (int i = 0; i < params.length; i++) {
                    query.append("?");
                    if (i < params.length - 1) {
                        query.append(",");
                    }
                }
                query.append(")");
            }

            String checkFunction = "SELECT COUNT(*) FROM information_schema.routines WHERE routine_schema = '" + database + "' AND routine_name = '" + routine + "'";
            List<Map<String, Object>> countFunction = jdbcTemplate.queryForList(checkFunction);

            if (countFunction.get(0).get("count").toString().equals("0")) {
                return new JSONObject().put("message", "Function not found").put("status", false);
            }

            List<Map<String, Object>> list = jdbcTemplate.queryForList(query.toString(), params);
            JSONObject result = new JSONObject();
            result.put("data", list);
            result.put("message", "Success");
            result.put("status", true);
            return result;
        } catch (Exception e) {
            System.out.println(e.getMessage());
            return new JSONObject().put("data", new JSONObject()).put("message", e.getMessage()).put("status", false);
        }

    }
}