package web.multitask.trismegistoservices.services;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import org.json.JSONArray;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;

@Service
public class PDFService {

    public byte[] generatePdf(String htmlContent) throws Exception {
        ConverterProperties properties = new ConverterProperties();
        DefaultFontProvider fontProvider = new DefaultFontProvider(false, false, false);
        fontProvider.addFont("/fonts/Roboto-Regular.ttf");
        properties.setFontProvider(fontProvider);
        FileOutputStream outputStream = new FileOutputStream(System.getProperty("java.io.tmpdir") + "/pdf.pdf");
        HtmlConverter.convertToPdf(htmlContent, outputStream, properties);
        File file = new File(System.getProperty("java.io.tmpdir") + "/pdf.pdf");
        return org.apache.commons.io.FileUtils.readFileToByteArray(file);
    } 

}