package web.multitask.trismegistoservices.services.BBVA;

import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
public class bbvaService {

    bbvaUtils utils = new bbvaUtils();

    public JSONObject generalService(JSONObject json) {
        JSONObject jsonBillResponse = queryBill(json);
        if (jsonBillResponse.optBoolean("status", false)) {
            return generateQR(jsonBillResponse);
        } else {
            return jsonBillResponse;
        }
    }

    private JSONObject queryBill(JSONObject json) {

        JSONObject returnMessage = new JSONObject();

        int serviceID = json.optInt("service_id", 0);

        String actualServiceID;
        switch (serviceID) {
            case 1:
                actualServiceID = "00110010017221100";
                break;
            case 2:
                actualServiceID = "00110010017208000";
                break;
            case 3:
                actualServiceID = "00110010018991200";
                break;
            default:
                actualServiceID = "0";
                break;
        }

        String documentNumber = json.getString("document_number");
        String payerDocument = json.optString("payer_document", documentNumber);
        String endpoint = "/pe/bill-payments/v1/services/" + actualServiceID + "/bills";
        String queryParamater = "?billReference.value=" + documentNumber;
        String method = "get";

        JSONObject jsonRequest = new JSONObject();
        jsonRequest.put("endpoint", endpoint);
        jsonRequest.put("extra", queryParamater);
        jsonRequest.put("method", method);

        String token = utils.getToken();
        String digest = utils.hashDigest(jsonRequest.toString());
        String txt = utils.txtToSign(jsonRequest, digest);
        String signature = utils.createSignature(txt);

        JSONObject jsonResponse = utils.peticionHTTP(token, digest, signature, jsonRequest);
        JSONArray dataFound = jsonResponse.optJSONArray("data", new JSONArray());
        JSONObject firstElement = dataFound.optJSONObject(0, new JSONObject());

        if (firstElement.isEmpty()) {
            returnMessage.put("message", "No se encontró ninguna deuda");
            returnMessage.put("status", false);
            return returnMessage;
        }

        int month = json.optInt("month", 0);
        int year = json.optInt("year", 0);
        int amount = json.optInt("amount", 0);

        String monthString = utils.numberToMonth(month);
        String numberElement = firstElement.optString("number", "");
        if (!(numberElement.contains(monthString) && numberElement.contains(String.valueOf(year)))) {
            returnMessage.put("message", "La deuda viegente no coincide con el " + monthString + " de " + year);
            returnMessage.put("status", false);
            return returnMessage;
        }

        String maturityDate = json.optString("maturity_date", "");
        String maturityDateElement = firstElement.optString("maturityDate", "");
        if (!Objects.equals(maturityDateElement, maturityDate)) {
            returnMessage.put("message", "La deuda no tiene la fecha de vencimiento correcta - " + maturityDateElement);
            returnMessage.put("status", false);
            return returnMessage;
        }

        JSONArray amounts = firstElement.optJSONArray("amounts", new JSONArray());
        JSONObject firstAmount = amounts.optJSONObject(0, new JSONObject());
        JSONObject amountValue = firstAmount.optJSONObject("amountValue", new JSONObject());
        int amountElement = amountValue.optInt("amount", 0);
        if (amountElement != amount) {
            returnMessage.put("message", "El monto de la deuda no es correcto - " + amountElement);
            returnMessage.put("status", false);
            return returnMessage;
        }

        returnMessage.put("serviceId", actualServiceID);
        returnMessage.put("documentNumber", documentNumber);
        returnMessage.put("payerDocument", payerDocument);
        returnMessage.put("number", numberElement);
        returnMessage.put("amount", amountElement);
        returnMessage.put("maturityDate", maturityDateElement);
        returnMessage.put("status", true);

        return returnMessage;
    }

    public JSONObject generateQR(JSONObject json) {

        JSONObject returnMessage = new JSONObject();

        String endpoint = "/pe/request-to-pay/v1/qr";
        String method = "post";

        JSONObject body = new JSONObject();
        String serviceId = json.getString("serviceId");
        String billId = json.getString("documentNumber");
        String fullNumber = json.getString("number");
        String billNumber = fullNumber.length() > 40 ? fullNumber.substring(0, 40) : fullNumber;
        String billDocumentNumber = json.getString("payerDocument");
        String billDocumentType = "DNI";
        int amountsAmount = json.getInt("amount");
        String amountsCurrency = "PEN";
        String billMaturityDate = json.getString("maturityDate");
        String originContractId = "00110161000100022636";
        String productTypeId = "QR_CODE";
        String additionalPaymentFieldId = "0";
        String additionalPaymentFieldValue = json.getString("documentNumber");
        String serviceProvider = "ASOCIACION SACO OLIVEROS";
        String partnerId = "0022";
        String partnerEmail = "sistemas@sacooliveros.edu.pe";
        String partnerPhoneNumber = "993521358";
        String partnerTypeId = "AGENT";

        body.put("service", new JSONObject().put("id", serviceId));
        body.put("bills", new JSONArray().put(new JSONObject()
                .put("id", billId)
                .put("number", billNumber)
                .put("documentNumber", billDocumentNumber)
                .put("documentType", billDocumentType)
                .put("amounts", new JSONArray().put(new JSONObject().put("amount", amountsAmount).put("currency", amountsCurrency)))
                .put("maturityDate", billMaturityDate)));
        body.put("origin", new JSONObject()
                .put("contractId", originContractId)
                .put("productType", new JSONObject().put("id", productTypeId)));
        body.put("additionalFields", new JSONArray().put(new JSONObject()
                .put("additionalPaymentField", new JSONObject().put("id", additionalPaymentFieldId))
                .put("value", additionalPaymentFieldValue)));
        body.put("serviceProvider", serviceProvider);
        body.put("partner", new JSONObject()
                .put("id", partnerId)
                .put("email", partnerEmail)
                .put("phoneNumber", partnerPhoneNumber)
                .put("partnerType", new JSONObject().put("id", partnerTypeId)));

        JSONObject jsonRequest = new JSONObject()
                .put("body", body)
                .put("method", method)
                .put("endpoint", endpoint);

        String token = utils.getToken();
        String digest = utils.hashDigest(jsonRequest.toString());
        String txt = utils.txtToSign(jsonRequest, digest);
        String signature = utils.createSignature(txt);

        JSONObject jsonResponse = utils.peticionHTTP(token, digest, signature, jsonRequest);

        JSONObject qrCode = jsonResponse.optJSONObject("qrCode", new JSONObject());

        if (!qrCode.isEmpty()) {
            returnMessage.put("hashCode", qrCode.get("hashCode"));
            returnMessage.put("id", qrCode.get("id"));
            returnMessage.put("message", "Well-generated QRCode");
            returnMessage.put("status", true);
        } else {
            returnMessage.put("message", jsonResponse.get("message"));
            returnMessage.put("status", false);
        }

        return returnMessage;
    }

    public JSONObject getStatus(String id) {

        JSONObject returnMessage = new JSONObject();

        try {

            String endpoint = "/pe/request-to-pay/v1/qrs/" + id + "/status";
            String method = "get";

            JSONObject jsonRequest = new JSONObject()
                    .put("method", method)
                    .put("endpoint", endpoint);

            String token = utils.getToken();
            String digest = utils.hashDigest(jsonRequest.toString());
            String txt = utils.txtToSign(jsonRequest, digest);
            String signature = utils.createSignature(txt);

            JSONObject jsonResponse = utils.peticionHTTP(token, digest, signature, jsonRequest);

            JSONObject data = jsonResponse.optJSONObject("data", new JSONObject());

            if (!data.isEmpty()) {

                JSONObject billFirstElement = data.optJSONArray("bills", new JSONArray()).getJSONObject(0);

//                String billId = billFirstElement.getString("id");
                JSONObject statusBill = billFirstElement.optJSONObject("status", new JSONObject());
                String nameStatus = statusBill.getString("name");

                returnMessage.put("message", nameStatus); //nameStatus
                returnMessage.put("status", nameStatus.equals("ABONADO")); //nameStatus.equals("PAGADO")

            } else {
                returnMessage.put("message", "Id not found");
                returnMessage.put("status", false);
            }

            return returnMessage;
        } catch (Exception e) {
            returnMessage.put("message", e.getMessage());
            returnMessage.put("status", false);
            return returnMessage;
        }
    }

}
