// package web.multitask.app.api;
package web.multitask.trismegistoservices.rest;

import javax.mail.internet.MimeMessage;

import lombok.AllArgsConstructor;
import org.json.JSONObject;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import web.multitask.trismegistoservices.model.GmailRequest;
// import web.multitask.trismegistoservices.mysql.EmailMysql;
import web.multitask.trismegistoservices.services.google.GmailService;


@RestController
@RequestMapping("/gmail")
@AllArgsConstructor
public class emailRest {

    private final GmailService emailService;

    @RequestMapping(path = "/public/generate", method = RequestMethod.POST, consumes = {MediaType.MULTIPART_FORM_DATA_VALUE})
    public ResponseEntity<?> full(@ModelAttribute GmailRequest request) {
        try {
            MimeMessage message = emailService.htmlMessage(request);
            JSONObject response = emailService.send(message, request.getFrom());
            return ResponseEntity.ok(response.toMap());
        } catch (Exception e) {
            return ResponseEntity.internalServerError().body(new JSONObject().put("message", e.getMessage()).put("status", false).toMap());
        }
    }

}