package web.multitask.trismegistoservices.rest.BBVA;

import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import web.multitask.trismegistoservices.services.BBVA.bbvaService;
import web.multitask.trismegistoservices.services.BBVA.bbvaUtils;

@RestController
@CrossOrigin(origins = "*")
@RequestMapping("bbva")
public class bbvaRest {

    @PostMapping("/private/generate/qr")
    public ResponseEntity<?> generateQR(@RequestBody String json) {
        bbvaService service = new bbvaService();
        JSONObject jsonRequest = new JSONObject(json);
        JSONObject jsonResponse = service.generalService(jsonRequest);
        return ResponseEntity.ok(jsonResponse.toMap());
    }

    @GetMapping("/private/status/qr/{id}")
    public ResponseEntity<?> getStatus( @PathVariable String id) {
        bbvaService service = new bbvaService();
        JSONObject jsonResponse = service.getStatus(id);
        return ResponseEntity.ok(jsonResponse.toMap());
    }

    @PostMapping("/private/prepareRequest")
    public ResponseEntity<?> getHeader(@RequestBody String json) {
        bbvaUtils utils = new bbvaUtils();
        String token = utils.getToken();
        JSONObject jsonObject = new JSONObject(json);
        if(token.isEmpty()){
            return ResponseEntity.internalServerError().body(
                    new JSONObject()
                            .put("token","")
                            .put("message","No token generated")
                            .put("status",false));

        }else{
            String digest = utils.hashDigest(json);
            String txt = utils.txtToSign(jsonObject ,digest);
            String signature = utils.createSignature(txt);
            System.out.println("token = "+token);
            System.out.println("digest = "+digest);
            System.out.println("signature = "+signature);
            return ResponseEntity.ok(utils.peticionHTTP(token,digest,signature,jsonObject).toMap());
        }
    }

}

