package web.multitask.trismegistoservices.controller;


import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;
import web.multitask.trismegistoservices.model.Message;
import web.multitask.trismegistoservices.model.Response;

import java.util.Date;

@Controller
public class MessageController {

    @MessageMapping("/{project}/{topic}")
    @SendTo("/topic/message/{project}/{topic}")
    public Response envio(@DestinationVariable String project, @DestinationVariable String topic, Message message) {
        try {
            return new Response(message.getUser(), project, topic, message.getContent(), new Date().toString());
        } catch (Exception e) {
            return new Response("Error", project, topic, "Error", new Date().toString());
        }
    }
}