package web.multitask.trismegistoservices.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class dotEnvUtils {

    static String detectedOS;

    private static final Map<String, String> OS_PATH_MAP = new HashMap<>();

    static {
        OS_PATH_MAP.put("MacOS", "/opt/dotenv/");
        OS_PATH_MAP.put("Linux", "/opt/dotenv/");
        OS_PATH_MAP.put("Windows", "abcdefghijklmnopqrstuvwxyz");
    }


    public static String getOperatingSystemType() {
        return detectedOS != null ? detectedOS :
                (detectedOS = getOSFromSystemProperty());
    }

    private static String getOSFromSystemProperty() {
        if (detectedOS == null) {
            String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            if (osName.contains("mac") || osName.contains("darwin")) detectedOS = "MacOS";
            else if (osName.contains("win")) detectedOS = "Windows";
            else if (osName.contains("nux")) detectedOS = "Linux";
            else detectedOS = "Other";
        }
        return detectedOS;
    }

    public static String getDotEnvPath(String projectName) {
        String osType = getOperatingSystemType();
        return OS_PATH_MAP.getOrDefault(osType, "") +
                ("Windows".equals(osType) ? getWindowsPath(projectName) : projectName);
    }

    private static String getWindowsPath(String projectName) {
        return OS_PATH_MAP.get("Windows")
                .chars()
                .mapToObj(letter -> "/" + (char) letter + ":/dotenv/" + projectName)
                .filter(path -> new File(path).exists())
                .findFirst()
                .orElse("");
    }

}