package web.multitask.trismegistoservices.singleton;

import lombok.Getter;
import lombok.NoArgsConstructor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import web.multitask.trismegistoservices.utils.tokenUtils;

@Getter
@Component
@NoArgsConstructor
public class tokenSingleton {

    private final JSONArray tokens = new JSONArray();

    @Autowired
    private tokenUtils jwtTokenUtil;

    public boolean consumeToken(String token) {
        boolean isAvailable = false;
        for (int i = 0; i < tokens.length(); i++) {
            if (tokens.getJSONObject(i).getString("token").equals(token)) {
                if (tokens.getJSONObject(i).getBoolean("available")) {
                    tokens.getJSONObject(i).put("available", false);
                    isAvailable = true;
                }
                break;
            }
        }
        return isAvailable;
    }

    public boolean isTokenAvailable(String token) {
        boolean isAvailable = true;
        for (int i = 0; i < tokens.length(); i++) {
            if (tokens.getJSONObject(i).getString("token").equals(token)) {
                isAvailable = tokens.getJSONObject(i).getBoolean("available");
                break;
            }
        }
        return isAvailable;
    }

    public void addToken(String token) {
        tokens.put(new JSONObject().put("token", token).put("available", true));
    }

    @Scheduled(fixedRate = 3600000)
    public void removeUnavailableTokens() {
        System.out.println("Removing unavailable tokens");
        for(int i = 0; i < tokens.length(); i++){
            if(!tokens.getJSONObject(i).getBoolean("available") || jwtTokenUtil.isTokenExpired(tokens.getJSONObject(i).getString("token"))){
                System.out.println("Token removed "+tokens.remove(i));
            }
        }
    }
}
