package web.multitask.trismegistoservices.singleton;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class threadLocalSingleton {
    private final ThreadLocal<JdbcTemplate> jdbcTemplateThreadLocal = new ThreadLocal<>();

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        jdbcTemplateThreadLocal.set(jdbcTemplate);
    }

    public JdbcTemplate getJdbcTemplate() {
        JdbcTemplate jdbcTemplate = jdbcTemplateThreadLocal.get();
        if (jdbcTemplate == null) {
            jdbcTemplate = new JdbcTemplate();
            jdbcTemplateThreadLocal.set(jdbcTemplate);
        }
        return jdbcTemplate;
    }

}
