package web.multitask.trismegistoservices.services.google;

 import java.io.ByteArrayOutputStream;
 import java.io.FileOutputStream;
 import java.io.UnsupportedEncodingException;
 import com.google.api.client.util.Base64;

 import java.util.Arrays;
 import java.util.Objects;
 import java.util.Properties;
 import java.util.stream.Collectors;
 import java.util.stream.Stream;
 import javax.activation.DataHandler;
 import javax.activation.FileDataSource;
 import javax.mail.BodyPart;
 import javax.mail.MessagingException;
 import javax.mail.Session;
 import javax.mail.internet.AddressException;
 import javax.mail.internet.InternetAddress;
 import javax.mail.internet.MimeBodyPart;
 import javax.mail.internet.MimeMessage;
 import javax.mail.internet.MimeMultipart;

 import com.google.api.services.gmail.model.Message;
 import org.json.JSONObject;
 import org.springframework.stereotype.Service;
 import org.springframework.web.multipart.MultipartFile;
 import web.multitask.trismegistoservices.config.GoogleConfig;
 import web.multitask.trismegistoservices.model.GmailRequest;

@Service
 public class GmailService {

    private final GoogleConfig googleConfig;

    public GmailService(GoogleConfig googleConfig) {
        this.googleConfig = googleConfig;
    }

    Properties props = new Properties();
    Session session = Session.getDefaultInstance(props, null);
     public MimeMessage htmlMessage(GmailRequest request) throws UnsupportedEncodingException {
         try {
             MimeMessage message = new MimeMessage(session);
             String alias = (request.getAlias() == null || request.getAlias().isEmpty()) ? request.getFrom() : request.getAlias();
             message.setFrom(new InternetAddress(
                     request.getFrom(),  alias
             ));
             message.setSender(new InternetAddress(
                     request.getFrom(),alias
             ));
             message.setRecipients(MimeMessage.RecipientType.TO,
                     buildRecipients(new JSONObject().put("to", request.getTo()), "to"));
             if (request.getCc() != null) {
                 message.setRecipients(MimeMessage.RecipientType.CC,
                         buildRecipients(new JSONObject().put("cc", request.getCc()), "cc"));
             }
             if (request.getBcc() != null) {
                 message.setRecipients(MimeMessage.RecipientType.BCC,
                         buildRecipients(new JSONObject().put("bcc", request.getBcc()), "bcc"));
             }
             message.setSubject(request.getSubject());
             MimeBodyPart texto = new MimeBodyPart();
             texto.setContent(request.getBody(), "text/html; charset=utf-8");
             MimeMultipart multiParte = new MimeMultipart();
             multiParte.addBodyPart(texto);
             try {
                 String file_folder = System.getProperty("java.io.tmpdir");
                 MultipartFile[] files = request.getFiles();
                 for (MultipartFile file : files) {
                     BodyPart adjunto = new MimeBodyPart();
                     String fileName = file.getOriginalFilename();
                     convertByteArrayToFile(file.getBytes(), fileName, file_folder);
                     FileDataSource fds = new FileDataSource(file_folder +"/"+ fileName);
                     adjunto.setDataHandler(new DataHandler(fds));
                     adjunto.setFileName(fds.getName());
                     multiParte.addBodyPart(adjunto);
                 }
             } catch (Exception e) {
                 System.out.println(e.getMessage());
             }
             message.setContent(multiParte);
             return message;
         } catch (MessagingException e) {
             System.out.println(e.getMessage());
             return null;
         }
     }

     public void convertByteArrayToFile (byte[] byteArray, String fileName, String file_folder){
         try (FileOutputStream fos = new FileOutputStream(file_folder +"/"+ fileName)) {
             fos.write(byteArray);
         }catch(Exception e){
             System.out.println(e.getMessage());
         }
     }

     public JSONObject send(MimeMessage email,String from) {
         try {
             ByteArrayOutputStream baos = new ByteArrayOutputStream();
             email.writeTo(baos);
             String encodedEmail = Base64.encodeBase64URLSafeString(baos.toByteArray());
             Message message = new Message();
             message.setRaw(encodedEmail);
             System.out.println(googleConfig.getGmail(from).users().messages().send("me", message).execute());
             return new JSONObject().put("message", "Email enviado correctamente").put("status", true);
         } catch (Exception e) {
             System.out.println(e.getMessage());
             return new JSONObject().put("message", e.getMessage()).put("status", false);
         }
     }

     public InternetAddress[] buildRecipients(JSONObject json, String type) {
         String[] recipients = json.optString(type).split(",");
         InternetAddress[] addresses = new InternetAddress[recipients.length];
         Stream.of(recipients).map(recipient -> {
             try {
                 return new InternetAddress(recipient);
             } catch (AddressException e) {
                 System.out.println(e.getMessage());
                 return null;
             }
         }).filter(Objects::nonNull).collect(Collectors.toList()).toArray(addresses);
         return addresses;
     }


 }