package web.multitask.trismegistoservices.services.google;

import java.io.*;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import lombok.AllArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import com.google.api.client.http.InputStreamContent;
import com.google.api.services.drive.model.File;

import web.multitask.trismegistoservices.config.GoogleConfig;
import web.multitask.trismegistoservices.interfaces.IDriveService;
import web.multitask.trismegistoservices.utils.CommonUtils;

import javax.annotation.Nullable;

@Service
@AllArgsConstructor
public class DriveService implements IDriveService {

    private final GoogleConfig googleConfig;
    private final CommonUtils commonUtils;

    @Override
    public String uploadFile(String folder_id, @Nullable String file_name, MultipartFile file, String base64) {
        try {
            if (null != file) {
                File fileMetadata = new File();
                fileMetadata.setParents(Collections.singletonList(folder_id));
                fileMetadata.setName( file_name == null ? file.getOriginalFilename() : file_name);
                File uploadFile = googleConfig.getDrive()
                        .files()
                        .create(fileMetadata, new InputStreamContent(
                                file.getContentType(),
                                new ByteArrayInputStream(file.getBytes())))
                        .setFields("id").execute();
                return uploadFile.getId();
            }else if (!base64.isEmpty()) {
                java.io.File fileBytes = commonUtils.base64ToFile(base64,file_name);
                File fileMetadata = new File();
                fileMetadata.setParents(Collections.singletonList(folder_id));
                fileMetadata.setName(file_name);
                File uploadFile = googleConfig.getDrive()
                        .files()
                        .create(fileMetadata, new InputStreamContent(
                                MediaType.APPLICATION_OCTET_STREAM_VALUE,
                                Files.newInputStream(fileBytes.toPath())))
                        .setFields("id").execute();
                return uploadFile.getId();
            }else{
                return null;
            }
        } catch (Exception e) {
            System.out.printf("Error: " + e);
        }
        return null;
    }

    @Override
    public ResponseEntity<?> getFile(String file_id, Boolean base64) {
        try {
            File file = googleConfig.getDrive().files().get(file_id).execute();
            InputStream inputStream = googleConfig.getDrive().files().get(file_id).executeMediaAsInputStream();
            String uudi = java.util.UUID.randomUUID().toString();
            String nameFile;
            boolean isHasExtension = false;
            try{
                nameFile = System.getProperty("java.io.tmpdir") + "/" + uudi + "." + file.getName().split("\\.")[1];
                isHasExtension = true;
            }catch(Exception e){
                nameFile = System.getProperty("java.io.tmpdir") + "/" + uudi + ".pdf";
            }
            java.io.File tempFile = new java.io.File(nameFile);
            try (FileOutputStream fos = new FileOutputStream(tempFile)) {
                byte[] buffer = new byte[1024];
                int bytesRead;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            if (base64) {
                String base64String = commonUtils.fileToBase64(tempFile);
                tempFile.delete(); // Eliminación inmediata en modo Base64
                return ResponseEntity.ok().body(
                        new JSONObject()
                                .put("base64", base64String)
                                .put("file_name", file.getName() + (isHasExtension ? "" : ".pdf"))
                                .put("status", true)
                                .put("message", "OK").toMap()
                );
            } else {
                Resource resource = commonUtils.fileToResource(tempFile);
                HttpHeaders headers = new HttpHeaders();

                headers.set(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\"" + file.getName() + "\"");
                headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);

                CompletableFuture.runAsync(() -> {
                    try {
                        Thread.sleep(15000);
                        if (tempFile.exists()) {
                            tempFile.delete();
                        }
                    } catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });

                return ResponseEntity.ok()
                        .headers(headers)
                        .contentLength(tempFile.length())
                        .body(resource);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getZip(JSONArray reqArrFiles) {
        String tempDirPath = System.getProperty("java.io.tmpdir") + "/" + java.util.UUID.randomUUID();
        java.io.File tempDir = new java.io.File(tempDirPath);

        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }

        ExecutorService executor = Executors.newFixedThreadPool(20);

        /*int numCores = Runtime.getRuntime().availableProcessors();
        int maxThreads = 30;

        ExecutorService executor = Executors.newFixedThreadPool(Math.min(numCores * 2, maxThreads));*/

        try {
            List<CompletableFuture<Void>> futures = new ArrayList<>();

            for (int i = 0; i < reqArrFiles.length(); i++) {
                JSONObject reqFile = reqArrFiles.getJSONObject(i);
                String fileName = reqFile.getString("file_name");
                String fileId = reqFile.getString("file_id");

                futures.add(CompletableFuture.runAsync(() -> {
                    try (InputStream inputStream = googleConfig.getDrive().files().get(fileId).executeMediaAsInputStream();
                         FileOutputStream fos = new FileOutputStream(new java.io.File(tempDir, fileName))) {

                        byte[] buffer = new byte[1024];
                        int bytesRead;
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            fos.write(buffer, 0, bytesRead);
                        }
                    } catch (Exception e) {
                        throw new RuntimeException("Error al descargar archivo: " + fileName, e);
                    }
                }, executor));
            }

            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();

            ByteArrayOutputStream byteArrayOutputStream = CommonUtils.getByteArrayOutputStream(tempDir);

            for (java.io.File file : Objects.requireNonNull(tempDir.listFiles())) {
                file.delete();
            }
            tempDir.delete();

            return byteArrayOutputStream.toByteArray();
        } catch (Exception e) {
            throw new RuntimeException("Error al crear el ZIP", e);
        } finally {
            executor.shutdown();
        }
    }

    @Override
    public String createFolder(String folder_id, String folder_name) {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Unimplemented method 'createFolder'");
    }

    @Override
    public String deleteFile(String file_id) {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Unimplemented method 'deleteFile'");
    }

    @Override
    public String deleteFolder(String folder_id) {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Unimplemented method 'deleteFolder'");
    }

    @Override
    public String getFolder(String folder_id) {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException("Unimplemented method 'getFolder'");
    }
}