package web.multitask.trismegistoservices.rest;

import lombok.AllArgsConstructor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import web.multitask.trismegistoservices.mysql.RoutineSql;

@RestController
@CrossOrigin("*")
@RequestMapping("/api")
@AllArgsConstructor
public class routineRest {

    final RoutineSql procedureMysql;

    @PostMapping("/public/routine")
    public ResponseEntity<?> callRoutine(@RequestBody String body) {
        JSONObject json = new JSONObject(body);
        if (json.has("routine")) {
            try {
                JSONArray params = json.isNull("params") ? new JSONArray() : json.getJSONArray("params");
                String routine = json.getString("routine");
                String database = json.optString("database");
                JSONObject response = procedureMysql.routineExecutor(routine,
                        database,
                        params.toList().toArray());
                return ResponseEntity.ok(response.toMap());
            } catch (Exception e) {
                return ResponseEntity.internalServerError().body(new JSONObject().put("message", e.getMessage()).put("status", false).toMap());
            }
        } else {
            return ResponseEntity.badRequest().body(new JSONObject().put("message", "Invalid Request").put("status", false).toMap());
        }
    }

}