package web.multitask.trismegistoservices.rest;

import org.json.JSONObject;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import lombok.AllArgsConstructor;
import web.multitask.trismegistoservices.services.PDFService;
import web.multitask.trismegistoservices.utils.CommonUtils;

@RestController
@CrossOrigin(origins = "*")
@RequestMapping("/pdf")
@AllArgsConstructor
public class pdfRest {

    PDFService pdfService;
    CommonUtils commonUtils;

    @PostMapping("/public/html")
    public ResponseEntity<?> htmlToPdf(@RequestBody String json) {
        try {

            JSONObject jsonBody = new JSONObject(json);
            byte[] bytes = pdfService.generatePdf(jsonBody.getString("html"));

            if(jsonBody.optBoolean("base64")){
                String base64 = commonUtils.byteToBase64(bytes);
                return ResponseEntity.ok().body(
                    new JSONObject()
                    .put("base64", base64)
                    .put("file_name", jsonBody.optString("file_name", "pdf.pdf"))
                    .put("status", true)
                    .put("message", "OK")
                );
            }else{
                Resource resource = commonUtils.byteToResource(bytes, jsonBody.optString("file_name", "no_name.pdf"));
                HttpHeaders headers = new HttpHeaders();
                headers.add(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=" + jsonBody.optString("file_name", "no_name.pdf"));
                return ResponseEntity.ok()
                .headers(headers)
                .contentLength(bytes.length)
                .contentType(MediaType.APPLICATION_PDF)
                .body(resource);
            }
        }catch (Exception e){
            System.out.println(e);
            return ResponseEntity.internalServerError().body(e.getMessage());
        }
    }

}