package web.multitask.trismegistoservices.rest;

import org.json.JSONObject;
import lombok.AllArgsConstructor;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import web.multitask.trismegistoservices.services.ExcelService;
import web.multitask.trismegistoservices.utils.CommonUtils;

import java.io.IOException;

@RestController
@CrossOrigin(origins = "*")
@RequestMapping("excel")
@AllArgsConstructor
public class excelRest {

    ExcelService excelService;
    CommonUtils commonUtils;

    @PostMapping("/public/generate")
    public ResponseEntity<?> generateExcel(@RequestBody String json) throws IOException {
        try {
            JSONObject jsonBody = new JSONObject(json);
            int size = json.getBytes().length;
            System.out.println("Size: " + size);
            byte[] excelByte = excelService.generateExcel(jsonBody, size);
            if(excelByte == null) {
                return ResponseEntity.internalServerError().body("Error al generar el archivo");
            }
            if (jsonBody.optBoolean("base64", false)) {
                JSONObject response = new JSONObject();
                response.put("file_name", jsonBody.optString("file_name", "no_name.xlsx"));
                response.put("base64", commonUtils.byteToBase64(excelByte));
                response.put("message", "OK");
                response.put("status", true);
                return ResponseEntity.ok().body(response.toMap());
            } else {
                Resource resource = excelService.convertByteToResource(excelByte, jsonBody.optString("file_name", "no_name.xlsx"));
                HttpHeaders headers = new HttpHeaders();
                headers.add(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=" + jsonBody.optString("file_name", "no_name.xlsx"));
                headers.add(HttpHeaders.CONTENT_TYPE, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                return ResponseEntity.ok()
                        .headers(headers)
                        .contentLength(excelByte.length)
                        .body(resource);
            }
        } catch (Exception e) {
            return ResponseEntity.internalServerError().body(e.getMessage());
        }
    }
}