package web.multitask.trismegistoservices.rest;


import lombok.AllArgsConstructor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import web.multitask.trismegistoservices.model.DriveRequest;
import web.multitask.trismegistoservices.services.google.DriveService;
import javax.annotation.Nullable;

@RestController
@CrossOrigin(origins = "*")
@RequestMapping("drive")
@AllArgsConstructor
public class driveRest {

    DriveService driveService;

    @PostMapping(path = "/public/upload", consumes = {MediaType.MULTIPART_FORM_DATA_VALUE})
    public ResponseEntity<?> uploadFile(@ModelAttribute DriveRequest request) {
        try {
            String folder_id = request.getFolder_id();
            String file_name = request.getFile_name();
            MultipartFile file = request.getFile();
            String base64 = request.getBase64();
            String id_file_response = driveService.uploadFile(folder_id, file_name, file, base64);
            JSONObject response = new JSONObject();
            if (id_file_response == null) {
                response.put("status", false);
                response.put("message", "The file could not be uploaded. There are multiple reasons why this may occur. Please check that the file is not too large, that the format is correct, or that you have permission in the folder.");
                return ResponseEntity.badRequest().body(response.toMap());
            } else {
                response.put("status", true);
                response.put("message", "File uploaded successfully.");
                response.put("file_id", id_file_response);
                response.put("file_url", "https://drive.google.com/file/d/" + id_file_response + "/view?usp=sharing");
                response.put("download_url", "https://drive.google.com/uc?export=download&id="+id_file_response);
                return ResponseEntity.ok(response.toMap());
            }
        } catch (Exception e) {
            return ResponseEntity.internalServerError().body(e.getMessage());
        }
    }

    @GetMapping(path = "/public/download/{id}")
    public ResponseEntity<?>  downloadFile(@PathVariable String id, @Nullable @RequestParam(name = "base64") Boolean base64) {
        return driveService.getFile(id, !(base64 == null));
    }

    @PostMapping("/public/download/zip")
    public ResponseEntity<?> downloadZip(@RequestBody String json) {
        try {
            JSONArray arrBody = new JSONArray(json);
            byte[] zip = driveService.getZip(arrBody);

            return ResponseEntity.ok().body(zip);
        } catch (Exception e) {
            return ResponseEntity.internalServerError().body(e.getMessage());
        }
    }


}