package web.multitask.trismegistoservices.repository;

import org.springframework.security.core.userdetails.UserDetails;
import web.multitask.trismegistoservices.model.Role;
import web.multitask.trismegistoservices.model.User;

import java.util.*;

public class UserRepository{

    private final HashMap<String, User> users = new HashMap<>();
    Set<Role> roles = new HashSet<>();

    public UserRepository(){
        roles.add(new Role(1, "ADMIN"));
        roles.add(new Role(2, "USER"));
        roles.add(new Role(3, "SERVICE"));

        User user = new User();
        user.setUsername("admin");
        user.setId(1L);
        user.setPassword("admin");
        user.setRoles(roles);
        users.put("admin", user);
    }

    public UserDetails findByUsername(String username){
        return users.get(username);
    }

}