package web.multitask.trismegistoservices.config;

import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import web.multitask.trismegistoservices.filter.JWTokenFilter;
import web.multitask.trismegistoservices.utils.tokenUtils;

@Configuration
@EnableWebSecurity
@AllArgsConstructor
public class SecurityConfig{

    private final tokenUtils jwtTokenUtil;
    private final web.multitask.trismegistoservices.singleton.tokenSingleton tokenSingleton;
    private web.multitask.trismegistoservices.singleton.threadLocalSingleton threadLocalSingleton;

    @Bean
    AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration)
            throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Bean
    SecurityFilterChain configure(HttpSecurity http) throws Exception {
        http.cors(AbstractHttpConfigurer::disable).csrf(AbstractHttpConfigurer::disable)
                .sessionManagement(management -> management.sessionCreationPolicy(SessionCreationPolicy.STATELESS))
                .authorizeHttpRequests(
                        authorizeRequests -> authorizeRequests
                                .antMatchers("/security/**").hasAnyAuthority("ADMIN")
                                .regexMatchers(".*/private/.*").hasAnyAuthority("ADMIN", "USER")
                                .regexMatchers(".*/public/.*").permitAll()
                                .regexMatchers(".*/service/.*").hasAnyAuthority("ADMIN", "SERVICE")
                                .antMatchers(HttpMethod.GET, "/**").permitAll()
                                .antMatchers("/token/**").permitAll());
        http.addFilterBefore(new JWTokenFilter(jwtTokenUtil, tokenSingleton,threadLocalSingleton), UsernamePasswordAuthenticationFilter.class);
        return http.build();
    }

    @Bean
    PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter(source);
    }

}