package web.multitask.trismegistoservices.utils;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import org.springframework.stereotype.Component;
import web.multitask.trismegistoservices.model.User;

@Component
public class tokenUtils implements Serializable{

    @Value("${app.jwtSecret}")
    private String jwtSecret;
    @Value("${app.jwtSecret2}")
    private String jwtSecret2;

    public String generateToken(User user, BigInteger ms,boolean onelife) {
        JSONObject json = new JSONObject();
        json.put("username", user.getUsername());

        if(ms == null){
            ms = BigInteger.valueOf(3600000);
        }
        Date expirationDate = new Date(System.currentTimeMillis() + ms.longValue());

        return Jwts.builder()
                .setSubject(json.toString()) 
                .setIssuedAt(new Date())
                .setExpiration(expirationDate)
                .signWith(Keys.hmacShaKeyFor(onelife ? jwtSecret2.getBytes() : jwtSecret.getBytes()))
                .compact();
    }

    public String tokenizeData(String data, BigInteger ms,boolean onelife){
        Date expirationDate = new Date(System.currentTimeMillis() + ms.longValue());
        JwtBuilder jwtBuilder = Jwts.builder();
        jwtBuilder.setSubject(data);
        jwtBuilder.setIssuedAt(new Date());
        if(!ms.equals(BigInteger.valueOf(0))){
            jwtBuilder.setExpiration(expirationDate);
        }
        jwtBuilder.signWith(Keys.hmacShaKeyFor(onelife ? jwtSecret2.getBytes() : jwtSecret.getBytes()));
        return jwtBuilder.compact();
    }

    public String detokenizeData(String token) {
        String tokenReturned = "";
        try {
            tokenReturned = getSubjectIgnoringExpiration(token, jwtSecret);
        } catch (Exception e) {
            try {
                tokenReturned = getSubjectIgnoringExpiration(token, jwtSecret2);
            } catch (Exception e2) {
                System.out.println("No se pudo decodificar el token con ninguna clave: " + e2.getMessage());
            }
        }
        return tokenReturned;
    }

    private String getSubjectIgnoringExpiration(String token, String secret) {
        try {
            // Parsea normalmente
            return Jwts.parserBuilder()
                    .setSigningKey(Keys.hmacShaKeyFor(secret.getBytes()))
                    .build()
                    .parseClaimsJws(token)
                    .getBody()
                    .getSubject();
        } catch (ExpiredJwtException e) {
            // Si está expirado, aún así devuelve el subject
            return e.getClaims().getSubject();
        }
    }


    public String generateDataSource(JSONObject json){
        String dataReturned = "";

        try{
            dataReturned = Jwts.builder()
                .setSubject(json.toString())
                .setIssuedAt(new Date())
                .setExpiration(new Date(new Date().getTime() + 36000000))
                .signWith(Keys.hmacShaKeyFor(jwtSecret.getBytes()))
                .compact();
        }catch (Exception e){
                System.out.println(e.getMessage());

        }
        return dataReturned;
    }

    public boolean validateToken(String token) {
        try {
            Jwts.parserBuilder()
                    .setSigningKey(Keys.hmacShaKeyFor(jwtSecret.getBytes()))
                    .build()
                    .parseClaimsJws(token);
            return true;
        } catch (Exception e) {
                System.out.println(e.getMessage());
                return false;
        }
    }

    public String getDataToken(String token) {
        try {
            return Jwts.parserBuilder()
                    .setSigningKey(Keys.hmacShaKeyFor(jwtSecret.getBytes()))
                    .build()
                    .parseClaimsJws(token)
                    .getBody().getSubject();
        } catch (ExpiredJwtException expiredJwtException) {
            return expiredJwtException.getClaims().getSubject();
        } catch (Exception e) {
            try{
                return Jwts.parserBuilder()
                        .setSigningKey(Keys.hmacShaKeyFor(jwtSecret2.getBytes()))
                        .build()
                        .parseClaimsJws(token)
                        .getBody().getSubject();
            }catch (Exception e2){
                System.out.println(e2.getMessage());
                return null;
            }
        }
    }

    public boolean isTokenExpired(String token) {
        try {
            Jwts.parserBuilder()
                    .setSigningKey(Keys.hmacShaKeyFor(jwtSecret.getBytes()))
                    .build()
                    .parseClaimsJws(token)
                    .getBody()
                    .getExpiration();
            return false;
        } catch (Exception e) {
            try {
                Jwts.parserBuilder()
                        .setSigningKey(Keys.hmacShaKeyFor(jwtSecret2.getBytes()))
                        .build()
                        .parseClaimsJws(token)
                        .getBody()
                        .getExpiration();
                return false;
            } catch (Exception e2) {
                System.out.println(e2.getMessage());
                return true;
            }
        }
    }

    public Long getExperyTime(String token){
        try{
            return  ((Jwts.parserBuilder()
                    .setSigningKey(Keys.hmacShaKeyFor(jwtSecret.getBytes()))
                    .build()
                    .parseClaimsJws(token)
                    .getBody()
                    .getExpiration()
                    .getTime() - new Date().getTime()));
        }catch (Exception e){
            return ((Jwts.parserBuilder()
                    .setSigningKey(Keys.hmacShaKeyFor(jwtSecret2.getBytes()))
                    .build()
                    .parseClaimsJws(token)
                    .getBody()
                    .getExpiration()
                    .getTime() - new Date().getTime()));
        }
    }
}