package web.multitask.trismegistoservices.utils;

import io.github.cdimascio.dotenv.Dotenv;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Component;
import javax.sql.DataSource;

@Component
public class DataSourceUtils {

    private final Dotenv dotenv;
    public DataSourceUtils(Dotenv dotenv) {
        this.dotenv = dotenv;
    }

    public DataSource getDataSourceByName(String connectionName) {
        String normalizedName = connectionName.toUpperCase();
        String suffix;
        switch (normalizedName) {
            case "TP":
                suffix = "NUEVO";
                break;
            default:
                throw new IllegalArgumentException("Invalid connection name: " + connectionName + ". Must be 'nuevo' or 'sacoolive3'.");
        }
        return createDataSource(suffix, normalizedName);
    }

    private DataSource createDataSource(String suffix, String connectionName) {

        // Construct the variable keys dynamically
        String host = dotenv.get("MYSQL_TRISMEGISTOASISTENCIA_DB_" + suffix);
        String port = dotenv.get("MYSQL_TRISMEGISTOASISTENCIA_DB_PORT_" + suffix);
        String databaseName = dotenv.get("MYSQL_TRISMEGISTOASISTENCIA_DB_NAME_" + suffix);
        String username = dotenv.get("MYSQL_TRISMEGISTOASISTENCIA_DB_USER_" + suffix);
        String password = dotenv.get("MYSQL_TRISMEGISTOASISTENCIA_DB_PASS_" + suffix);

        if (host == null || port == null || databaseName == null || username == null || password == null) {
            throw new IllegalStateException(
                    "Missing required environment variables for " + connectionName + " connection."
            );
        }

        DriverManagerDataSource dataSource = new DriverManagerDataSource();

        String url = String.format("jdbc:mysql://%s:%s/%s?useSSL=false&serverTimezone=UTC",
                host, port, databaseName);

        dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);

        return dataSource;
    }
}
