package web.multitask.trismegistoservices.services.MH;

import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import web.multitask.trismegistoservices.utils.RoutineUtils;
import web.multitask.trismegistoservices.utils.DataSourceUtils;

import javax.sql.DataSource;

@Service
public class MHService {

    private final JdbcTemplate jdbcTemplate = new JdbcTemplate();
    private final DataSourceUtils dataSourceUtils;
    private final RoutineUtils routineUtils;
    public MHService( DataSourceUtils dataSourceUtils, RoutineUtils routineUtils) {
        this.dataSourceUtils = dataSourceUtils;
        this.routineUtils = routineUtils;
    }

    public JSONObject consultarTrabajador(JSONObject json){
        JSONObject response = new JSONObject();
        try{
        DataSource dataSource = dataSourceUtils.getDataSourceByName("tp");
        jdbcTemplate.setDataSource(dataSource);
        String p_opcion = json.optString("opcion");
        String p_numero_documento = json.optString("numero_documento");
        String p_tipo_documento = json.optString("tipo_documento");
        JSONArray params = new JSONArray();
        params.put(p_opcion);
        params.put(p_numero_documento);
        params.put(p_tipo_documento);
        response = routineUtils.mysqlProcedure("SP_TP_REST_DATOS_PERSONAL_MH", "nuevo", params, jdbcTemplate);
        JSONArray data = response.optJSONArray("data", new JSONArray());
        if(data.isEmpty()){
            return response;
        }else{
            JSONObject first = data.optJSONObject(0);
            first.put("status", first.optInt("status",0) == 1);
            return first;
        }
    } catch (Exception e) {
        response.put("status", false)
                .put("message", e.getMessage());
    }
        return response;
    }

    public JSONObject registrarVenta(JSONObject json){
        JSONObject response = new JSONObject();
        try{
            DataSource dataSource = dataSourceUtils.getDataSourceByName("tp");
            jdbcTemplate.setDataSource(dataSource);
            String p_numero_documento = json.optString("numero_documento");
            String p_tipo_documento = json.optString("tipo_documento");
            String p_observacion = json.optString("observacion");
            Double p_monto = json.optDouble("monto");
            int p_cuotas = json.optInt("cuotas");
            JSONArray params = new JSONArray()
                    .put(p_numero_documento)
                    .put(p_tipo_documento)
                    .put(p_observacion)
                    .put(p_monto)
                    .put(p_cuotas);
            response = routineUtils.mysqlProcedure("SP_TP_REST_REGISTRAR_VENTA_PERSONAL", "nuevo", params, jdbcTemplate);
            JSONArray data = response.optJSONArray("data", new JSONArray());
            if(data.isEmpty()){
                return response;
            }else{
                JSONObject first = data.optJSONObject(0);
                first.put("status", first.optInt("status",0) == 1);
                return first;
            }
        } catch (Exception e) {
            response.put("status", false)
                    .put("message", e.getMessage());
        }
        return response;
    }
}
