package web.multitask.trismegistoservices.rest.MH;

import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;
import web.multitask.trismegistoservices.services.MH.MHService;
import web.multitask.trismegistoservices.utils.DataSourceUtils;
import web.multitask.trismegistoservices.utils.RoutineUtils;

@RestController
@CrossOrigin(origins = "*")
@RequestMapping("mh")
public class MHRest {

    private final DataSourceUtils dataSourceUtils;
    private final RoutineUtils routineUtils;

    public MHRest(DataSourceUtils dataSourceUtils, RoutineUtils routineUtils) {
        this.dataSourceUtils = dataSourceUtils;
        this.routineUtils = routineUtils;
    }

    @PostMapping("/private/consultar_datos_trabajador")
    public ResponseEntity<?> datosTrabajador(@RequestBody String json) {
        MHService service = new MHService(dataSourceUtils, routineUtils);
        JSONObject jsonRequest = new JSONObject(json);
        jsonRequest.put("opcion", "consultar_datos");
        JSONObject jsonResponse = service.consultarTrabajador(jsonRequest);
        return ResponseEntity.ok(jsonResponse.toMap());
    }

    @PostMapping("/private/consultar_saldo_trabajador")
    public ResponseEntity<?> saldoTrabajador(@RequestBody String json) {
        MHService service = new MHService(dataSourceUtils, routineUtils);
        JSONObject jsonRequest = new JSONObject(json);
        jsonRequest.put("opcion", "consultar_saldo");
        JSONObject jsonResponse = service.consultarTrabajador(jsonRequest);
        return ResponseEntity.ok(jsonResponse.toMap());
    }

    @PostMapping("/private/consultar_cargo_trabajador")
    public ResponseEntity<?> cargoTrabajador(@RequestBody String json) {
        MHService service = new MHService(dataSourceUtils, routineUtils);
        JSONObject jsonRequest = new JSONObject(json);
        jsonRequest.put("opcion", "consultar_cargo");
        JSONObject jsonResponse = service.consultarTrabajador(jsonRequest);
        return ResponseEntity.ok(jsonResponse.toMap());
    }

    @PostMapping("/private/registrar_venta")
    public ResponseEntity<?> registrarVenta(@RequestBody String json) {
        MHService service = new MHService(dataSourceUtils, routineUtils);
        JSONObject jsonRequest = new JSONObject(json);
        jsonRequest.put("opcion", "consultar_cargo");
        JSONObject jsonResponse = service.registrarVenta(jsonRequest);
        return ResponseEntity.ok(jsonResponse.toMap());
    }
}
