package web.multitask.trismegistoservices.filter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;
import org.springframework.web.filter.OncePerRequestFilter;
import web.multitask.trismegistoservices.repository.UserRepository;
import web.multitask.trismegistoservices.utils.tokenUtils;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

@Component
@Order(1)
@NoArgsConstructor
public class JWTokenFilter extends OncePerRequestFilter {

    private final UserRepository userRepo = new UserRepository();
    private tokenUtils jwtTokenUtil = null;
    private web.multitask.trismegistoservices.singleton.tokenSingleton tokenSingleton = null;
    private web.multitask.trismegistoservices.singleton.threadLocalSingleton threadLocalSingleton = null;

    public JWTokenFilter(tokenUtils jwtTokenUtil, web.multitask.trismegistoservices.singleton.tokenSingleton tokenSingleton, web.multitask.trismegistoservices.singleton.threadLocalSingleton threadLocalSingleton) {
        this.jwtTokenUtil = jwtTokenUtil;
        this.tokenSingleton = tokenSingleton;
        this.threadLocalSingleton = threadLocalSingleton;
    }

    @Override
    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) throws ServletException, io.jsonwebtoken.io.IOException, java.io.IOException {

        response.setContentType("application/json");
        final String Authorization = request.getHeader(HttpHeaders.AUTHORIZATION);
        final String dbConnection = request.getHeader("Database");
        String type;
        String token;

        try {
            type = Authorization.split(" ")[0];
            token = Authorization.split(" ")[1];
        } catch (Exception e) {
            type = null;
            token = null;
        }

        if (dbConnection != null && !dbConnection.isEmpty()) {
            String dataBaseGotten = jwtTokenUtil.getDataToken(dbConnection);
            DataSource ds = getDataSource(new JSONObject(dataBaseGotten));
            threadLocalSingleton.setJdbcTemplate(new JdbcTemplate(ds));
        }

        if (token == null || token.isEmpty()) {
            chain.doFilter(request, response);
        } else if (Objects.equals(type, "Basic")) {
            String credentials = new String(Base64Utils.decodeFromString(token), StandardCharsets.UTF_8);
            String[] parts = credentials.split(":", 2);
            if (parts.length == 2) {
                String username = parts[0];
                String password = parts[1];
                UserDetails userDetails = userRepo.findByUsername(username);
                if (userDetails.getPassword().equals(password)) {
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userDetails, null, userDetails.getAuthorities());
                    authentication.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
                    SecurityContextHolder.getContext().setAuthentication(authentication);
                    chain.doFilter(request, response);
                }else{
                    response.sendError(401, "Invalid Token");
                }
            }else{
                response.sendError(401, "Invalid Token");
            }
        } else if (Objects.equals(type, "Bearer")) {
            if (jwtTokenUtil.validateToken(token) || tokenSingleton.consumeToken(token)) {
                JSONObject jsonToken = new JSONObject(jwtTokenUtil.getDataToken(token));
                UserDetails userDetails = userRepo.findByUsername(jsonToken.getString("username"));
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(userDetails, null, userDetails.getAuthorities());
                authentication.setDetails(new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication(authentication);
                chain.doFilter(request, response);
            } else {
                response.sendError(401, "Invalid Token");
            }
        }
    }

    private DriverManagerDataSource getDataSource(JSONObject json) {
        String driver = "";
        switch (json.getString("db")) {
            case "mysql":
                driver = "com.mysql.cj.jdbc.Driver";
                break;
            case "postgresql":
                driver = "org.postgresql.Driver";
                break;
            case "oracle":
                driver = "oracle.jdbc.driver.OracleDriver";
                break;
            case "sqlserver":
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                break;
        }
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(json.getString("url"));
        dataSource.setUsername(json.getString("user"));
        dataSource.setPassword(json.getString("password"));
        return dataSource;
    }
}