/* global bootbox, loader, elementLoader */

let isChecked = false

function segundaCarga() {
    datosUsuario.listarUsuario();
    editarUsuario();
    clickEliminarUsuario();
    reactivarUsuario();
    asignarUsuarioProyecto();
    verDetalleUsuario()
    cargarCargos()
    submitKey('txtUsuario', '#btnBuscar');
    listarProyectos('cboProyecto');
    listarTipoDeUsuario(-1, 'cboProyecto', 'cboTipoUsuario');
    asignarEventosSelect();
}

const asignarEventosSelect = () => {
    document.querySelector("#cboProyecto").addEventListener('change', (e) => {
        let proyecto = e.currentTarget.value
        document.querySelector("#cboTipoUsuario").disabled = proyecto === "";
        $.ajax({
            type: 'POST',
            url: "../servlet/MantenimientoMenuServlet?accion=listarTipoUsuario",
            dataType: 'JSON',
            data: {"codigo": proyecto},
            success: function (result) {
                if(result.length > 0){
                    document.querySelector("#cboTipoUsuario").disabled = false;
                    document.querySelector("#cboTipoUsuario").innerHTML = result.map(obj => `<option value="${obj["codigoDetalle"]}">${obj["nombreTipoUsuario"]}</option>`);
                }else{
                    document.querySelector("#cboTipoUsuario").disabled = true;
                    document.querySelector("#cboTipoUsuario").innerHTML = "<option value=''>NO EXISTE TIPO USUARIOS</option>";
                }
            }
        });
    });
}

document.querySelector('#txtEstado').innerText = 'MOSTRANDO ACTIVOS';
document.querySelector('#cbkEstado').checked = false;

let switchery = new Switchery(document.querySelector('#cbkEstado'), {color: 'red', secondaryColor: 'green'});
listarUsuariosManual = (json) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            type: 'POST',
            url: '../servlet/UsuarioServlet?accion=listarUsuarioManual',
            dataType: "json",
            data: {
                json: JSON.stringify(json)
            },
            success: function (data, textStatus, jqXHR) {
                resolve(data)
            }, error: function (jqXHR, textStatus, errorThrown) {
                reject('Error en la petición')
            }
        })
    })
}

listarCargosDeUsuario = () => {
    elementLoader.iniciarLoader('cboCargos')
    return new Promise((resolve, reject) => {
        $.ajax({
            type: 'POST',
            url: '../servlet/UsuarioServlet?accion=listarCargosDeUsuario',
            dataType: "json",
            success: function (data, textStatus, jqXHR) {
                resolve(data)
            }, error: function (jqXHR, textStatus, errorThrown) {
                reject('Error en la petición')
            }
        })
    })
}

cargarCargos = () => {
    listarCargosDeUsuario()
        .then(data => {
            let print = "<option value=''>TODOS</option>"
            print += data.map(obj => `<option value="${obj}">${obj}</option>`)
            document.getElementById('cboCargos').innerHTML = print
        })
        .then(() => {
            $('#cboCargos').select2();
            elementLoader.terminarLoader('cboCargos')
        })
}

function reactivarUsuario() {
    $('#tblUsuario tbody').on('click', '.reactivar', function () {
        var table = $("#tblUsuario").DataTable();
        var data = table.row($(this).parents('tr')).data();
        var codigo = data["codigoUsuario"];
        var json = {
            "codigo": codigo
        };
        validarUsuarioDependencia(codigo)
            .then(data => {
                if (data > 0) {
                    let param = {
                        filtro: codigo,
                        start: 0,
                        length: 10000,
                        draw: 1
                    }
                    $.ajax({
                        type: 'POST',
                        dataType: 'json',
                        "url": '../servlet/UsuarioServlet?accion=listarUsuarioDetalle',
                        data: {
                            json: JSON.stringify(param)
                        },
                        success: function (data, textStatus, jqXHR) {
                            let lista = data.data
                            lista = lista.map(obj => `<div class="checkbox">
                                                                     <label>
                                                                      <input type="checkbox" value="${obj.codigoUsuarioDetalle}" class="cbxAsignaciones" checked="checked">
                                                                      ${obj.nombreProyecto} - ${obj.nombreTipoUsuario}
                                                                     </label>
                                                                    </div>`).join('')
                            bootbox.dialog({
                                className: "dialogExtraSmall",
                                title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                headerClass: "modal-bg-success",
                                message: lista,
                                buttons: {
                                    si: {
                                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                        className: "btn bg-success border-success-600 btn-xs",
                                        callback: function () {
                                            let arregloCodigos = $("input.cbxAsignaciones:checkbox:checked").map(function () {
                                                return $(this).val()
                                            }).get()
                                            let param = {
                                                lista: JSON.stringify(arregloCodigos),
                                                array: true
                                            }
                                            $.ajax({
                                                type: 'POST',
                                                url: "../servlet/UsuarioServlet?accion=activarUsuarioDetalle",
                                                dataType: 'JSON',
                                                data: param,
                                                success: function (data) {
                                                    if (data === arregloCodigos.length) {
                                                        $.ajax({
                                                            type: 'POST',
                                                            url: "../servlet/UsuarioServlet?accion=activarUsuario",
                                                            dataType: 'JSON',
                                                            data: json,
                                                            success: (data) => {
                                                                if (data === 1) {
                                                                    msnSuccess('Usuario correctamente reactivado', () => {
                                                                        recargar()
                                                                    })
                                                                } else {
                                                                    msnError('No se pudo reactivar el usuario')
                                                                }
                                                            }
                                                        })
                                                    } else {
                                                        msnError('Ha ocurrido un error')
                                                    }
                                                }
                                            })
                                        }
                                    }
                                }
                            })
                        }
                    })

                } else {
                    $.ajax({
                        type: 'POST',
                        url: "../servlet/UsuarioServlet?accion=activarUsuario",
                        dataType: 'JSON',
                        data: json,
                        success: (data) => {
                            if (data === 1) {
                                msnSuccess('Usuario correctamente reactivado', () => {
                                    recargar()
                                })
                            } else {
                                msnError('No se pudo reactivar el usuario')
                            }
                        }
                    })
                }
            })
    })
}


$('#tblUsuario').on('draw.dt', function () {
    $('[data-toggle="tooltip"]').tooltip();
});
var datosUsuario = {
    listarUsuario: function () {
        var json = {
            "trabajador": $('#txtTrabajador').val(),
            "estadoPersonal": $('#cboEstado').val(),
            "proyecto": $('#cboProyecto').val(),
            "tipoUsuario": $('#cboTipoUsuario').val(),
            "cargo": $('#cboCargos').val(),
            "estado": isChecked
        };
        let conta = 1;
        let paramDataTable = {
            "language": {
                "lengthMenu": "Mostrar: _MENU_",
                "zeroRecords": "&nbsp;&nbsp;&nbsp; No se encontraron resultados",
                "info": "&nbsp;&nbsp;&nbsp; Mostrando del _START_ al _END_ de un total de _TOTAL_ Usuarios",
                "infoEmpty": "&nbsp;&nbsp;&nbsp; Mostrando 0 de 0 registros",
                "search": "Filtrar:",
                "loadingRecords": "Cargando...",
                "processing": '<span style="width:2rem;height: 2rem"><img src="https://upload.wikimedia.org/wikipedia/commons/7/7a/Ajax_loader_metal_512.gif?20180219130538"></span>',
                "scrollY": false,
                "paginate": {
                    "first": "First",
                    "last": "Last",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
            dom: '<"datatable-scroll"t>r<"datatable-footers"ip>',
            "ajax": {
                type: 'POST',
                "url": '../servlet/UsuarioServlet?accion=listarUsuario',
                data: {
                    json: JSON.stringify(json)
                }, beforeSend: function () {
                    load('Cargando');
                }
            },
            "bSort": false,
            "bFilter": false,
            "serverSide": true,
            "processing": false,
            "aaSorting": [],
            "ordering": false,
            "bLengthChange": false,
            "bInfo": true,
            "paging": true,
            "iDisplayLength": 15,
            "columnDefs": [
                {targets: 0, orderable: false, width: "5%", className: "text-center"},
                {targets: 1, orderable: false, width: "5%"},
                {targets: 2, orderable: false, width: "15%"},
                {targets: 3, orderable: false, width: "10%"},
                {targets: 4, orderable: false, width: "15%"},
                {targets: 5, orderable: false, width: "5%", className: "text-center"},
                {targets: 6, orderable: false, width: "10%", className: "text-center"}
            ],
            "columns": [
                {"data": "codigoUsuario"},
                {"data": "usuario"},
                {"data": "nombreUsuario"},
                {"data": "nombreArea"},
                {"data": "nombreCargo"},
                {
                    "data": "estadoUsuario",
                    render: function (data, type, row) {
                        var retorno;
                        if (data === 0) {
                            retorno = "<span class='label label-danger' style='color: white'>INACTIVO</span>";
                        } else if (data === 1) {
                            retorno = '<span class="label label-success" style="color: white">ACTIVO</span>';
                        }
                        return retorno;
                    }
                },
                {
                    "data": "estadoUsuario", "render": function (data, type, row) {
                        let retorno = ``;
                        if (data === 1) {
                            if (![null, undefined, '', 0, '0'].includes(row["tmp_id"])) {
                                retorno += `<span data-toggle="tooltip" title="Editar" style="cursor: pointer"> <i class='editar click${conta} glyphicon glyphicon-pencil text-teal-800'></i> &nbsp;&nbsp; </span>`;
                                retorno += `<span data-toggle="tooltip" title="Asignar" style="cursor: pointer"> <i data-value="${row.usuario}" class='asignar icon icon-cog2 text-slate-800'></i>&nbsp;&nbsp; </span>`;
                            }
                            retorno += `<span data-toggle="tooltip" title="Eliminar" style="cursor: pointer"> <i class='eliminar glyphicon glyphicon-trash text-danger-800'></i> </span>`;
                        } else {
                            retorno += `<span data-toggle="tooltip" title="Reactivar" style="cursor: pointer"> <i class='reactivar fa  fa-power-off text-success-800'></i>&nbsp;&nbsp; </span>`;
                            retorno += `<span data-toggle="tooltip" title="Detalle" style="cursor: pointer"> <i class='verDetalle icon icon-eye text-indigo-800'></i>&nbsp;&nbsp; </span>`;
                        }
                        conta++;
                        return retorno;
                    }
                }
            ],
            drawCallback: function (settings) {
                loader.terminarLoader()
            },
            rowCallback: function (row, data, index) {
                if([null,undefined,'',0,'0'].includes(data["tmp_id"])){
                    $(row).css('background-color', '#c9c9c9')
                }else if(Number(data["retirado"]) === 1){
                    $(row).css('background-color', '#ffd4d4')
                }
            }
        }
        $("#tblUsuario").DataTable(paramDataTable)
    }
};
var validar = false;
$('#btnBuscar').click(function () {
    // validar = $('#formUsuario').validate({
    //     rules: {
    //         txtUsuario: {required: true},
    //         cboTipoUsuario: {required: true},
    //         cboProyecto: {required: true},
    //         cboCargos: {required: true}
    //     },
    //     messages: {
    //         txtUsuario: {required: "<b>&times; Ingrese una Búsqueda</b>"},
    //         cboTipoUsuario: {required: "<b>&times; Seleccione un Tipo de Usuario</b>"},
    //         cboProyecto: {required: "<b>&times; Seleccione un Proyecto</b>"},
    //         cboCargos: {required: "<b>&times; Seleccione un Cargo</b>"}
    //     }
    // });
    // if (validar.form()) {
        recargar();
    // }
});
$('#btnLimpiar').click(function () {
    $('#txtUsuario').val("");
    $('#txtTrabajador').val("");
    $('#cboProyecto').val('0').trigger('change');
    $('#cboEstado').val('0').trigger('change');
    $('#cboCargos').val('').trigger('change');
    recargar();
});

function recargar() {
    loader.iniciarLoader()
    $("#tblUsuario").DataTable().destroy();
    datosUsuario.listarUsuario();
}

function validCaracForm() {
    new Input({el: '#editarUsuario', param: 'alphanumeric'}).validate();
    new Input({el: '#crearDocumento', param: 'numbers'}).validate();
}

function editarUsuario() {
    $('#tblUsuario tbody').on('click', '.editar', function () {
        var table = $("#tblUsuario").DataTable();
        var data = table.row($(this).parents('tr')).data();
        var numeral = data["numeral"];
        var usuario = data["usuario"];
        var nombreUsuario = data["nombreUsuario"];
        var nombreCargo = data["nombreCargo"];
        var nombreArea = data["nombreArea"];
        var codigoUsuario = data["codigoUsuario"];
        var formEditar = bootbox.dialog({
            title: "<span><i class='ace-icon fa fa-tags'></i> EDITAR USUARIO</span>",
            headerClass: "modal-bg-primary",
            size: "small",
            message: `<form id="formEditarUsuario" onsubmit="return false" autocomplete="off">
                                    <div class='col-md-12'>
                                    <div class="form-group">  
                                        <i class="fa fa-user">&nbsp; ${nombreUsuario}</i>
                                        <label>&nbsp;</label>
                                        <i class="fa fa-suitcase">&nbsp; ${nombreArea} - ${nombreCargo}</i>
                                    </div>
                                        <div class="form-group">                                            
                                            <label style="font-size: small">
                                                Usuario: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <input type="text" id="editarUsuario" name="txtUsuario" class="form-control" value="${usuario}" placeholder="INGRESE USUARIO" style="text-transform:uppercase;">
                                            <br>
                                            <label style="font-size: small">
                                                Contraseña: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <div class="input-group" id="formClave">
                                                    <input type="text" id="editarClave" name="txtClave" maxlength="15" class="form-control" value="" placeholder="INGRESE CONTRASEÑA DEL USUARIO">
                                                    <span id="btnRandom" class="input-group-addon"><i id ="icon" class="fa fa-random"></i></span>
                                            </div>                                            
                                            <br>
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>
                                        </div>
                                    </div> 
                                </form>`,
            buttons: {
                si: {
                    label: "<i class='fa fa-check bigger-110'></i>&nbsp; Editar",
                    className: "btn bg-primary border-primary-600 btn-xs buttonOk",
                    callback: function () {
                        var usuarioNuevo = $('#editarUsuario').val();
                        var claveNuevo = $('#editarClave').val();
                        var json = {
                            "codigo": codigoUsuario,
                            "clave": claveNuevo,
                            "usuario": usuarioNuevo
                        };
                        var validar = $("#formEditarUsuario").validate({
                            rules: {
                                txtUsuario: {required: true},
                                txtClave: {
                                    required: true,
                                    minlength: 6
                                }
                            },
                            messages: {
                                txtUsuario: {required: "<b>&times; Ingrese un Nombre</b>"},
                                txtClave: {
                                    required: "<b>&times; Ingrese una Clave</b>",
                                    minlength: "<b>&times; Mínimo 6 dígitos</b>"
                                }
                            },
                            errorPlacement:
                                function (error, element) {
                                    if (element.attr("id") === "editarClave") {
                                        error.insertAfter("#formClave");
                                    } else {
                                        error.insertAfter(element);
                                    }
                                }
                        });
                        if (validar.form()) {
                            if (usuarioNuevo.toUpperCase() === usuario.toUpperCase()) {
                                bootbox.dialog({
                                    className: "dialogExtraSmall",
                                    headerClass: "modal-bg-primary",
                                    title: "<i class='ace-icon fa fa-check-circle white'></i> <span class='white'>Conformidad</span>",
                                    message: "¿Está seguro de editar este Usuario?",
                                    buttons: {
                                        si: {
                                            label: "<i class='fa fa-check bigger-110'></i>&nbsp; Si",
                                            className: "btn bg-primary border-primary-600 btn-xs",
                                            callback: function () {
                                                $.ajax({
                                                    type: 'POST',
                                                    url: "../servlet/UsuarioServlet?accion=editarUsuario",
                                                    dataType: 'JSON',
                                                    data: json,
                                                    success: function (data) {
                                                        if (data === 1) {
                                                            bootbox.dialog({
                                                                className: "dialogExtraSmall",
                                                                title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                                                headerClass: "modal-bg-success",
                                                                message: "Usuario correctamente modificado",
                                                                buttons: {
                                                                    si: {
                                                                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                                        className: "btn bg-success border-success-600 btn-xs",
                                                                        callback: function () {
                                                                            refrescar()
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                        } else {
                                                            bootbox.dialog({
                                                                title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                                headerClass: "modal-bg-warning",
                                                                message: "Ha ocurrido un error",
                                                                buttons: {
                                                                    si: {
                                                                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                                        className: "btn bg-orange border-orange-600 btn-xs",
                                                                        callback: function () {
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }
                                                });
                                            }
                                        }, no: {
                                            label: "<i class='fa fa-times bigger-110'></i>&nbsp; No",
                                            className: "btn bg-danger border-danger-600 btn-xs",
                                            callback: function () {
                                            }
                                        }
                                    }
                                });
                            } else {
                                validarNombreUsuario(usuarioNuevo)
                                    .then((data) => {
                                        if (data === 0) {
                                            bootbox.dialog({
                                                className: "dialogExtraSmall",
                                                headerClass: "modal-bg-primary",
                                                title: "<i class='ace-icon fa fa-check-circle white'></i> <span class='white'>Conformidad</span>",
                                                message: "¿Está seguro de editar este Usuario?",
                                                buttons: {
                                                    si: {
                                                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Si",
                                                        className: "btn bg-primary border-primary-600 btn-xs",
                                                        callback: function () {
                                                            $.ajax({
                                                                type: 'POST',
                                                                url: "../servlet/UsuarioServlet?accion=editarUsuario",
                                                                dataType: 'JSON',
                                                                data: json,
                                                                success: function (data) {
                                                                    if (data === 1) {
                                                                        bootbox.dialog({
                                                                            className: "dialogExtraSmall",
                                                                            title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                                                            headerClass: "modal-bg-success",
                                                                            message: "Usuario correctamente modificado",
                                                                            buttons: {
                                                                                si: {
                                                                                    label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                                                    className: "btn bg-success border-success-600 btn-xs",
                                                                                    callback: function () {
                                                                                        recargar();
                                                                                    }
                                                                                }
                                                                            }
                                                                        });
                                                                    } else {
                                                                        bootbox.dialog({
                                                                            title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                                            headerClass: "modal-bg-warning",
                                                                            message: "Ha ocurrido un error",
                                                                            buttons: {
                                                                                si: {
                                                                                    label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                                                    className: "btn bg-orange border-orange-600 btn-xs",
                                                                                    callback: function () {
                                                                                    }
                                                                                }
                                                                            }
                                                                        });
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }, no: {
                                                        label: "<i class='fa fa-times bigger-110'></i>&nbsp; No",
                                                        className: "btn bg-danger border-danger-600 btn-xs",
                                                        callback: function () {
                                                        }
                                                    }
                                                }
                                            });
                                        } else {
                                            bootbox.dialog({
                                                className: "dialogExtraSmall",
                                                title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                headerClass: "modal-bg-warning",
                                                message: "El nombre ingresado esta en uso",
                                                buttons: {
                                                    si: {
                                                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                        className: "btn bg-orange border-orange-600 btn-xs",
                                                        callback: function () {
                                                            $(`#tblUsuario tbody .click${numeral}`).click();
                                                        }
                                                    }
                                                }
                                            });
                                        }
                                    });
                            }
                        } else {
                            return false;
                        }
                    }
                },
                no: {
                    label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
                    className: "btn bg-danger border-danger-600 btn-xs",
                    callback: function () {
                    }
                }
            }
        });
        formEditar.init(function () {
            validCaracForm();
            claveAleatoria('editarClave');
            submitKey('formEditarUsuario', '.buttonOk');
        });
    });
}

eliminarUsuario = (json) => {
    return new Promise((resolve, reject) => {
        $.ajax({
            type: 'POST',
            url: "../servlet/UsuarioServlet?accion=desactivarUsuario",
            dataType: 'JSON',
            data: json,
            success: function (data, textStatus, jqXHR) {
                resolve(data)
            }, error: function (jqXHR, textStatus, errorThrown) {
                reject('Error en la petición UsuarioServlet?accion=desactivarUsuarioS')
            }
        })
    })
}

function clickEliminarUsuario() {
    $('#tblUsuario tbody').on('click', '.eliminar', function () {
        var table = $("#tblUsuario").DataTable();
        var data = table.row($(this).parents('tr')).data();
        var codigo = data["codigoUsuario"];
        var json = {
            "codigo": codigo
        };
        validarUsuarioDependencia(codigo)
            .then((data) => {
                if (data === 0) {
                    msnConfirm(`¿Seguro de eliminar este usuario?`, (option) => {
                        if (option) {
                            eliminarUsuario(json)
                                .then(data => {
                                    if (data === 1) {
                                        msnSuccess('Usuario correctamente eliminado', () => {
                                            recargar()
                                        })
                                    } else {
                                        msnError('Ha ocurrido un error')
                                    }
                                })
                        }
                    })
                } else {
                    msnConfirm(`El usuario seleccionado está asignado a ${data} proyecto(s) <br> ¿Seguro de continuar?`, (option) => {
                        if (option) {
                            eliminarUsuario(json)
                                .then(data => {
                                    if (data === 1) {
                                        msnSuccess('Usuario correctamente eliminado', () => {
                                            recargar()
                                        })
                                    } else {
                                        msnError('Ha ocurrido un error')
                                    }
                                })
                        }
                    })
                }
            });
    });
}

$('#btnNuevoUsuario').click(function () {
    var formCrear = bootbox.dialog({
        className: "nuevoUsuario",
        title: "<span><i class='ace-icon fa fa-tags'></i> CREAR USUARIO</span>",
        headerClass: "modal-bg-primary",
        size: "medium",
        message: `<form id="formCrearUsuario" onsubmit="return false" autocomplete="off">
                                    <input class="hide" id="codigoTrabajador">
                                    <div class="form-group hide" id="formDatos">
                                        <div class="form-control">  
                                            <i class="fa fa-user" id="datosUsuario"></i> 
                                        </div>
                                        <br>
                                        <div class="form-control">      
                                            <i class="fa fa-suitcase" id="cargoUsuario"></i>
                                        </div>  
                                    </div>    
                                    <div class='col-md-12 form-group'>
                                        <div class="col-md-6">                                            
                                            <label style="font-size: small">
                                                Tipo de Documento: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <select id="cboTipoDocumento" name="cboTipoDocumento" class="form-control" >
                                                <option value = "">SELECCIONE TIPO DE DOCUMENTO</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6"> 
                                            <label style="font-size: small">
                                                Documento: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <input type="text" id="crearDocumento" name="txtDocumento" class="form-control" value="" placeholder="INGRESE DOCUMENTO" disabled="">                                            
                                        </div>
                                    </div>
                                    <div class='col-md-12 form-group'>
                                        <div class="col-md-6">                                            
                                            <label style="font-size: small">
                                                Usuario: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <input type="text" id="editarUsuario" name="txtUsuario" class="form-control" value="" placeholder="INGRESE USUARIO" style="text-transform:uppercase;">                                            
                                        </div>
                                        <div class="col-md-6">        
                                            <label style="font-size: small">
                                                Contraseña: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <div class="input-group" id="formClave">
                                                <input type="text" id="crearClave" name="txtClave" class="form-control" value=""maxlength="15" placeholder="INGRESE CONTRASEÑA DEL USUARIO">
                                                <span id="btnRandom" class="input-group-addon"><i id ="icon" class="fa fa-random"></i></span>                                        
                                            </div>        
                                        </div>  
                                    </div>   
                                        <div class="col-md-12 pull-right form-group">                                              
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>
                                        </div> 
                                </form>`,
        buttons: {
            si: {
                label: "<i class='fa fa-check bigger-110'></i>&nbsp; Crear",
                className: "btn bg-primary border-primary-600 btn-xs buttonOk",
                callback: function () {
                    var longitud = $("#cboTipoDocumento option:selected").data("longitud");
                    var validar = $("#formCrearUsuario").validate({
                        rules: {
                            cboTipoDocumento: {required: true},
                            txtUsuario: {required: true},
                            txtDocumento: {required: true, minlength: longitud},
                            txtClave: {required: true, minlength: 6}
                        },
                        messages: {
                            cboTipoDocumento: {required: "<b>&times; Seleccione un Tipo de Documento</b>"},
                            txtUsuario: {required: "<b>&times; Ingrese un Usuario</b>"},
                            txtDocumento: {
                                required: "<b>&times; Ingrese su Documento de Identidad</b>",
                                minlength: `<b>&times; Mínimo ${longitud} dígitos</b>`
                            },
                            txtClave: {
                                required: "<b>&times; Ingrese una Clave</b>",
                                minlength: "<b>&times; Mínimo 6 dígitos</b>"
                            }
                        },
                        errorPlacement:
                            function (error, element) {
                                if (element.attr("id") === "crearClave") {
                                    error.insertAfter("#formClave");
                                } else {
                                    error.insertAfter(element);
                                }
                            }
                    });
                    if (validar.form()) {
                        var codigoTrabajor = $("#codigoTrabajador").val();
                        var crearUsuario = $("#editarUsuario").val();
                        var crearClave = $("#crearClave").val();
                        var json = {
                            "codTrabajador": codigoTrabajor,
                            "usuario": crearUsuario,
                            "clave": crearClave
                        };
                        validarNombreUsuario(crearUsuario)
                            .then((data) => {
                                if (data === 0) {
                                    $.ajax({
                                        type: 'POST',
                                        url: "../servlet/UsuarioServlet?accion=crearUsuario",
                                        dataType: 'JSON',
                                        data: json,
                                        success: function (data) {
                                            if (data === 1) {
                                                bootbox.dialog({
                                                    className: "dialogExtraSmall",
                                                    title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                                    headerClass: "modal-bg-success",
                                                    message: "Usuario correctamente registrado",
                                                    buttons: {
                                                        si: {
                                                            label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                            className: "btn bg-success border-success-600 btn-xs",
                                                            callback: function () {
                                                                refrescar()
                                                            }
                                                        }
                                                    }
                                                });
                                            } else {
                                                bootbox.dialog({
                                                    className: "dialogExtraSmall",
                                                    title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                    headerClass: "modal-bg-warning",
                                                    message: "Ha ocurrido un error",
                                                    buttons: {
                                                        si: {
                                                            label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                            className: "btn bg-orange border-orange-600 btn-xs",
                                                            callback: function () {
                                                            }
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                    });
                                } else {
                                    bootbox.dialog({
                                        className: "dialogExtraSmall",
                                        title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                        headerClass: "modal-bg-warning",
                                        message: "El nombre ingresado esta en uso",
                                        buttons: {
                                            si: {
                                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                className: "btn bg-orange border-orange-600 btn-xs",
                                                callback: function () {
                                                    $('#btnNuevoUsuario').click();
                                                }
                                            }
                                        }
                                    });
                                }
                            });
                    } else {
                        return false;
                    }
                }
            },
            no: {
                label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
                className: "btn bg-danger border-danger-600 btn-xs",
                callback: function () {
                }
            }
        }
    });
    formCrear.init(function () {
        validCaracForm();
        listarDatos();
        listarTipoDocumento();
        claveAleatoria('crearClave');
        validarCombo();
        submitKey('formCrearUsuario', '.buttonOk');
    });
});

function listarTipoDocumento() {
    $.ajax({
        type: 'POST',
        url: "../servlet/UsuarioServlet?accion=listarTipoDocumento",
        dataType: 'JSON',
        success: function (result) {
            var print = " <option value=''>SELECCIONE TIPO DE DOCUMENTO</option> ";
            for (var i in result) {
                print += " <option value =" + result[i].codTipoDocumento + " data-longitud=" + result[i].longitud + ">" + result[i].tipoDocumento + "</option> ";
            }
            $("#cboTipoDocumento").html(print);
        }
    });
}

function generar() {
    var numeros = "012346789";
    var letras = "abcdefghijkmnpqrtuvwxyz";
    var contraseña = "";
    for (i = 0; i < 6; i++)
        if (i % 2 === 1) {
            contraseña += letras.charAt(Math.floor(Math.random() * letras.length));
        } else {
            contraseña += numeros.charAt(Math.floor(Math.random() * numeros.length));
        }
    return contraseña;
}

function claveAleatoria(input) {
    $('#btnRandom').click(function () {
        $('#' + input + '').val(generar(10));
    });
}

function listarDatos() {
    $('#crearDocumento').on('change', function () {
        var tipoDocumento = $('#cboTipoDocumento').val();
        var numeroDocumento = $('#crearDocumento').val();
        var json = {
            tipoDocumento: tipoDocumento,
            numeroDocumento: numeroDocumento
        };
        $.ajax({
            type: 'POST',
            url: "../servlet/UsuarioServlet?accion=listarDatos",
            dataType: 'JSON',
            data: json,
            success: function (result) {
                if (!result || !Object.keys(result).length) {
                    $('.nuevoUsuario').addClass('hide');
                    bootbox.dialog({
                        className: "dialogExtraSmall",
                        title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                        headerClass: "modal-bg-warning",
                        message: "El dni ingresado no corresponde a ningún personal existente",
                        buttons: {
                            si: {
                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                className: "btn bg-orange border-orange-600 btn-xs",
                                callback: function () {
                                    $('.nuevoUsuario').removeClass('hide');
                                    $('#crearDocumento').val('');
                                }
                            }
                        }
                    });
                } else {
                    var codigoTrabajador = result["cod_trabajador"];
                    var json2 = {
                        "codigo": codigoTrabajador
                    };
                    $.ajax({
                        type: 'POST',
                        url: "../servlet/UsuarioServlet?accion=validarUsuario",
                        dataType: 'JSON',
                        data: json2,
                        success: function (data) {
                            debugger
                            if (data === 0) {
                                $('#datosUsuario').text("   " + result["nom_per"] + " " + result["ape_pat_per"] + " " + result["ape_mat_per"]);
                                $('#cargoUsuario').text("   " + result["nom_are"] + " - " + result["nom_car"]);
                                $('#codigoTrabajador').val(result["cod_trabajador"]);
                                $('#formDatos').removeClass('hide');
                            } else {
                                $('.nuevoUsuario').addClass('hide');
                                bootbox.dialog({
                                    className: "dialogExtraSmall",
                                    title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                    headerClass: "modal-bg-warning",
                                    message: "El dni ingresado le corresponde a un usuario existente",
                                    buttons: {
                                        si: {
                                            label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                            className: "btn bg-orange border-orange-600 btn-xs",
                                            callback: function () {
                                                $('.nuevoUsuario').removeClass('hide');
                                                $('#crearDocumento').val('');
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    });
}

function validarCombo() {
    $("#cboTipoDocumento").on('change', function () {
        var combo = $('#cboTipoDocumento').val();
        if (combo === '') {
            $('#crearDocumento').attr('disabled', true);
            $('#crearDocumento').val("");
        } else {
            $('#crearDocumento').attr('disabled', false);
            var longitud = $("#cboTipoDocumento option:selected").data("longitud");
            $('#crearDocumento').attr('maxlength', longitud);
            soloNumeros("crearDocumento");
        }
    });
}

function soloNumeros(input) {
    $('#' + input).on('keypress keyup blur', function (e) {
        $(this).val($(this).val().replace(/[^\d].+/, ""));
        if ((e.which < 48 || e.which > 57)) {
            e.preventDefault();
        }
    });
}

function soloLetras(input) {
    $('#' + input).on('keypress keyup blur', function (e) {
        var regex = new RegExp(/^[a-zA-Z\s]*$/);
        var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
        if (regex.test(str)) {
            return true;
        }
        e.preventDefault();
        return false;
    });
}

function soloAlfanumerico(input) {
    $('#' + input).on('keypress keyup blur', function (e) {
        var regex = new RegExp("^[a-zA-Z0-9]+$");
        var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
        if (regex.test(str)) {
            return true;
        }
        e.preventDefault();
        return false;
    });
}

function asignarUsuarioProyecto() {
    $('#tblUsuario tbody').on('click', '.asignar', function (e) {
        var table = $("#tblUsuario").DataTable();
        var data = table.row($(this).parents('tr')).data();
        var codigo = data["codigoUsuario"];
        var nombre = data["nombreUsuario"];
        var listaDetalle = bootbox.dialog({
            title: "<span><i class='ace-icon fa fa-tags'></i> ASIGNAR PROYECTO - USUARIO</span>",
            headerClass: "modal-bg-primary",
            className: "mantenimientoDetalle",
            size: "large",
            message: `<div class="panel panel-primary">
                              <div class="panel-heading" style="padding: 8px 15px">
                                   <h6 class="panel-title" style="font-size: 15px; font-family: inherit"><i class="fa fa-list"></i>&nbsp; ${nombre.toUpperCase()}</h6>
                                   <div class="heading-elements">                                                                
                                       <button id="btnAsignarUsuario"  type="button"  class="btn bg-slate-600 border-slate-800  btn-xs"><i class="glyphicon glyphicon-plus"></i>&nbsp; Asignar Proyecto - Usuario</button>
                                   </div>                        
                               </div>
                            <div class="table-responsive">
                                <table class="table table-responsive table-striped table-hover table-bordered" style ="width: 100%" id="tblDetalle">                                                 
                                    <thead class="">
                                        <tr>
                                            <th class="text-center">Nº</th>
                                            <th class="text-center">PROYECTO</th>
                                            <th class="text-center">TIPO DE USUARIO</th>
                                            <th class="text-center">ESTADO</th>                                                     
                                            <th class="text-center">ACCIONES</th>                                                     
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>`,
            buttons: {
                si: {
                    label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cerrar",
                    className: "btn bg-danger border-danger-600 btn-xs",
                    callback: function () {
                    }
                }
            }
        });
        listaDetalle.init(function () {
            datosDetalle.listarDetalle(codigo);
            desactivarDetalle(codigo);
            entrarTrismegistoPlanilla(codigo, $(e.target).attr('data-value'));
            activarDetalle(codigo);
            nuevoProyectoUsuario(codigo);
            $('#tblDetalle').on('draw.dt', function () {
                $('[data-toggle="tooltip"]').tooltip();
            });
        });
    });
}

function verDetalleUsuario() {
    $('#tblUsuario tbody').on('click', '.verDetalle', function () {
        var table = $("#tblUsuario").DataTable();
        var data = table.row($(this).parents('tr')).data();
        var codigo = data["codigoUsuario"];
        var nombre = data["nombreUsuario"];
        var listaDetalle = bootbox.dialog({
            title: "<span><i class='ace-icon fa fa-tags'></i> ASIGNAR PROYECTO - USUARIO</span>",
            headerClass: "modal-bg-primary",
            className: "mantenimientoDetalle",
            message: `<div class="panel panel-primary">
                              <div class="panel-heading" style="padding: 8px 15px">
                                   <h6 class="panel-title" style="font-size: 15px; font-family: inherit"><i class="fa fa-list"></i>&nbsp; ${nombre.toUpperCase()}</h6>
                               </div>
                            <div class="table-responsive">
                                <table class="table table-responsive table-striped table-hover table-bordered" style ="width: 100%" id="tblDetalle">                                                 
                                    <thead class="">
                                        <tr>
                                            <th class="text-center">Nº</th>
                                            <th class="text-center">PROYECTO</th>
                                            <th class="text-center">TIPO DE USUARIO</th>                              
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>`,
            buttons: {
                si: {
                    label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cerrar",
                    className: "btn bg-danger border-danger-600 btn-xs",
                    callback: function () {
                        refrescar()
                    }
                }
            }
        });
        listaDetalle.init(function () {
            datosDetalle.listarDetalle(codigo, false)
        });
    });
}

   var datosDetalle = {listarDetalle: function (filtro, tipo = true) {
         var json = {
            "filtro": filtro
         };
         let conta = 1;
         let params = {
            "language": {
                "lengthMenu": "Mostrar: _MENU_",
                "zeroRecords": "&nbsp;&nbsp;&nbsp; No se encontraron resultados",
                "info": "&nbsp;&nbsp;&nbsp; Mostrando del _START_ al _END_ de un total de _TOTAL_ Asignaciones",
                "infoEmpty": "&nbsp;&nbsp;&nbsp; Mostrando 0 de 0 registros",
                "search": "Filtrar:",
                "loadingRecords": "Cargando...",
                "processing": '<span style="width:100%;"><img src="https://upload.wikimedia.org/wikipedia/commons/7/7a/Ajax_loader_metal_512.gif?20180219130538"></span>',
                "scrollY": false,
                "paginate": {
                    "first": "First",
                    "last": "Last",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
            dom: '<"datatable-scroll"t>r<"datatable-footers"ip>',
            "ajax": {
                type: 'POST',
                "url": '../servlet/UsuarioServlet?accion=listarUsuarioDetalle',
                data: {
                    json: JSON.stringify(json)
                }
            },
            "bSort": false,
            "bFilter": false,
            "serverSide": true,
            "processing": true,
            "aaSorting": [],
            "ordering": false,
            "bLengthChange": false,
            "bInfo": true,
            "paging": true,
            "iDisplayLength": 10,
            "columnDefs": [
                {targets: 0, orderable: false, width: "7%", className: "text-center"},
                {targets: 1, orderable: false, width: "20%"},
                {targets: 2, orderable: false, width: "20%", className: "text-center"},
                {targets: 3, orderable: false, width: "10%", className: "text-center"},
                {targets: 4, orderable: false, width: "7%", className: "text-center"}
            ],
            "columns": [
                {"data": "numeral"},
                {"data": "nombreProyecto"},
                {"data": "nombreTipoUsuario"},
                {
                    "data": "estadoUsuarioDetalle",
                    render: function (data, type, row) {
                        var retorno;
                        if (data === 0) {
                            retorno = "<span class='label label-danger' style='color: white'>INACTIVO</span>";
                        } else if (data === 1) {
                            retorno = '<span class="label label-success" style="color: white">ACTIVO</span>';
                        }
                        return retorno;
                    }
                },
                {
                    "data": "estadoUsuarioDetalle", "render": function (data, type, row) {
                        conta++;
                        console.log(row);
                        if (data === 1) {
                            return `${!row["nombreProyecto"].toString().includes("TRISMEGISTO ASISTENCIA") ? "" : "<span data-toggle=\"tooltip\" title=\"Entrar al Proyecto\" style=\"cursor: pointer\"> <i class='entrar glyphicon glyphicon-new-window text-blue-400'></i>&nbsp;&nbsp; </span>"}
                                    <span data-toggle="tooltip" title="Eliminar" style="cursor: pointer"> <i class='desactivar glyphicon glyphicon-trash text-danger-800'></i>&nbsp;&nbsp; </span>`;
                        } else {
                            return `<span data-toggle="tooltip" title="Reactivar" style="cursor: pointer"> <i class='reactivar fa  fa-power-off text-success-800'></i>&nbsp;&nbsp; </span>`;
                        }
                    }

                }
            ]
        }
        if (tipo === false) {
            params.columnDefs.length = 3
            params.columns.length = 3
        }
        $("#tblDetalle").DataTable(params);
    }
};

function recargarDetalle(codigo) {
    $("#tblDetalle").DataTable().destroy();
    datosDetalle.listarDetalle(codigo);
}

function activarDetalle(filtro) {
    $('#tblDetalle tbody').on('click', '.reactivar', function () {
        var table = $("#tblDetalle").DataTable();
        var data = table.row($(this).parents('tr')).data();
        var codigo = data["codigoUsuarioDetalle"];
        var codigo = data["codigoUsuarioDetalle"];
        var json = {
            "codigo": codigo,
            array: false
        }
        $.ajax({
            type: 'POST',
            url: "../servlet/UsuarioServlet?accion=activarUsuarioDetalle",
            dataType: 'JSON',
            data: json,
            success: function (data) {
                if (data === 1) {
                    $('.mantenimientoDetalle').addClass('hide');
                    msnSuccess('Asignación correctamente eliminada', () => {
                        $('.mantenimientoDetalle').removeClass('hide');
                        recargarDetalle(filtro);
                    })
                } else {
                    $('.mantenimientoDetalle').addClass('hide');
                    msnError('Ha ocurrido un error', () => {
                        $('.mantenimientoDetalle').removeClass('hide');
                        recargarDetalle(filtro);
                    })
                }
            }
        });
    });
}

function entrarTrismegistoPlanilla(codigo, usuario) {
    $('#tblDetalle tbody').on('click', '.entrar', function () {
        const json = JSON.stringify({usuario: usuario, pass: '', codigoProyecto: '37'});
        var table = $("#tblDetalle").DataTable();
        const data = table.row($(this).parents('tr')).data();
        const url = data["nombreProyecto"] === "TRISMEGISTO ASISTENCIA" ? TP : TPPrueba;
        const win = window.open(`${url}/vistas/security.jsp?body=${encodeURIComponent(json)}`, '_blank');
    });
}

function desactivarDetalle(filtro) {
    $('#tblDetalle tbody').on('click', '.desactivar', function () {
        $('.mantenimientoDetalle').addClass('hide');
        msnConfirm('¿Seguro de eliminar esta asignación?', (option) => {
            if (option) {
                var table = $("#tblDetalle").DataTable();
                var data = table.row($(this).parents('tr')).data();
                var codigo = data["codigoUsuarioDetalle"];
                var json = {
                    "codigo": codigo
                };
                $.ajax({
                    type: 'POST',
                    url: "../servlet/UsuarioServlet?accion=desactivarUsuarioDetalle",
                    dataType: 'JSON',
                    data: json,
                    success: function (data) {
                        if (data === 1) {
                            msnSuccess('Asignación correctamente eliminada', () => {
                                $('.mantenimientoDetalle').removeClass('hide');
                                recargarDetalle(filtro);
                            })
                        } else {
                            msnError('Ha ocurrido un error', () => {
                                $('.mantenimientoDetalle').removeClass('hide');
                                recargarDetalle(filtro);
                            })
                        }
                    }
                });
            }
        })
    });
}


function nuevoProyectoUsuario(codigo) {
    $('#btnAsignarUsuario').click(function () {
        $('.mantenimientoDetalle').addClass('hide');
        var nuevo = bootbox.dialog({
            title: "<span><i class='ace-icon fa fa-tags'></i> ASIGNAR</span>",
            headerClass: "modal-bg-primary",
            className: "nuevoDetalle",
            size: "small",
            message: `<form id="formAsignarTipoUsuario" onsubmit="return false" autocomplete="off">
                                    <div class="form-group">                                            
                                            <label style="font-size: small">
                                                Proyecto: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <select id="asignarProyecto" name="cboProyecto" class="form-control">
                                                <option value="0">SELECCIONE PROYECTO</option>
                                            </select>
                                            <br>
                                            <label style="font-size: small">
                                                Usuario: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <select id="asignarUsuario" name="cboUsuario" class="form-control">
                                                <option value="0">SELECCIONE UN TIPO DE USUARIO</option>
                                            </select>                                            
                                    </div>                                             
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>                                      
                                </form>`,
            buttons: {
                si: {
                    label: "<i class='fa fa-check bigger-110'></i>&nbsp; Asignar",
                    className: "btn bg-primary border-primary-600 btn-xs buttonOk",
                    callback: function () {
                        if($("#asignarProyecto").val() !== "0" && $('#asignarUsuario').val() !== "0"){
                        var validar = $("#formAsignarTipoUsuario").validate({
                            rules: {
                                cboProyecto: {required: true},
                                cboUsuario: {required: true}
                            },
                            messages: {
                                cboProyecto: {required: "<b>&times; Seleccione un Proyecto</b>"},
                                cboUsuario: {required: "<b>&times; Seleccione un Tipo de Usuario</b>"}
                            }
                        });
                        if (validar.form()) {
                            asignarProyectoUsuario(codigo);
                        } else {
                            return false;
                        }
                        }else{
                            bootbox.dialog({
                                className: "dialogExtraSmall",
                                title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                headerClass: "modal-bg-warning",
                                message: "<span class='text-black'>Debe seleccionar un proyecto y un usuario</span>",
                                buttons: {
                                    si: {
                                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                        className: "btn bg-orange border-orange-600 btn-xs",
                                        callback: function () {
                                            $('.mantenimientoDetalle').removeClass('hide');
                                        }
                                    }
                                }
                            });
                        }
                    }
                },
                no: {
                    label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
                    className: "btn bg-danger border-danger-600 btn-xs",
                    callback: function () {
                        $('.mantenimientoDetalle').removeClass('hide');
                    }
                }
            }
        });
        nuevo.init(function () {
            validarCombos();
            submitKey('formAsignarTipoUsuario', '.buttonOk');
            listarProyectos('asignarProyecto','.nuevoDetalle');
            listarTipoDeUsuario(codigo, 'asignarProyecto', 'asignarUsuario','.nuevoDetalle');
        });
    });
}

function validarCombos() {
    $('#asignarUsuario').attr('disabled', true);
    $('#asignarProyecto').on('change', function () {
        var proyecto = $('#asignarProyecto').val();
        if (proyecto === '') {
            $('#asignarUsuario').attr('disabled', true);
            $('#asignarUsuario').val("");
        } else {
            $('#asignarUsuario').attr('disabled', false);
        }
    });
}

function listarProyectos(comboBox, parent = "") {
    $.ajax({
        type: 'POST',
        url: "../servlet/UsuarioServlet?accion=listarProyectos",
        dataType: 'JSON',
        success: function (result) {
            var print = `<option value='0'>${parent !== "" ? "SELECCIONE PROYECTO" : "TODOS"}</option> `;
            for (var i in result) {
                print += " <option value =" + result[i].codigoProyecto + ">" + result[i].nombreProyecto + "</option> ";
            }
            $("#" + comboBox + "").html(print);
            if (parent !== "") {
                $("#" + comboBox + "").select2({
                    dropdownParent: $(parent)
                });
            } else {
                $("#" + comboBox + "").select2();
            }
        }
    });
}

function listarTipoDeUsuario(usuario, cboproyecto, comboBox, parent = "") {
    $("#" + cboproyecto + "").on('change', function () {
        var proyecto = $("#" + cboproyecto + "").val();
        var json = {
            "codigo": proyecto,
            "usuario": usuario
        };
        $.ajax({
            type: 'POST',
            url: "../servlet/UsuarioServlet?accion=listarTipoDeUsuario",
            dataType: 'JSON',
            data: json,
            success: function (result) {
                var print = `<option value='0'>
                ${$("#" + cboproyecto + "").children('option:selected').text() === "TODOS" || parent !== "" ? "SELECCIONE UN TIPO DE USUARIO" : "TODOS"}
                </option> `;
                for (var i in result) {
                    print += " <option value =" + result[i].codigoDetalle + ">" + result[i].nombreTipoUsuario + "</option> ";
                }
                $("#" + comboBox + "").html(print);
                if (parent !== "") {
                    $("#" + comboBox + "").select2({
                        dropdownParent: $(parent )
                    });
                }else{
                    $("#" + comboBox + "").select2();
                }
            }
        });
    });
}

function asignarProyectoUsuario(codigo) {
    var cboasignarUsuario = $('#asignarUsuario').val();
    if(cboasignarUsuario !== "0"){
    var json = {
        "usuario": codigo,
        "proyectoDetalle": cboasignarUsuario
    };
    $.ajax({
        type: 'POST',
        url: "../servlet/UsuarioServlet?accion=asignarProyectoUsuario",
        dataType: 'JSON',
        data: json,
        success: function (data) {
            if (data === 1) {
                bootbox.dialog({
                    className: "dialogExtraSmall",
                    title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                    headerClass: "modal-bg-success",
                    message: "Asignación correctamente agregada",
                    buttons: {
                        si: {
                            label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                            className: "btn bg-success border-success-600 btn-xs",
                            callback: function () {
                                $('.mantenimientoDetalle').removeClass('hide');
                                recargarDetalle(codigo);
                            }
                        }
                    }
                });
            } else {
                bootbox.dialog({
                    className: "dialogExtraSmall",
                    title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                    headerClass: "modal-bg-warning",
                    message: "Ha ocurrido un error",
                    buttons: {
                        si: {
                            label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                            className: "btn bg-orange border-orange-600 btn-xs",
                            callback: function () {
                                $('.mantenimientoDetalle').removeClass('hide');
                                recargarDetalle(codigo);
                            }
                        }
                    }
                });
            }
        }
    });}else{
        bootbox.dialog({
            className: "dialogExtraSmall",
            title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
            headerClass: "modal-bg-warning",
            message: "Seleccione un tipo de usuario",
            buttons: {
                si: {
                    label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                    className: "btn bg-orange border-orange-600 btn-xs",
                    callback: function () {
                        $('.mantenimientoDetalle').removeClass('hide');
                    }
                }
            }
        });
    }
}

function validarUsuarioDependencia(codigo) {
    let json = {
        codigo: codigo
    };
    return new Promise((resolve, reject) => {
        $.ajax({
            type: 'POST',
            url: "../servlet/UsuarioServlet?accion=validarUsuarioDependencia",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
                resolve(data);
            }, error: function (jqXHR, textStatus, errorThrown) {
                reject("Error al validar Usuario");
            }
        });
    });
}

function validarNombreUsuario(nombre) {
    let json = {
        nombre: nombre
    };
    return new Promise((resolve, reject) => {
        $.ajax({
            type: 'POST',
            url: "../servlet/UsuarioServlet?accion=validarNombreUsuario",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
                resolve(data);
            }, error: function (jqXHR, textStatus, errorThrown) {
                reject("Error al validar Nombre");
            }
        });
    });
}

function validarAsignacion(codigo) {
    let json = {
        codigo: codigo
    };
    return new Promise((resolve, reject) => {
        $.ajax({
            type: 'POST',
            url: "../servlet/UsuarioServlet?accion=validarAsignacion",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
                resolve(data);
            }, error: function (jqXHR, textStatus, errorThrown) {
                reject("Error al validar Asignacion");
            }
        });
    });
}

refrescar = () => {
    $("#tblUsuario").DataTable().ajax.reload()
}

$('[type="checkbox"]').click(function (e) {
    if (document.querySelector('#cbkEstado').checked) {
        document.querySelector('#txtEstado').innerText = 'MOSTRANDO INACTIVOS';
    } else {
        document.querySelector('#txtEstado').innerText = 'MOSTRANDO ACTIVOS';
    }
    isChecked = $(this).is(":checked");
    document.getElementById('btnLimpiar').click();
    recargar()
});