   /* global bootbox, rolesUsuario */

   let isChecked = false

   function segundaCarga() {
      datosProyecto.listarProyecto()
      editarProyecto()
      desactivarProyecto()
      activarProyecto()
      asignarDetalle()
      submitKey('formProyecto', '#btnBuscar')
   }

// PROYECTO MANTENIMIENTO

   let switchery = new Switchery(document.querySelector('#cbkEstado'), {color: 'green'})

   var datosProyecto = {listarProyecto: function () {
         var filtro = $('#txtProyecto').val()
         var json = {
            "filtro": filtro,
            "status": isChecked
         }
         $("#tblProyecto").DataTable({
            "language": {
               "lengthMenu": "Mostrar: _MENU_",
               "zeroRecords": "&nbsp;&nbsp;&nbsp; No se encontraron resultados",
               "info": "&nbsp;&nbsp;&nbsp; Mostrando del _START_ al _END_ de un total de _TOTAL_ Proyectos",
               "infoEmpty": "&nbsp;&nbsp;&nbsp; Mostrando 0 de 0 registros",
               "search": "Filtrar:",
               "loadingRecords": "Cargando...",
               "processing": '<span style="width:2rem;height: 2rem"><img src="https://upload.wikimedia.org/wikipedia/commons/7/7a/Ajax_loader_metal_512.gif?20180219130538"></span>',
               "scrollY": false,
               "paginate": {
                  "first": "First",
                  "last": "Last",
                  "next": "Siguiente",
                  "previous": "Anterior"
               }
            },
            dom: '<"datatable-scroll"t>r<"datatable-footers"ip>',
            "ajax": {
               type: 'POST',
               "url": '../servlet/ProyectoServlet?accion=listarProyecto',
               data: {
                  json: JSON.stringify(json)
               }
            },
            "bSort": false,
            "bFilter": false,
            "serverSide": true,
            "processing": true,
            "aaSorting": [],
            "ordering": false,
            "bLengthChange": false,
            "bInfo": true,
            "paging": true,
            "iDisplayLength": 15,
            "columnDefs": [
               {targets: 0, orderable: false, width: "5%", className: "text-center"},
               {targets: 1, orderable: false, width: "20%"},
               {targets: 2, orderable: false, width: "15%"},
               {targets: 3, orderable: false, width: "5%", className: "text-center", visible: isChecked},
               {targets: 4, orderable: false, width: "7%", className: "text-center"}
            ],
            "columns": [
               {"data": "codigoProyecto"},
               {"data": "nombreProyecto"},
               {"data": "urlProyecto"},
               {"data": "estadoProyecto",
                  render: function (data, type, row) {
                     var retorno;
                     if (data === 0) {
                        retorno = "<span class='label label-danger' style='color: white'>INACTIVO</span>";
                     } else if (data === 1) {
                        retorno = '<span class="label label-success" style="color: white">ACTIVO</span>';
                     }
                     return retorno;
                  }
               },
               {"data": "estadoProyecto", "render": function (data, type, row) {
                     let retorno = ``;
                     retorno = `<span data-toggle="tooltip" title="Editar" style="cursor: pointer">  <i class='editar click${row.numeral} glyphicon glyphicon-pencil text-blue-800'></i> &nbsp;&nbsp; </span>`;
                     retorno += `<span data-toggle="tooltip" title="Asignar" style="cursor: pointer">  <i class='asignar icon icon-cog2 text-slate-800'></i> &nbsp;&nbsp;  </span>`;
                     if (rolesUsuario.includes('ADMINISTRADOR')) {
                        if (data === 1) {
                           retorno += `<span data-toggle="tooltip" title="Eliminar" style="cursor: pointer">  <i class='desactivar glyphicon glyphicon-trash text-danger-800'></i>&nbsp;&nbsp; </span>`;
                        } else {
                           return `<span data-toggle="tooltip" title="Reactivar" style="cursor: pointer"> <i class='reactivar fa  fa-power-off text-success-800'></i>&nbsp;&nbsp; </span>`;
                        }
                     }
                     return retorno;
                  }

               }
            ]

         })
      }
   }

   $('#tblProyecto').on('draw.dt', function () {
      $('[data-toggle="tooltip"]').tooltip()
   })

   function recargar() {
      $("#tblProyecto").DataTable().destroy()
      datosProyecto.listarProyecto()
   }

   var validar = 0;

   $('#btnBuscar').click(function () {
      validar = $('#formProyecto').validate({
         rules: {
            txtBusqueda:
                    {required: true}
         },
         messages: {
            txtBusqueda:
                    {required: "<b>&times; Ingrese una Búsqueda</b>"}
         }
      })
      if (validar.form()) {
         recargar()
      }
   })

   $('#btnLimpiar').click(function () {
      $('#txtProyecto').val("")
      if (validar !== 0) {
         validar.resetForm()
      }
      recargar()
   })

   function validCaracForm() {
      new Input({el: '#editarNombre', param: 'alphanumeric'}).validate()
   }

   function editarProyecto() {
      $('#tblProyecto tbody').on('click', '.editar', function () {
         var table = $("#tblProyecto").DataTable()
         var data = table.row($(this).parents('tr')).data()
         var codigo = data["codigoProyecto"];
         var nombre = data["nombreProyecto"];
         var url = data["urlProyecto"];
         var numeral = data["numeral"];
         var editarProyecto = bootbox.dialog({
            title: "<span><i class='ace-icon fa fa-tags'></i> EDITAR PROYECTO</span>",
            headerClass: "modal-bg-primary",
            size: "small",
            message: `<form id="formEditarProyecto" onsubmit="return false" autocomplete="off">
                                    <div class='col-md-12'>
                                        <div class="form-group">
                                            <label style="font-size: small">
                                                Nombre: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <input type="text" id="editarNombre" name="txtNombre" class="form-control" value="${nombre}" placeholder="INGRESE NOMBRE DEL PROYECTO" style="text-transform:uppercase;">
                                            <br>
                                            <label style="font-size: small">
                                                Url: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <input type="text" id="editarUrl" name="txtUrl" class="form-control" value="${url}" placeholder="INGRESE URL DEL PROYECTO">
                                            <br>
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>
                                        </div>
                                    </div> 
                                </form>`,
            buttons: {
               si: {
                  label: "<i class='fa fa-check bigger-110'></i>&nbsp; Editar",
                  className: "btn bg-primary border-primary-600  btn-xs buttonOk",
                  callback: function () {
                     var nombreNuevo = $('#editarNombre').val().toUpperCase()
                     var urlNuevo = $('#editarUrl').val()
                     var json = {
                        "codigo": codigo,
                        "nombre": nombreNuevo,
                        "url": urlNuevo
                     }
                     var validar = $("#formEditarProyecto").validate({
                        rules: {
                           txtNombre: {required: true},
                           txtUrl: {required: true}
                        },
                        messages: {
                           txtNombre: {required: "<b>&times; Ingrese un Nombre</b>"},
                           txtUrl: {required: "<b>&times; Ingrese una Url</b>"}
                        }
                     })
                     if (validar.form()) {
                        validarNombreProyecto(nombreNuevo, nombre, 1)
                                .then((data) => {
                                   if (data === 0) {
                                      validarUrlProyecto(urlNuevo, url, 1)
                                              .then((data) => {
                                                 if (data === 0) {
                                                    bootbox.dialog({
                                                       className: "dialogExtraSmall",
                                                       headerClass: "modal-bg-primary",
                                                       title: "<i class='ace-icon fa fa-check-circle white'></i> <span class='white'>Conformidad</span>",
                                                       message: "¿Está seguro de editar este Proyecto?",
                                                       buttons: {
                                                          si: {
                                                             label: "<i class='fa fa-check bigger-110'></i>&nbsp; Si",
                                                             className: "btn bg-success border-success-600",
                                                             callback: function () {
                                                                $.ajax({
                                                                   type: 'POST',
                                                                   url: "../servlet/ProyectoServlet?accion=editarProyecto",
                                                                   dataType: 'JSON',
                                                                   data: json,
                                                                   success: function (data) {
                                                                      if (data === 1) {
                                                                         bootbox.dialog({
                                                                            className: "dialogExtraSmall",
                                                                            title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                                                            headerClass: "modal-bg-success",
                                                                            message: "Proyecto correctamente modificado",
                                                                            buttons: {
                                                                               si: {
                                                                                  label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                                                  className: "btn bg-success border-success-600",
                                                                                  callback: function () {
                                                                                     recargar()
                                                                                  }
                                                                               }
                                                                            }
                                                                         })
                                                                      } else {
                                                                         bootbox.dialog({
                                                                            title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                                            headerClass: "modal-bg-warning",
                                                                            message: "Ha ocurrido un error",
                                                                            buttons: {
                                                                               si: {
                                                                                  label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                                                  className: "btn bg-orange border-orange-600",
                                                                                  callback: function () {
                                                                                     recargar()
                                                                                  }
                                                                               }
                                                                            }
                                                                         })
                                                                      }
                                                                   }
                                                                })
                                                             }
                                                          }, no: {
                                                             label: "<i class='fa fa-times bigger-110'></i>&nbsp; No",
                                                             className: "btn bg-danger border-danger-600",
                                                             callback: function () {
                                                                $(`#tblProyecto tbody .click${numeral}`).click()
                                                             }
                                                          }
                                                       }
                                                    })
                                                 } else {
                                                    bootbox.dialog({
                                                       className: "dialogExtraSmall",
                                                       title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                       headerClass: "modal-bg-warning",
                                                       message: "La url ingresada ya está en uso",
                                                       buttons: {
                                                          si: {
                                                             label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                             className: "btn bg-orange border-orange-600",
                                                             callback: function () {
                                                                $(`#tblProyecto tbody .click${numeral}`).click()
                                                             }
                                                          }
                                                       }
                                                    })
                                                 }
                                              })

                                   } else {
                                      bootbox.dialog({
                                         className: "dialogExtraSmall",
                                         title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                         headerClass: "modal-bg-warning",
                                         message: "El nombre ingresado ya está en uso",
                                         buttons: {
                                            si: {
                                               label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                               className: "btn bg-orange border-orange-600",
                                               callback: function () {
                                                  $(`#tblProyecto tbody .click${numeral}`).click()
                                               }
                                            }
                                         }
                                      })
                                   }
                                })
                     } else {
                        return false;
                     }
                  }
               },
               no: {
                  label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
                  className: "btn bg-danger border-danger-600 btn-xs",
                  callback: function () {
                  }
               }
            }
         })
         editarProyecto.init(function () {
            validCaracForm()
            submitKey('formEditarProyecto', '.buttonOk')
         })
      })
   }

   function activarProyecto() {
      $('#tblProyecto tbody').on('click', '.reactivar', function () {
         var table = $("#tblProyecto").DataTable()
         var data = table.row($(this).parents('tr')).data()
         var codigo = data["codigoProyecto"];
         var json = {
            "codigo": codigo
         }
         validarProyecto(codigo)
                 .then((data) => {
                    if (data.length === 0) {
                       $.ajax({
                          type: 'POST',
                          url: "../servlet/ProyectoServlet?accion=activarProyecto",
                          dataType: 'JSON',
                          data: json,
                          success: function (data) {
                             if (data === 1) {
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                   headerClass: "modal-bg-success",
                                   message: "Proyecto correctamente modificado",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                         className: "btn bg-success border-success-600 btn-xs",
                                         callback: function () {
                                            recargar()
                                         }
                                      }
                                   }
                                })
                             } else {
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                   headerClass: "modal-bg-warning",
                                   message: "Ha ocurrido un error",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                         className: "btn bg-orange border-orange-600 btn-xs",
                                         callback: function () {
                                            recargar()
                                         }
                                      }
                                   }
                                })
                             }
                          }
                       })
                    } else {
                       bootbox.dialog({
                          className: "dialogExtraSmall",
                          title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                          headerClass: "modal-bg-warning",
                          message: "El proyecto seleccionado esta en uso!",
                          buttons: {
                             si: {
                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                className: "btn bg-orange border-orange-600 btn-xs",
                                callback: function () {
                                }
                             }
                          }
                       })
                    }
                 })
      })
   }

   desactivarProyectoRequest = (json) => {
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/ProyectoServlet?accion=desactivarProyecto",
            dataType: 'JSON',
            data: json,
            success: function (data, textStatus, jqXHR) {
               resolve(data)
            },
            error: function (jqXHR, textStatus, errorThrown) {
               reject('Error en la petición')
            }
         })
      })
   }

   desactivarUsuarioDetalle = (json) => {
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/ProyectoServlet?accion=desactivarUsuarioDetalle",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
               resolve(data)
            }, error: function (jqXHR, textStatus, errorThrown) {
               reject('Error en la petición')
            }
         })
      })
   }

   function desactivarProyecto() {
      $('#tblProyecto tbody').on('click', '.desactivar', function () {
         var table = $("#tblProyecto").DataTable()
         var data = table.row($(this).parents('tr')).data()
         var codigo = data["codigoProyecto"];
         var json = {
            "codigo": codigo
         }
         validarProyecto(codigo)
                 .then((data) => {
                    if (data.length === 0) {
                       msnConfirm('¿Seguro de dar de baja al proyecto seleccionado?', (option) => {
                          if (option) {
                             desactivarProyectoRequest(json)
                                     .then(data => {
                                        if (data === 1) {
                                           msnConfirm('Proyecto deshabilitado exitosamente', () => {
                                              recargar()
                                           })
                                        } else {
                                           msnError('No se pudo deshabilitar el proyecto')
                                        }
                                     })
                          }
                       })
                    } else {
                       msnConfirm(`Existen ${data.length} usuario(s) asignados a este proyecto. 
                                          Si continua estos serán deshabilitados <br>
                                          ¿Seguro de continuar?`, (option) => {
                          if (option) {
                             desactivarUsuarioDetalle(json)
                                     .then(data => {
                                        console.log(data)
                                     })
                                     .catch(err => console.log(err))
                          }
                       })
                    }
                 })

      })
   }

   $('#btnNuevoProyecto').on('click', function () {
      var crearProyecto = bootbox.dialog({
         title: "<span><i class='ace-icon fa fa-tags'></i> CREAR PROYECTO</span>",
         headerClass: "modal-bg-primary",
         size: "small",
         message: `<form id="formCrearProyecto" onsubmit="return false" autocomplete="off">
                                    <div class='col-md-12'>
                                        <div class="form-group">
                                            <label style="font-size: small">
                                                Nombre: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <input type="text" id="editarNombre" name="txtNombre" class="form-control" value="" placeholder="INGRESE NOMBRE DEL PROYECTO" style="text-transform:uppercase;">
                                            <br>
                                            <label style="font-size: small">
                                                Url: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <input type="text" id="crearUrl" name="txtUrl" class="form-control" value="" placeholder="INGRESE URL DEL PROYECTO">
                                            <br>
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>
                                        </div>
                                    </div> 
                                </form>`,
         buttons: {
            si: {
               label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
               className: "btn bg-primary border-primary-600  btn-xs buttonOk",
               callback: function () {
                  var nombre = $('#editarNombre').val().toUpperCase()
                  var url = $('#crearUrl').val()
                  var json = {
                     "nombre": nombre,
                     "url": url
                  }
                  var validar = $("#formCrearProyecto").validate({
                     rules: {
                        txtNombre: {required: true},
                        txtUrl: {required: true}
                     },
                     messages: {
                        txtNombre: {required: "<b>&times; Ingrese un Nombre</b>"},
                        txtUrl: {required: "<b>&times; Ingrese una Url</b>"}
                     }
                  })
                  if (validar.form()) {
                     validarNombreProyecto(nombre, '', 0)
                             .then((data) => {
                                if (data === 0) {
                                   validarUrlProyecto(url, '', 0)
                                           .then((data) => {
                                              if (data === 0) {
                                                 $.ajax({
                                                    type: 'POST',
                                                    url: "../servlet/ProyectoServlet?accion=crearProyecto",
                                                    dataType: 'JSON',
                                                    data: json,
                                                    success: function (data) {
                                                       if (data === 1) {
                                                          bootbox.dialog({
                                                             className: "dialogExtraSmall",
                                                             title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                                             headerClass: "modal-bg-success",
                                                             message: "Proyecto creado con exito",
                                                             buttons: {
                                                                si: {
                                                                   label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                                   className: "btn bg-success border-success-600",
                                                                   callback: function () {
                                                                      recargar()
                                                                   }
                                                                }
                                                             }
                                                          })
                                                       } else {
                                                          bootbox.dialog({
                                                             title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                             headerClass: "modal-bg-warning",
                                                             message: "Ha ocurrido un error",
                                                             buttons: {
                                                                si: {
                                                                   label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                                   className: "btn bg-orange border-orange-600 btn-xs",
                                                                   callback: function () {
                                                                   }
                                                                }
                                                             }
                                                          })
                                                       }
                                                    }
                                                 })
                                              } else {
                                                 bootbox.dialog({
                                                    className: "dialogExtraSmall",
                                                    title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                    headerClass: "modal-bg-warning",
                                                    message: "La url ingresada ya está en uso",
                                                    buttons: {
                                                       si: {
                                                          label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                          className: "btn bg-orange border-orange-600 btn-xs",
                                                          callback: function () {
                                                             $('#btnNuevoProyecto').click()
                                                          }
                                                       }
                                                    }
                                                 })
                                              }
                                           })
                                } else {
                                   bootbox.dialog({
                                      className: "dialogExtraSmall",
                                      title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                      headerClass: "modal-bg-warning",
                                      message: "El nombre ingresado ya está en uso",
                                      buttons: {
                                         si: {
                                            label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                            className: "btn bg-orange border-orange-600 btn-xs",
                                            callback: function () {
                                               $('#btnNuevoProyecto').click()
                                            }
                                         }
                                      }
                                   })
                                }
                             })
                  } else {
                     return false;
                  }
               }
            },
            no: {
               label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
               className: "btn bg-danger border-danger-600 btn-xs",
               callback: function () {
               }
            }
         }
      })
      crearProyecto.init(function () {
         validCaracForm()
         submitKey('formCrearProyecto', '.buttonOk')
      })
   })

// MANTENIMIENTO PROYECTO DETALLE

   function asignarDetalle() {
      $('#tblProyecto tbody').on('click', '.asignar', function () {
         var table = $("#tblProyecto").DataTable()
         var data = table.row($(this).parents('tr')).data()
         var codigo = data["codigoProyecto"];
         var nombre = data["nombreProyecto"];
         var listaDetalle = bootbox.dialog({
            title: "<b><i class='ace-icon fa fa-tags'></i> <span class=''>&nbsp; ASIGNAR TIPO DE USUARIO</span></b>",
            headerClass: "modal-bg-primary",
            className: "mantenimientoDetalle",
            size: "medium",
            message: `<div class="panel panel-primary">
                                    <div class="panel-heading" style="padding: 8px 15px">
                                          <h6 class="panel-title" style="font-size: 15px; font-family: inherit"><i class="fa fa-list"></i>&nbsp; ${nombre.toUpperCase()}</h6>
                                          <div class="heading-elements">                                                                
                                              <button id="btnAsignarTipoUsuario"  type="button"  class="btn bg-slate-600 border-slate btn-xs"><i class="glyphicon glyphicon-plus"></i>&nbsp; Agregar Tipo de Usuario</button>
                                          </div>                        
                                      </div>                         
                            <div class="table-responsive">
                                <table class="table table-responsive table-striped table-hover table-bordered" style ="width: 100%" id="tblDetalle">                                                 
                                    <thead class="">
                                        <tr>
                                            <th class="text-center">Nº</th>
                                            <th class="text-center">NOMBRE</th>
                                            <th class="text-center">ESTADO</th>                                                     
                                            <th class="text-center">ACCIONES</th>                                                     
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>`,
            buttons: {
               si: {
                  label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cerrar",
                  className: "btn bg-danger border-danger-600 btn-xs",
                  callback: function () {
                     recargar()
                  }
               }
            }
         })
         listaDetalle.init(function () {
            $('.close').addClass('hide')
            datosDetalle.listarDetalle(codigo)
            desactivarDetalle(codigo)
            activarDetalle(codigo)
            asignarTipoUsuario(codigo)
            eliminarDetalleValid(codigo)
            $('#tblDetalle').on('draw.dt', function () {
               $('[data-toggle="tooltip"]').tooltip()
            })
         })
      })
   }

   var datosDetalle = {listarDetalle: function (filtro) {
         var json = {
            "filtro": filtro
         }
         let conta = 1;
         $("#tblDetalle").DataTable({
            "language": {
               "lengthMenu": "Mostrar: _MENU_",
               "zeroRecords": "&nbsp;&nbsp;&nbsp; No se encontraron resultados",
               "info": "&nbsp;&nbsp;&nbsp; Mostrando del _START_ al _END_ de un total de _TOTAL_ Asignaciones",
               "infoEmpty": "&nbsp;&nbsp;&nbsp; Mostrando 0 de 0 registros",
               "search": "Filtrar:",
               "loadingRecords": "Cargando...",
               "processing": '<span style="width:2rem;height: 2rem"><img src="https://upload.wikimedia.org/wikipedia/commons/7/7a/Ajax_loader_metal_512.gif?20180219130538"></span>',
               "scrollY": false,
               "paginate": {
                  "first": "First",
                  "last": "Last",
                  "next": "Siguiente",
                  "previous": "Anterior"
               }
            },
            dom: '<"datatable-scroll"t>r<"datatable-footers"ip>',
            "ajax": {
               type: 'POST',
               "url": '../servlet/ProyectoServlet?accion=listarDetalle',
               data: json
            },
            "bSort": false,
            "bFilter": false,
            "serverSide": true,
            "processing": true,
            "aaSorting": [],
            "ordering": false,
            "bLengthChange": false,
            "bInfo": true,
            "paging": true,
            "iDisplayLength": 10,
            "columnDefs": [
               {targets: 0, orderable: false, width: "7%", className: "text-center"},
               {targets: 1, orderable: false, width: "20%"},
               {targets: 2, orderable: false, width: "7%", className: "text-center"},
               {targets: 3, orderable: false, width: "7%", className: "text-center"}
            ],
            "columns": [
               {"data": "numeral"},
               {"data": "nombreDetalle"},
               {"data": "estadoDetalle",
                  render: function (data, type, row) {
                     var retorno;
                     if (data === 0) {
                        retorno = "<span class='label label-danger' style='color: white'>INACTIVO</span>";
                     } else if (data === 1) {
                        retorno = '<span class="label label-success" style="color: white">ACTIVO</span>';
                     }
                     return retorno;
                  }
               },
               {"data": "estadoDetalle", "render": function (data, type, row) {
                     let retorno = ``;
                     if (data === 1) {
                        retorno += `<span data-toggle="tooltip" title="Desactivar" style="cursor: pointer"> <i class='desactivar glyphicon glyphicon-trash text-danger-800'></i>&nbsp;&nbsp;&nbsp; </span>`;
                     } else {
                        retorno += `<span data-toggle="tooltip" title="Activar" style="cursor: pointer"> <i class='activar fa fa-power-off text-success-800'></i>&nbsp;&nbsp;&nbsp; </span>`;
                     }
                     conta++;
                     return retorno;
                  }
               }
            ]
         })
      }
   }

   function activarDetalle(filtro) {
      $('#tblDetalle tbody').on('click', '.activar', function () {
         var table = $("#tblDetalle").DataTable()
         var data = table.row($(this).parents('tr')).data()
         var codigo = data["codigoDetalle"];
         var json = {
            "codigo": codigo
         }
         validarDetalle(codigo)
                 .then((data) => {
                    if (data === 0) {
                       $.ajax({
                          type: 'POST',
                          url: "../servlet/ProyectoServlet?accion=activarDetalle",
                          dataType: 'JSON',
                          data: json,
                          success: function (data) {
                             if (data === 1) {
                                $('.mantenimientoDetalle').addClass('hide')
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                   headerClass: "modal-bg-success",
                                   message: "Tipo de Usuario correctamente modificado",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                         className: "btn bg-success border-success-600 btn-xs",
                                         callback: function () {
                                            $('.mantenimientoDetalle').removeClass('hide')
                                            recargarDetalle(filtro)
                                         }
                                      }
                                   }
                                })
                             } else {
                                $('.mantenimientoDetalle').addClass('hide')
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                   headerClass: "modal-bg-warning",
                                   message: "Ha ocurrido un error",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                         className: "btn bg-orange border-orange-600 btn-xs",
                                         callback: function () {
                                            $('.mantenimientoDetalle').removeClass('hide')
                                            recargar()
                                         }
                                      }
                                   }
                                })
                             }
                          }
                       })
                    } else {
                       bootbox.dialog({
                          className: "dialogExtraSmall",
                          title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                          headerClass: "modal-bg-warning",
                          message: "El tipo de Usuario seleccionado esta en Uso!",
                          buttons: {
                             si: {
                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                className: "btn bg-orange border-orange-600 btn-xs",
                                callback: function () {
                                }
                             }
                          }
                       })
                    }
                 })
      })
   }

   function desactivarDetalle(filtro) {
      $('#tblDetalle tbody').on('click', '.desactivar', function () {
         var table = $("#tblDetalle").DataTable()
         var data = table.row($(this).parents('tr')).data()
         var codigo = data["codigoDetalle"];
         var json = {
            "codigo": codigo
         }
         validarDetalle(codigo)
                 .then((data) => {
                    if (data === 0) {
                       $.ajax({
                          type: 'POST',
                          url: "../servlet/ProyectoServlet?accion=desactivarDetalle",
                          dataType: 'JSON',
                          data: json,
                          success: function (data) {
                             if (data === 1) {
                                $('.mantenimientoDetalle').addClass('hide')
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                   headerClass: "modal-bg-success",
                                   message: "Tipo de Usuario correctamente modificado",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                         className: "btn bg-success border-success-600 btn-xs",
                                         callback: function () {
                                            $('.mantenimientoDetalle').removeClass('hide')
                                            recargarDetalle(filtro)
                                         }
                                      }
                                   }
                                })
                             } else {
                                $('.mantenimientoDetalle').addClass('hide')
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                   headerClass: "modal-bg-warning",
                                   message: "Ha ocurrido un error",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                         className: "btn bg-orange border-orange-600 btn-xs",
                                         callback: function () {
                                            $('.mantenimientoDetalle').removeClass('hide')
                                            recargar()
                                         }
                                      }
                                   }
                                })
                             }
                          }
                       })
                    } else {
                       $('.mantenimientoDetalle').addClass('hide')
                       bootbox.dialog({
                          className: "dialogExtraSmall",
                          title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                          headerClass: "modal-bg-warning",
                          message: "El tipo de Usuario seleccionado esta en Uso!",
                          buttons: {
                             si: {
                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                className: "btn bg-orange border-orange-600 btn-xs",
                                callback: function () {
                                   $('.mantenimientoDetalle').removeClass('hide')
                                }
                             }
                          }
                       })
                    }
                 })
      })
   }

   function recargarDetalle(codigo) {
      $("#tblDetalle").DataTable().destroy()
      datosDetalle.listarDetalle(codigo)
   }

   function asignarTipoUsuario(proyecto) {
      $('#btnAsignarTipoUsuario').click(function () {
         $('.mantenimientoDetalle').addClass('hide')
         var asignarTipo = bootbox.dialog({
            title: "<b><i class='ace-icon fa fa-tags'></i> <span class=''>ASIGNAR</span></b>",
            headerClass: "modal-bg-primary",
            size: "small",
            message: `<form id="formAsignarTipoUsuario" onsubmit="return false" autocomplete="off">
                                    <div class='col-md-12'>
                                        <div class="form-group">
                                            <label style="font-size: small">
                                                Tipo de Usuario: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <select type="text" id="cboTipoUsuario" name="cboTipoUsuario" class="form-control">
                                                <option value="">SELECCIONE TIPO DE USUARIO</option>
                                            </select>
                                            <br>
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>
                                        </div>
                                    </div> 
                                </form>`,
            buttons: {
               si: {
                  label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                  className: "btn bg-primary border-primary-600  btn-xs buttonOk",
                  callback: function () {
                     var tipoUsuario = $('#cboTipoUsuario').val()
                     var json = {
                        "proyecto": proyecto,
                        "tipoUsuario": tipoUsuario
                     }
                     var validar = $("#formAsignarTipoUsuario").validate({
                        rules: {
                           cboTipoUsuario: {required: true}
                        },
                        messages: {
                           cboTipoUsuario: {required: "<b>&times; Seleccione un tipo de Usuario</b>"}
                        }
                     })
                     if (validar.form()) {
                        $.ajax({
                           type: 'POST',
                           url: "../servlet/ProyectoServlet?accion=asignarDetalle",
                           dataType: 'JSON',
                           data: json,
                           success: function (data) {
                              if (data.status === true) {
                                 crearMenuNuevoDetalle(proyecto, data.data.codigo)
                              } else {
                                 bootbox.dialog({
                                    className: "dialogExtraSmall",
                                    title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                    headerClass: "btn bg-orange border-orange-600 btn-xs",
                                    message: "Ha ocurrido un error",
                                    buttons: {
                                       si: {
                                          label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                          className: "btn-warning",
                                          callback: function () {
                                             $('.mantenimientoDetalle').removeClass('hide')
                                          }
                                       }
                                    }
                                 })
                              }
                           }
                        })
                     } else {
                        return false;
                     }

                  }
               },
               no: {
                  label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
                  className: "btn bg-orange border-orange-600  btn-xs",
                  callback: function () {
                     $('.mantenimientoDetalle').removeClass('hide')
                  }
               }
            }
         })
         asignarTipo.init(function () {
            listarComboTipo(proyecto)
            submitKey('formAsignarTipoUsuario', '.buttonOk')
         })
      })
   }

   function listarComboTipo(proyecto) {
      var json = {
         "proyecto": proyecto
      }
      $.ajax({
         type: 'POST',
         url: "../servlet/ProyectoServlet?accion=listarTipoUsuario",
         dataType: 'JSON',
         data: json,
         success: function (result) {
            var print = " <option value=''>SELECCIONE TIPO DE USUARIO</option> ";
            for (var i in result) {
               print += " <option value =" + result[i].codigoTipoUsuario + ">" + result[i].nombreTipoUsuario + "</option> ";
            }
            $("#cboTipoUsuario").html(print)
         }
      })
   }

   function eliminarDetalleValid(filtro) {
      $('#tblDetalle tbody').on('click', '.eliminar', function () {
         var table = $("#tblDetalle").DataTable()
         var data = table.row($(this).parents('tr')).data()
         var codigo = data["codigoDetalle"];
         var json = {
            "codigo": codigo
         }
         validarDetalle(codigo)
                 .then((data) => {
                    if (data === 0) {
                       $.ajax({
                          type: 'POST',
                          url: "../servlet/ProyectoServlet?accion=validarMenuDetalle",
                          dataType: 'JSON',
                          data: json,
                          success: function (data) {
                             if (data >= 1) {
                                $('.mantenimientoDetalle').addClass('hide')
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   headerClass: "modal-bg-primary",
                                   title: "<i class='ace-icon fa fa-check-circle white'></i> <span class='white'>Conformidad</span>",
                                   message: "Este tipo de Usuario tiene Menús asignados si continúa serán eliminados ¿Desea continuar?",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; Si",
                                         className: "btn bg-primary border-primary-600 btn-xs",
                                         callback: function () {
                                            $.ajax({
                                               type: 'POST',
                                               url: "../servlet/ProyectoServlet?accion=eliminarMenuDetalle",
                                               dataType: 'JSON',
                                               data: json,
                                               success: function (data) {
                                                  if (data >= 1) {
                                                     eliminarDetalle(json, filtro)
                                                  } else {
                                                     bootbox.dialog({
                                                        className: "dialogExtraSmall",
                                                        title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                        headerClass: "modal-bg-warning",
                                                        message: "Ha ocurrido un error",
                                                        buttons: {
                                                           si: {
                                                              label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                                              className: "btn bg-orange border-orange-600 btn-xs",
                                                              callback: function () {
                                                                 $('.mantenimientoDetalle').removeClass('hide')
                                                                 recargar()
                                                              }
                                                           }
                                                        }
                                                     })
                                                  }
                                               }
                                            })
                                         }
                                      }, no: {
                                         label: "<i class='fa fa-times bigger-110'></i>&nbsp; No",
                                         className: "btn bg-danger border-danger-600 btn-xs",
                                         callback: function () {
                                            $('.mantenimientoDetalle').removeClass('hide')
                                            recargar()
                                         }
                                      }
                                   }
                                })
                             } else {
                                $('.mantenimientoDetalle').addClass('hide')
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   headerClass: "modal-bg-primary",
                                   title: "<i class='ace-icon fa fa-check-circle white'></i> <span class='white'>Conformidad</span>",
                                   message: "¿Está seguro de eliminar este tipo de usuario?",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; Si",
                                         className: "btn bg-primary border-primary-600 btn-xs",
                                         callback: function () {
                                            eliminarDetalle(json, filtro)
                                         }
                                      }, no: {
                                         label: "<i class='fa fa-times bigger-110'></i>&nbsp; No",
                                         className: "btn bg-danger border-danger-600 btn-xs",
                                         callback: function () {
                                            $('.mantenimientoDetalle').removeClass('hide')
                                            recargarDetalle(filtro)
                                         }
                                      }
                                   }
                                })

                             }
                          }
                       })
                    } else {
                       $('.mantenimientoDetalle').addClass('hide')
                       bootbox.dialog({
                          className: "dialogExtraSmall",
                          title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                          headerClass: "modal-bg-warning",
                          message: "El tipo de usuario seleccionado esta en uso",
                          buttons: {
                             si: {
                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                                className: "btn bg-orange border-orange-600 btn-xs",
                                callback: function () {
                                   $('.mantenimientoDetalle').removeClass('hide')
                                }
                             }
                          }
                       })
                    }
                 })
      })
   }

   function eliminarDetalle(json, filtro) {
      $.ajax({
         type: 'POST',
         url: "../servlet/ProyectoServlet?accion=eliminarDetalle",
         dataType: 'JSON',
         data: json,
         success: function (data) {
            if (data === 1) {
               $('.mantenimientoDetalle').addClass('hide')
               bootbox.dialog({
                  className: "dialogExtraSmall",
                  title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                  headerClass: "modal-bg-success",
                  message: "Tipo de usuario correctamente eliminado",
                  buttons: {
                     si: {
                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                        className: "btn bg-success border-success-600 btn-xs",
                        callback: function () {
                           $('.mantenimientoDetalle').removeClass('hide')
                           recargarDetalle(filtro)
                        }
                     }
                  }
               })
            } else {
               bootbox.dialog({
                  className: "dialogExtraSmall",
                  title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                  headerClass: "modal-bg-warning",
                  message: "Ha ocurrido un error",
                  buttons: {
                     si: {
                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Aceptar",
                        className: "btn bg-orange border-orange-600 btn-xs",
                        callback: function () {
                           $('.mantenimientoDetalle').removeClass('hide')
                           recargarDetalle(filtro)
                        }
                     }
                  }
               })
            }
         }
      })
   }

// PLUS

   function soloNumeros(input) {
      $('#' + input).on('keypress keyup blur', function (e) {
         $(this).val($(this).val().replace(/[^\d].+/, ""))
         if ((e.which < 48 || e.which > 57)) {
            e.preventDefault()
         }
      })
   }

   function soloLetras(input) {
      $('#' + input).on('keypress keyup blur', function (e) {
         var regex = new RegExp(/^[a-zA-Z\s]*$/)
         var str = String.fromCharCode(!e.charCode ? e.which : e.charCode)
         if (regex.test(str)) {
            return true;
         }
         e.preventDefault()
         return false;
      })
   }

   function soloAlfanumerico(input) {
      $('#' + input).on('keypress keyup blur', function (e) {
         var regex = new RegExp("^[a-zA-Z0-9]+$")
         var str = String.fromCharCode(!e.charCode ? e.which : e.charCode)
         if (regex.test(str)) {
            return true;
         }
         e.preventDefault()
         return false;
      })
   }

// VALIDACIONES PROYECTO

   function validarProyecto(codigo) {
      let json = {
         codigo: codigo
      }
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/ProyectoServlet?accion=validarProyecto",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
               resolve(data)
            }, error: function (jqXHR, textStatus, errorThrown) {
               reject("Error al validar Proyecto")
            }
         })
      })
   }

   function validarNombreProyecto(nuevo, actual, tipo) {
      let json = {
         nuevo: nuevo,
         actual: actual,
         tipo: tipo
      }
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/ProyectoServlet?accion=validarNombreProyecto",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
               resolve(data)
            }, error: function (jqXHR, textStatus, errorThrown) {
               reject("Error al validar Nombre del Proyecto")
            }
         })
      })
   }

   function validarUrlProyecto(nuevo, actual, tipo) {
      let json = {
         nuevo: nuevo,
         actual: actual,
         tipo: tipo
      }
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/ProyectoServlet?accion=validarUrlProyecto",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
               resolve(data)
            }, error: function (jqXHR, textStatus, errorThrown) {
               reject("Error al validar Url del Proyecto")
            }
         })
      })
   }

// VALIDACIONES DETALLE_PROYECTO

   function validarDetalle(codigo) {
      let json = {
         codigo: codigo
      }
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/ProyectoServlet?accion=validarDetalle",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
               resolve(data)
            }, error: function (jqXHR, textStatus, errorThrown) {
               reject("Error al validar Detalle")
            }
         })
      })
   }

   function crearMenuNuevoDetalle(proyecto, detalle) {
      var json = {
         "codigo": 0,
         "proyecto": proyecto,
         "tipo": 1
      }
      $.ajax({
         type: 'POST',
         url: "../servlet/MantenimientoMenuServlet?accion=listarMenu",
         dataType: 'JSON',
         data: json,
         success: function (data) {
            if (data.data.length >= 1) {
               bootbox.dialog({
                  className: "dialogExtraSmall",
                  headerClass: "modal-bg-primary",
                  title: "<i class='ace-icon fa fa-check-circle white'></i> <span class='white'>Conformidad</span>",
                  message: "Este proyecto tiene una vista general de menú diponible ¿Desea asignarla a este tipo de usuario?",
                  buttons: {
                     si: {
                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; Si",
                        className: "btn bg-primary border-primary-600 btn-xs",
                        callback: function () {
                           var conta;
                           for (var i = 0; i < data.data.length; i++) {
                              conta = crearMenuExistente(data.data[i].jerarquia, detalle, data.data[i].codigo)
                           }
                           if (conta === 0) {
                              bootbox.dialog({
                                 className: "dialogExtraSmall",
                                 title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                 headerClass: "modal-bg-warning",
                                 message: "Ha ocurrido un error",
                                 buttons: {
                                    si: {
                                       label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                       className: "btn bg-orange border-orange-600 btn-xs",
                                       callback: function () {
                                       }
                                    }
                                 }
                              })
                           } else {
                              bootbox.dialog({
                                 className: "dialogExtraSmall",
                                 title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                 headerClass: "modal-bg-success",
                                 message: "Tipo de Usuario correctamente agregado",
                                 buttons: {
                                    si: {
                                       label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                       className: "btn bg-success border-success-600 btn-xs",
                                       callback: function () {
                                          recargarDetalle(proyecto)
                                          $('.mantenimientoDetalle').removeClass('hide')
                                          return true;
                                       }
                                    }
                                 }
                              })
                           }
                        }
                     }, no: {
                        label: "<i class='fa fa-times bigger-110'></i>&nbsp; No",
                        className: "btn-danger",
                        callback: function () {
                           bootbox.dialog({
                              className: "dialogExtraSmall",
                              title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                              headerClass: "modal-bg-success",
                              message: "Tipo de Usuario correctamente agregado",
                              buttons: {
                                 si: {
                                    label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                    className: "btn bg-success border-success-600 btn-xs",
                                    callback: function () {
                                       recargarDetalle(proyecto)
                                       $('.mantenimientoDetalle').removeClass('hide')
                                       return true;
                                    }
                                 }
                              }
                           })
                        }
                     }
                  }
               })
            } else {
               bootbox.dialog({
                  className: "dialogExtraSmall",
                  title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                  headerClass: "modal-bg-success",
                  message: "Tipo de Usuario correctamente agregado",
                  buttons: {
                     si: {
                        label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                        className: "btn bg-success border-success-600 btn-xs",
                        callback: function () {
                           recargarDetalle(proyecto)
                           $('.mantenimientoDetalle').removeClass('hide')
                           return true;
                        }
                     }
                  }
               })
            }
         }
      })
   }

   function crearMenuExistente(jerarquia, proyecto, codigo) {
      var json = {
         codigo: codigo,
         proyecto: proyecto,
         tipo: 1,
         jerarquia: jerarquia
      }
      $.ajax({
         type: 'POST',
         url: "../servlet/MantenimientoMenuServlet?accion=nuevoMenuExistente",
         dataType: 'JSON',
         data: {
            json: JSON.stringify(json)
         },
         success: function (data, textStatus, jqXHR) {
            if (data.status === true) {
               return 1;
            } else {
               return 0;
            }
         }
      })
   }

   $('[type="checkbox"]').click(function (e) {
      isChecked = $(this).is(":checked")
      recargar()
   })