/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycompany.moduloseguridad.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceRef;
import com.mycompany.moduloseguridad.config.RequestPath;
import com.mycompany.moduloseguridad.services.UsuarioService;
import com.mycompany.moduloseguridad.utilities.HttpRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONArray;
import org.json.JSONObject;


/**
 *
 * @author Felipe Escala
 */
public class UsuarioServlet extends HttpServlet {

	/*@WebServiceRef(wsdlLocation = "WEB-INF/wsdl/app9.sacooliveros.edu.pe_8080/PlanillaWS/PersonalService.wsdl")
	private PersonalService_Service service_1;

	@WebServiceRef(wsdlLocation = "WEB-INF/wsdl/app9.sacooliveros.edu.pe_8080/PlanillaWS/TipoDocumentoService.wsdl")
	private TipoDocumentoService_Service service;*/

	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		String accion = request.getParameter("accion");
		switch (accion) {
			case "listarUsuario":
				listarUsuario(request, response);
				break;
			case "editarUsuario":
				editarUsuario(request, response);
				break;
			case "activarUsuario":
				activarUsuario(request, response);
				break;
			case "desactivarUsuario":
				desactivarUsuario(request, response);
				break;
			case "listarTipoDocumento":
				listarTipoDoc(request, response);
				break;
			case "crearUsuario":
				crearUsuario(request, response);
				break;
			case "listarDatos":
				listarDatos(request, response);
				break;
			case "validarUsuario":
				validarUsuario(request, response);
				break;
			case "eliminarUsuario":
				eliminarUsuario(request, response);
				break;
			case "listarUsuarioDetalle":
				listarUsuarioDetalle(request, response);
				break;
			case "eliminarUsuarioDetalle":
				eliminarUsuarioDetalle(request, response);
				break;
			case "activarUsuarioDetalle":
				activarUsuarioDetalle(request, response);
				break;
			case "desactivarUsuarioDetalle":
				desactivarUsuarioDetalle(request, response);
				break;
			case "listarProyectos":
				listarProyectos(request, response);
				break;
			case "listarTipoDeUsuario":
				listarTipoDeUsuario(request, response);
				break;
			case "asignarProyectoUsuario":
				asignarProyectoUsuario(request, response);
				break;
			case "validarUsuarioDependencia":
				validarUsuarioDependencia(request, response);
				break;
			case "validarNombreUsuario":
				validarNombreUsuario(request, response);
				break;
			case "validarAsignacion":
				validarAsignacion(request, response);
				break;
			case "listarUsuarioManual":
				listarUsuarioManual(request, response);
				break;
			case "listarCargosDeUsuario":
				listarCargosDeUsuario(request, response);
				break;
			default:
				break;
		}
	}

	private void listarUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		JSONArray lista = new JSONArray();
		JSONObject retorno = new JSONObject();
		String jsonString = request.getParameter("json");
		JSONObject filtro = new JSONObject(jsonString);
		String draw = request.getParameter("draw");
		int vstart = Integer.parseInt(request.getParameter("start"));
		int vlength = Integer.parseInt(request.getParameter("length"));
		JSONArray json = srv.listarUsuario(filtro, vstart, vlength, Integer.parseInt(draw));
		for (int i = 0; i < json.length(); i++) {
			JSONObject objeto = new JSONObject();
			JSONObject obj = json.getJSONObject(i);
			String codigoTrabajador = obj.getString("codigoTrabajador");
			JSONObject prs = listarPersonalPorCodigo(codigoTrabajador);
			if(!prs.isEmpty()){
			objeto.put("codigoUsuario", obj.getInt("codigoUsuario"));
			objeto.put("numeral", obj.getInt("numeral"));
			objeto.put("usuario", obj.getString("usuario"));
			objeto.put("estadoUsuario", obj.getInt("estadoUsuario"));
			objeto.put("nombreArea", prs.getString("nom_are"));
			objeto.put("nombreCargo", prs.getString("nom_car"));
			objeto.put("nombreUsuario", prs.getString("nom_per") + " " + prs.getString("ape_pat_per") + " " + prs.getString("ape_mat_per"));
			objeto.put("nombreSede", prs.getString("nom_sed"));
			objeto.put("tmp_id", obj.getInt("tmp_id"));
			objeto.put("retirado", obj.getInt("retirado"));
			lista.put(objeto);
			}else{
				objeto.put("codigoUsuario", obj.getInt("codigoUsuario"));
				objeto.put("numeral", obj.getInt("numeral"));
				objeto.put("usuario", obj.getString("usuario"));
				objeto.put("estadoUsuario", obj.getInt("estadoUsuario"));
				objeto.put("nombreArea", "");
				objeto.put("nombreCargo", "");
				objeto.put("nombreUsuario", "");
				objeto.put("nombreSede", "");
				objeto.put("tmp_id", obj.getInt("tmp_id"));
				objeto.put("retirado", obj.getInt("retirado"));
				lista.put(objeto);
			}
		}
		int cantidad = srv.cantidadRegistros(filtro);
		retorno.put("data", lista);
		retorno.put("draw", draw);
		retorno.put("recordsFiltered", cantidad);
		retorno.put("recordsTotal", cantidad);
		out.print(retorno);
	}

	private void editarUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		String usuario = request.getParameter("usuario");
		String clave = request.getParameter("clave");
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		String passwordEncriptado = DigestUtils.md5Hex(clave);
		int rs = srv.editarUsuario(codigo, usuario, passwordEncriptado);
		out.println(rs);
	}

	private void activarUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = srv.activarUsuario(codigo);
		out.println(rs);
	}

	private void desactivarUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = srv.desactivarUsuario(codigo);
		out.println(rs);
	}

	private void crearUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		String codigoTrabajador = request.getParameter("codTrabajador");
		String usuario = request.getParameter("usuario");
		String clave = request.getParameter("clave");
		String passwordEncriptado = DigestUtils.md5Hex(clave);
		int rs = srv.crearUsuario(codigoTrabajador, usuario, passwordEncriptado);
		out.println(rs);
	}

	private void listarTipoDoc(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		JSONArray array = new JSONArray();
                JSONObject respuesta = null;
                JSONObject obj = new JSONObject();
                HttpRequest httpRequest = new HttpRequest();
                String r = httpRequest.getRespuesta(RequestPath.listarTipoDocumento, HttpRequest.POST, obj, "");//Respuesta del server
		respuesta = new JSONObject(r);
                JSONArray data = respuesta.getJSONArray("data");
                for (int i = 0; i < data.length(); i++) {
			JSONObject rs = new JSONObject();
			rs.put("codTipoDocumento", data.getJSONObject(i).getString("cod_tipo_documento"));
			rs.put("tipoDocumento", data.getJSONObject(i).getString("nom_cor"));
			rs.put("longitud", data.getJSONObject(i).getString("lon"));
			array.put(rs);
		}
                
		out.println(array);
	}

	private void listarDatos(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		String tipoDocumento = request.getParameter("tipoDocumento");
		String numeroDocumento = request.getParameter("numeroDocumento");
		JSONObject rs = listarPersonalPorTipoDocNumDoc(tipoDocumento, numeroDocumento);
		out.println(rs);
	}

	private void validarUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		String codigo = request.getParameter("codigo");
		int rs = srv.validarUsuario(codigo);
		out.println(rs);
	}

	private void eliminarUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = srv.eliminarUsuario(codigo);
		out.println(rs);
	}

	private void listarUsuarioDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		String json = request.getParameter("json");
		JSONObject obj = new JSONObject(json);
		String draw = request.getParameter("draw");
		int vstart = Integer.parseInt(request.getParameter("start"));
		int vlength = Integer.parseInt(request.getParameter("length"));
		JSONObject resp = srv.listarUsuarioDetalle(obj, vstart, vlength, draw);
		out.println(resp);
	}

	private void eliminarUsuarioDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = srv.eliminarUsuarioDetalle(codigo);
		out.println(rs);
	}

	private void activarUsuarioDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int rs = 0;
		boolean array = Boolean.parseBoolean(request.getParameter("array"));
		if (array) {
			JSONArray lista = new JSONArray(request.getParameter("lista"));
			for (int i = 0; i < lista.length(); i++) {
				int codigo = lista.getInt(i);
				rs += srv.activarUsuarioDetalle(codigo);
			}
		} else {
			int codigo = Integer.parseInt(request.getParameter("codigo"));
			rs = srv.activarUsuarioDetalle(codigo);
		}
		out.println(rs);
	}

	private void desactivarUsuarioDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = srv.desactivarUsuarioDetalle(codigo);
		out.println(rs);
	}

	private void listarProyectos(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		JSONArray rs = srv.listarProyecto();
		out.println(rs);
	}

	private void listarTipoDeUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int usuario = Integer.parseInt(request.getParameter("usuario"));
		JSONArray rs = srv.listarTipoDeUsuario(codigo, usuario);
		out.println(rs);
	}

	private void asignarProyectoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int usuario = Integer.parseInt(request.getParameter("usuario"));
		int proyectoDetalle = Integer.parseInt(request.getParameter("proyectoDetalle"));
		int rs = srv.asignarProyectoUsuario(usuario, proyectoDetalle);
		out.println(rs);
	}

	private void validarUsuarioDependencia(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = srv.validarUsuarioDependencia(codigo);
		out.println(rs);
	}

	private void validarNombreUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		String nombre = request.getParameter("nombre");
		int rs = srv.validarNombreUsuario(nombre);
		out.println(rs);
	}

	private void validarAsignacion(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = srv.validarAsignacion(codigo);
		out.println(rs);
	}

	private JSONObject listarPersonalPorTipoDocNumDoc(String tipoDocumento, String numeroDocumento) throws IOException {
                JSONObject respuesta = null;
                JSONObject obj = new JSONObject()
                        .put("tipoDocumento", tipoDocumento)
                        .put("numeroDocumento", numeroDocumento)
                        .put("estado", "1");
                HttpRequest httpRequest = new HttpRequest();
                String r = httpRequest.getRespuesta(RequestPath.listarPersonalPorTipoDocNumDoc, HttpRequest.POST, obj, "");//Respuesta del server
		respuesta = new JSONObject(r);
                return respuesta;
	}

	private JSONObject listarPersonalPorCodigo(java.lang.String tipoDocumento) throws IOException {
                JSONObject respuesta = null;
                JSONObject obj = new JSONObject()
                        .put("tipoDocumento", tipoDocumento);
                HttpRequest httpRequest = new HttpRequest();
                String r = httpRequest.getRespuesta(RequestPath.listarPersonalPorCodigo, HttpRequest.POST, obj, "");//Respuesta del server
		respuesta = new JSONObject(r);
                return respuesta;
	}

	private void listarUsuarioManual(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		String jsonString = request.getParameter("json");
		JSONObject jsonObject = new JSONObject(jsonString);
		String busqueda = jsonObject.getString("busqueda");
		int tipo = jsonObject.getInt("tipo");
		UsuarioService srv = new UsuarioService();
		JSONObject json = srv.listarUsuarioManual(jsonObject);
		JSONArray listaFinal = new JSONArray();
		JSONArray lista = json.getJSONArray("results");
		for (int i = 0; i < lista.length(); i++) {
			JSONObject _final = new JSONObject();
			JSONObject obj = lista.getJSONObject(i);
			String codigoTrabajador = obj.getString("codigoTrabajador");
			JSONObject prs = listarPersonalPorCodigo(codigoTrabajador);
			if (!prs.isEmpty()) {
				String nombreCompleto = prs.getString("nom_per") + " " + prs.getString("ape_pat_per") + " " + prs.getString("ape_mat_per");
				String cargo = prs.getString("nom_car");
				if (tipo == 4 && (nombreCompleto.toUpperCase()).contains(busqueda.toUpperCase())) {
					_final.put("codigoUsuario", obj.getInt("codigoUsuario"));
					_final.put("numeral", obj.getInt("numeral"));
					_final.put("usuario", obj.getString("usuario"));
					_final.put("estadoUsuario", obj.getInt("estadoUsuario"));
					_final.put("nombreArea", prs.getString("nom_are"));
					_final.put("nombreCargo", prs.getString("nom_car"));
					_final.put("nombreUsuario", prs.getString("nom_per") + " " + prs.getString("ape_pat_per") + " " + prs.getString("ape_mat_per"));
					_final.put("nombreSede", prs.getString("nom_sed"));
					listaFinal.put(_final);
				} else if (tipo == 5 && (cargo).equalsIgnoreCase(busqueda)) {
					_final.put("codigoUsuario", obj.getInt("codigoUsuario"));
					_final.put("numeral", obj.getInt("numeral"));
					_final.put("usuario", obj.getString("usuario"));
					_final.put("estadoUsuario", obj.getInt("estadoUsuario"));
					_final.put("nombreArea", prs.getString("nom_are"));
					_final.put("nombreCargo", prs.getString("nom_car"));
					_final.put("nombreUsuario", prs.getString("nom_per") + " " + prs.getString("ape_pat_per") + " " + prs.getString("ape_mat_per"));
					_final.put("nombreSede", prs.getString("nom_sed"));
					listaFinal.put(_final);
				}
			}
		}
		out.println(listaFinal);
	}

	private void listarCargosDeUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		UsuarioService srv = new UsuarioService();
		JSONObject json = srv.listarUsuarioManual(new JSONObject());
		ArrayList<String> cargos = new ArrayList<>();
		JSONArray lista = json.getJSONArray("results");
		for (int i = 0; i < lista.length(); i++) {
			JSONObject obj = lista.getJSONObject(i);
			JSONObject prs = listarPersonalPorCodigo(obj.getString("codigoTrabajador"));
			if(!prs.isNull("nom_car")){
			if (!cargos.contains(prs.getString("nom_car"))) {
				cargos.add(prs.getString("nom_car"));
			}
			}
		}
		out.print(new JSONArray(cargos));
	}
}