/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycompany.moduloseguridad.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.mycompany.moduloseguridad.services.MenuService;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author Felipe Escala
 */
public class MantenimientoMenuServlet extends HttpServlet {

	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		String accion = request.getParameter("accion");
		switch (accion) {
			case "listarProyecto":
				listarProyecto(request, response);
				break;
			case "listarTipoUsuario":
				listarTipoUsuario(request, response);
				break;
			case "listarMenu":
				listarMenu(request, response);
				break;
			case "editarMenu":
				editarMenu(request, response);
				break;
			case "nuevoMenu":
				nuevoTituloGeneral(request, response);
				break;
			case "eliminarDetalleMenu":
				eliminarDetalleMenu(request, response);
				break;
			case "cambiarOrden":
				cambiarOrden(request, response);
				break;
			case "reconocerNombreSimilar":
				reconocerNombreSimilar(request, response);
				break;
			case "nuevoMenuExistente":
				nuevoMenuExistente(request, response);
				break;
			case "validarEdicionMenu":
				validarEdicionMenu(request, response);
				break;
			case "listarMenuDetalle":
				listarMenuDetalle(request, response);
				break;
			case "validarEliminarDetalle":
				validarEliminarDetalle(request, response);
				break;
			case "eliminarMenusAninado":
				eliminarMenusAninado(request, response);
				break;
			case "listarPermisosPorVista":
				listarPermisosPorVista(request, response);
				break;
			case "asignarAccionesPorVista":
				asignarAccionesPorVista(request, response);
				break;
			default:
				break;

		}
	}

	private void listarProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		int estado = Integer.parseInt(request.getParameter("estado"));
		JSONArray rs = srv.listarProyecto(estado);
		out.println(rs);
	}

	private void listarTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		int codigo = Integer.parseInt(Objects.equals(request.getParameter("codigo"), "") ? "0" : request.getParameter("codigo"));
		JSONArray rs = srv.listarTipoDeUsuario(codigo);
		out.println(rs);
	}

	private void listarMenu(HttpServletRequest request, HttpServletResponse response) throws IOException {
			response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		int proyecto_detalle = Integer.parseInt(request.getParameter("codigo"));
		int tipo = Integer.parseInt(request.getParameter("tipo"));
		int proyecto = Integer.parseInt(request.getParameter("proyecto"));
		String draw = request.getParameter("draw");
		System.out.println(request.getParameter("listarPermisos"));
		int listarPermisos = 0;
		if(request.getParameter("listarPermisos") != null){
		listarPermisos = Integer.parseInt(request.getParameter("listarPermisos"));
		}
		JSONObject rs = new JSONObject();
		JSONArray lista = new JSONArray();
		JSONArray listaTitulo = srv.listarTituloCompleto(proyecto_detalle, proyecto, tipo);
		int cantidad;
		int iTitulo = 0;
		for (int i = 0; i < listaTitulo.length(); i++) {
			int iModulo = 0;
			JSONObject obj1 = new JSONObject();
			JSONObject objTitulo = (JSONObject) listaTitulo.get(i);
			String nombreTitulo = objTitulo.getString("nombreTitulo");
			int codigoTitulo = objTitulo.getInt("codigoTitulo");
			int configuracionTitulo = objTitulo.getInt("configuracionTitulo");
			String iconoTitulo = objTitulo.getString("iconoTitulo");
			int ordenTitulo = objTitulo.getInt("ordenTitulo");
			iTitulo++;
			obj1.put("conta", iTitulo);
			obj1.put("jerarquia", 1);
			obj1.put("nombre", nombreTitulo);
			obj1.put("codigo", codigoTitulo);
			obj1.put("icono", iconoTitulo);
			obj1.put("url", "");
			obj1.put("tipo", "");
			obj1.put("configuracion", configuracionTitulo);
			obj1.put("padre", 0);
			obj1.put("orden", ordenTitulo);
			lista.put(obj1);
			JSONArray listaModulo = srv.listarModuloCompleto(codigoTitulo, proyecto_detalle, proyecto, tipo);
			for (int j = 0; j < listaModulo.length(); j++) {
				int iCategoria = 0;
				JSONObject obj2 = new JSONObject();
				JSONObject objModulo = (JSONObject) listaModulo.get(j);
                 boolean esVisible1 = objModulo.getBoolean("esVisible");
				String nombreModulo = objModulo.getString("nombreModulo");
				int codigoModulo = objModulo.getInt("codigoModulo");
				int configuracionModulo = objModulo.getInt("configuracionModulo");
				String iconoModulo = objModulo.getString("iconoModulo");
				String urlModulo = objModulo.getString("urlModulo");
				int tipoModulo = objModulo.getInt("tipoModulo");
				int padreModulo = objModulo.getInt("codigoTitulo");
				int ordenModulo = objModulo.getInt("ordenModulo");
				iModulo++;
				obj2.put("conta", iModulo);
				obj2.put("jerarquia", 2);
				obj2.put("nombre", nombreModulo);
				obj2.put("codigo", codigoModulo);
				obj2.put("icono", iconoModulo);
				obj2.put("url", urlModulo);
				obj2.put("tipo", tipoModulo);
				obj2.put("configuracion", configuracionModulo);
				obj2.put("padre", padreModulo);
				obj2.put("orden", ordenModulo);
				obj2.put("esVisible", esVisible1);
				lista.put(obj2);
				if (listarPermisos != 0) {
					JSONArray listarModuloAcc = srv.obtenerAcciones(codigoModulo, 2, proyecto_detalle);
					for (int modacc = 0; modacc < listarModuloAcc.length(); modacc++) {
						JSONObject objModuloAcc = (JSONObject) listarModuloAcc.get(modacc);
						JSONObject objModuloAcc2 = new JSONObject();
						objModuloAcc2.put("conta", modacc + 1);
						objModuloAcc2.put("jerarquia", 5);
						objModuloAcc2.put("nombre", objModuloAcc.isNull("nom_accion") ? "" : objModuloAcc.getString("nom_accion"));
						objModuloAcc2.put("codigo", objModuloAcc.isNull("cod_accion") ? "" : objModuloAcc.getInt("cod_accion"));
						objModuloAcc2.put("icono", "");
						objModuloAcc2.put("url", "");
						objModuloAcc2.put("tipo", 3);
						objModuloAcc2.put("configuracion", 0);
						objModuloAcc2.put("padre", codigoModulo);
						objModuloAcc2.put("orden", 0);
						//					objModuloAcc2.put("esVisible", true);
						lista.put(objModuloAcc2);
					}
				}
				JSONArray listaCategoria = srv.listarCategoriaCompleto(codigoModulo, proyecto_detalle, proyecto, tipo);
				for (int k = 0; k < listaCategoria.length(); k++) {
					int iSubCategoria = 0;
					JSONObject obj3 = new JSONObject();
					JSONObject objCategoria = (JSONObject) listaCategoria.get(k);
					String nombreCategoria = objCategoria.getString("nombreCategoria");
					boolean esVisible2 = objModulo.getBoolean("esVisible");
					int codigoCategoria = objCategoria.getInt("codigoCategoria");
					int configuracionCategoria = objCategoria.getInt("configuracionCategoria");
					String urlCategoria = objCategoria.getString("urlCategoria");
					int tipoCategoria = objCategoria.getInt("tipoCategoria");
					int padreCategoria = objCategoria.getInt("codigoModulo");
					int ordenCategoria = objCategoria.getInt("ordenCategoria");
					iCategoria++;
					obj3.put("conta", iCategoria);
					obj3.put("jerarquia", 3);
					obj3.put("nombre", nombreCategoria);
					obj3.put("codigo", codigoCategoria);
					obj3.put("url", urlCategoria);
					obj3.put("icono", "");
					obj3.put("tipo", tipoCategoria);
					obj3.put("configuracion", configuracionCategoria);
					obj3.put("padre", padreCategoria);
					obj3.put("orden", ordenCategoria);
					obj3.put("esVisible", esVisible2);
					lista.put(obj3);
					if(listarPermisos != 0) {
						JSONArray listarCategoriaAcc = srv.obtenerAcciones(codigoCategoria, 3, proyecto_detalle);
						for (int catacc = 0; catacc < listarCategoriaAcc.length(); catacc++) {
							JSONObject objCategoriaAcc = (JSONObject) listarCategoriaAcc.get(catacc);
							JSONObject objCategoriaAcc2 = new JSONObject();
							objCategoriaAcc2.put("conta", catacc + 1);
							objCategoriaAcc2.put("jerarquia", 6);
							objCategoriaAcc2.put("nombre", objCategoriaAcc.isNull("nom_accion") ? "" : objCategoriaAcc.getString("nom_accion"));
							objCategoriaAcc2.put("codigo", objCategoriaAcc.isNull("cod_accion") ? "" : objCategoriaAcc.getInt("cod_accion"));
							objCategoriaAcc2.put("icono", "");
							objCategoriaAcc2.put("url", "");
							objCategoriaAcc2.put("tipo", 3);
							objCategoriaAcc2.put("configuracion", 0);
							objCategoriaAcc2.put("padre", codigoCategoria);
							objCategoriaAcc2.put("orden", 0);
							lista.put(objCategoriaAcc2);
						}
					}
					JSONArray listaSubCategoria = srv.listarSubCategoriaCompleto(codigoCategoria, proyecto_detalle, proyecto, tipo);
					for (int l = 0; l < listaSubCategoria.length(); l++) {
						JSONObject obj4 = new JSONObject();
						JSONObject objSubCategoria = (JSONObject) listaSubCategoria.get(l);
						String nombreSubCategoria = objSubCategoria.getString("nombreSubCategoria");
						boolean esVisible3 = objSubCategoria.getBoolean("esVisible");
						int codigoSubCategoria = objSubCategoria.getInt("codigoSubCategoria");
						int configuracionSubCategoria = objSubCategoria.getInt("configuracionSubCategoria");
						String urlSubCategoria = objSubCategoria.getString("urlSubCategoria");
						int padreSubCategoria = objSubCategoria.getInt("codigoCategoria");
						int ordenSubCategoria = objSubCategoria.getInt("ordenSubCategoria");
						iSubCategoria++;
						obj4.put("conta", iSubCategoria);
						obj4.put("jerarquia", 4);
						obj4.put("nombre", nombreSubCategoria);
						obj4.put("codigo", codigoSubCategoria);
						obj4.put("url", urlSubCategoria);
						obj4.put("icono", "");
						obj4.put("tipo", "");
						obj4.put("configuracion", configuracionSubCategoria);
						obj4.put("padre", padreSubCategoria);
						obj4.put("orden", ordenSubCategoria);
						obj4.put("esVisible", esVisible3);
						lista.put(obj4);
						if(listarPermisos != 0) {
							JSONArray listarSubAcc = srv.obtenerAcciones(codigoSubCategoria, 4, proyecto_detalle);
							for (int subacc = 0; subacc < listarSubAcc.length(); subacc++) {
								JSONObject objSubAcc = (JSONObject) listarSubAcc.get(subacc);
								JSONObject objSubAcc2 = new JSONObject();
								objSubAcc2.put("conta", subacc + 1);
								objSubAcc2.put("jerarquia", 7);
								objSubAcc2.put("nombre", objSubAcc.isNull("nom_accion") ? "" : objSubAcc.getString("nom_accion"));
								objSubAcc2.put("codigo",objSubAcc.isNull("cod_accion") ? "" :  objSubAcc.getInt("cod_accion"));
								objSubAcc2.put("icono", "");
								objSubAcc2.put("url", "");
								objSubAcc2.put("tipo", 3);
								objSubAcc2.put("configuracion", 0);
								objSubAcc2.put("padre", codigoSubCategoria);
								objSubAcc2.put("orden", 0);
								lista.put(objSubAcc2);
							}
						}
					}
				}
			}
		}
		cantidad = lista.length();
		rs.put("data", lista);
		rs.put("draw", draw);
		rs.put("recordsFiltered", cantidad);
		rs.put("recordsTotal", cantidad);
		out.print(rs);
	}

	private void editarMenu(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.editarTitulo(json);
				break;
			case 2:
				rs = srv.editarModulo(json);
				break;
			case 3:
				rs = srv.editarCategoria(json);
				break;
			case 4:
				rs = srv.editarSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void nuevoTituloGeneral(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.nuevoTitulo(json);
				break;
			case 2:
				rs = srv.nuevoModulo(json);
				break;
			case 3:
				rs = srv.nuevoCategoria(json);
				break;
			case 4:
				rs = srv.nuevoSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void eliminarDetalleMenu(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.eliminarDetalleTitulo(json);
				break;
			case 2:
				rs = srv.eliminarDetalleModulo(json);
				break;
			case 3:
				rs = srv.eliminarDetalleCategoria(json);
				break;
			case 4:
				rs = srv.eliminarDetalleSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void cambiarOrden(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.cambiarOrdenTitulo(json);
				break;
			case 2:
				rs = srv.cambiarOrdenModulo(json);
				break;
			case 3:
				rs = srv.cambiarOrdenCategoria(json);
				break;
			case 4:

				rs = srv.cambiarOrdenSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void reconocerNombreSimilar(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		rs = srv.reconocerNombreSimilar(json);
		out.println(rs);
	}

	private void nuevoMenuExistente(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.nuevoTituloExistente(json);
				break;
			case 2:
				rs = srv.nuevoModuloExistente(json);
				break;
			case 3:
				rs = srv.nuevoCategoriaExistente(json);
				break;
			case 4:
				rs = srv.nuevoSubCategoriaExistente(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void validarEdicionMenu(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.validarEdicionTitulo(json);
				break;
			case 2:
				rs = srv.validarEdicionModulo(json);
				break;
			case 3:
				rs = srv.validarEdicionCategoria(json);
				break;
			case 4:
				rs = srv.validarEdicionSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void listarMenuDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		String draw = request.getParameter("draw");
		String start = request.getParameter("start");
		String length = request.getParameter("length");
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.listarTitulo(json, draw, start, length);
				break;
			case 2:
				rs = srv.listarModulo(json, draw, start, length);
				break;
			case 3:
				rs = srv.listarCategoria(json, draw, start, length);
				break;
			case 4:
				rs = srv.listarSubCategoria(json, draw, start, length);
				break;
			default:
		}
		out.print(rs);
	}

	private void validarEliminarDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.validarElminarTitulo(json);
				break;
			case 2:
				rs = srv.validarElminarModulo(json);
				break;
			case 3:
				rs = srv.validarElminarCategoria(json);
				break;
			case 4:
				rs = srv.validarElminarSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void eliminarMenusAninado(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int configuracion = json.getInt("vista");
		if (configuracion != 0) {
			rs = srv.eliminarMenusAninado(json);
		} else {
			rs = srv.eliminarMenusAninadoGeneral(json);
		}
		out.print(rs);
	}

	private void listarPermisosPorVista(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs;
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int jerarquia = Integer.parseInt(request.getParameter("jerarquia"));
		JSONObject json = new JSONObject().put("codigo", codigo).put("jerarquia", jerarquia);
		rs = srv.listarPermisosPorVista(json);
		out.print(rs);
	}

	public void asignarAccionesPorVista(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs;
		int tipo_accion = Integer.parseInt( request.getParameter("tipo_accion"));
		int v_cod_accion = Integer.parseInt( request.getParameter("v_cod_accion"));
		String v_nom_accion = request.getParameter("v_nom_accion");
		int v_jerarquia = Integer.parseInt( request.getParameter("v_jerarquia"));
		int v_cod_proyecto = Integer.parseInt( request.getParameter("v_cod_proyecto"));
		int v_cod_vista = Integer.parseInt( request.getParameter("v_cod_vista"));
		int v_cod_vista_acc = Integer.parseInt( request.getParameter("v_cod_vista_acc"));
		int v_tipo_usuario = Integer.parseInt(request.getParameter("v_tipo_usuario"));
		JSONObject json = new JSONObject()
				.put("tipo_accion", tipo_accion)
				.put("v_cod_accion", v_cod_accion)
				.put("v_nom_accion", v_nom_accion)
				.put("v_jerarquia", v_jerarquia)
				.put("v_cod_proyecto", v_cod_proyecto)
				.put("v_cod_vista", v_cod_vista)
				.put("v_cod_vista_acc", v_cod_vista_acc)
				.put("v_tipo_usuario", v_tipo_usuario);
		rs = srv.asignarAccionesPorVista(json);
		out.print(rs);
	}

}