/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycompany.moduloseguridad.services;

import com.mycompany.moduloseguridad.dao.DAOFactory;
import com.mycompany.moduloseguridad.dao.TipoUsuarioDAO;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class TipoUsuarioService {

	DAOFactory fabrica = DAOFactory.getDAOFactory(DAOFactory.MYSQL);
	TipoUsuarioDAO dao = fabrica.getTipoUsuario();
        
        public JSONObject listarProyectos() {
		JSONObject obj = null;
		try {
			obj = dao.listarProyectos();
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return obj;
	}
        
        public JSONObject listarTiposUsuarios(int codigoProyecto) {
		JSONObject obj = null;
		try {
			obj = dao.listarTiposUsuarios(codigoProyecto);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return obj;
	}
        
        public JSONObject asignarAcciones(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.asignarAcciones(datos);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return obj;
	}
        
        public JSONObject listarAcciones(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.listarAcciones(datos);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return obj;
	}
        
        public JSONObject listarCboAcciones() {
		JSONObject obj = null;
		try {
			obj = dao.listarCboAcciones();
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return obj;
	}
        
        public JSONObject activarDesactivarAccion(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.activarDesactivarAccion(datos);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return obj;
	}
        
        public JSONObject activarDesactivarTipoUsuario(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.activarDesactivarTipoUsuario(datos);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return obj;
	}

	public JSONObject listadoPrincipal(String filtro,int filtrado, int proyecto, int vstart, int vlength, String draw, int estado) {
		JSONObject obj = null;
		try {
			obj = dao.listadoPrincipal(filtro,filtrado, proyecto, vstart, vlength, draw,estado);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return obj;
	}

	public int desactivarTipoUsuario(int codigo) {
		int rs = 0;
		try {
			rs = dao.desactivarTipoUsuario(codigo);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return rs;
	}

	public int activarTipoUsuario(int codigo) {
		int rs = 0;
		try {
			rs = dao.activarTipoUsuario(codigo);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return rs;
	}

	public int editarTipoUsuario(int codigo, String nombre) {
		int rs = 0;
		try {
			rs = dao.editarTipoUsuario(codigo, nombre);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return rs;
	}

	public int crearTipoUsuario(String nombre) {
		int rs = 0;
		try {
			rs = dao.crearTipoUsuario(nombre);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return rs;
	}

	public int validarTipoUsuario(int codigo) {
		int cant = 0;
		try {
			cant = dao.validarTipoUsuario(codigo);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return cant;
	}

	public int validarNombreTipoUsuario(String nombreInicial, String nombreIngreso, int tipo) {
		int cant = 0;
		try {
			cant = dao.validarNombreTipoUsuario(nombreInicial, nombreIngreso, tipo);
		} catch (Exception e) {
			System.out.println("Error en listado principal service" + e.getMessage());
		}
		return cant;
	}

};