/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycompany.moduloseguridad.services;

import com.mycompany.moduloseguridad.dao.DAOFactory;
import com.mycompany.moduloseguridad.dao.MenuDAO;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class MenuService {

	DAOFactory fabrica = DAOFactory.getDAOFactory(DAOFactory.MYSQL);
	MenuDAO dao = fabrica.getMenuDAO();

	public JSONArray listarProyecto(int estado) {
		JSONArray obj = null;
		try {
			obj = dao.listarProyecto(estado);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONArray listarTipoDeUsuario(int proyecto) {
		JSONArray obj = null;
		try {
			obj = dao.listarTipoDeUsuario(proyecto);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONArray listarTituloCompleto(int proyecto_detalle, int proyecto, int tipo) {
		JSONArray obj = null;
		try {
			obj = dao.listarTituloCompleto(proyecto_detalle, proyecto, tipo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONArray listarModuloCompleto(int titulo, int proyecto_detalle, int proyecto, int tipo) {
		JSONArray obj = null;
		try {
			obj = dao.listarModuloCompleto(titulo, proyecto_detalle, proyecto, tipo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONArray listarCategoriaCompleto(int modulo, int proyecto_detalle, int proyecto, int tipo) {
		JSONArray obj = null;
		try {
			obj = dao.listarCategoriaCompleto(modulo, proyecto_detalle, proyecto, tipo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONArray listarSubCategoriaCompleto(int categoria, int proyecto_detalle, int proyecto, int tipo) {
		JSONArray obj = null;
		try {
			obj = dao.listarSubCategoriaCompleto(categoria, proyecto_detalle, proyecto, tipo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject editarTitulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.editarTitulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject editarModulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.editarModulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject editarCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.editarCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject editarSubCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.editarSubCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject nuevoTitulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.nuevoTitulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject nuevoSubCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.nuevoSubCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject nuevoModulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.nuevoModulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject nuevoCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.nuevoCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject eliminarDetalleTitulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.eliminarDetalleTitulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject eliminarDetalleModulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.eliminarDetalleModulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject eliminarDetalleCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.eliminarDetalleCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject eliminarDetalleSubCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.eliminarDetalleSubCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject cambiarOrdenSubCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.cambiarOrdenSubCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject cambiarOrdenCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.cambiarOrdenCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject cambiarOrdenModulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.cambiarOrdenModulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject cambiarOrdenTitulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.cambiarOrdenTitulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject reconocerNombreSimilar(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.reconocerNombreSimilar(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject nuevoTituloExistente(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.nuevoTituloExistente(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject nuevoModuloExistente(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.nuevoModuloExistente(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject nuevoCategoriaExistente(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.nuevoCategoriaExistente(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject nuevoSubCategoriaExistente(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.nuevoSubCategoriaExistente(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject validarEdicionTitulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.validarEdicionTitulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject validarEdicionModulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.validarEdicionModulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject validarEdicionCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.validarEdicionCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject validarEdicionSubCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.validarEdicionSubCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject listarTitulo(JSONObject datos, String draw, String start, String length) {
		JSONObject obj = null;
		try {
			obj = dao.listarTitulo(datos, draw, start, length);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject listarModulo(JSONObject datos, String draw, String start, String length) {
		JSONObject obj = null;
		try {
			obj = dao.listarModulo(datos, draw, start, length);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject listarCategoria(JSONObject datos, String draw, String start, String length) {
		JSONObject obj = null;
		try {
			obj = dao.listarCategoria(datos, draw, start, length);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject listarSubCategoria(JSONObject datos, String draw, String start, String length) {
		JSONObject obj = null;
		try {
			obj = dao.listarSubCategoria(datos, draw, start, length);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject validarElminarTitulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.validarElminarTitulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject validarElminarModulo(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.validarElminarModulo(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject validarElminarCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.validarElminarCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject validarElminarSubCategoria(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.validarElminarSubCategoria(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject eliminarMenusAninado(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.eliminarMenusAninado(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject eliminarMenusAninadoGeneral(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.eliminarMenusAninadoGeneral(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject listarPermisosPorVista(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.listarPermisosPorVista(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONArray obtenerAcciones(int codigo, int jerarquia, int tipo_usuario) {
		JSONArray obj = null;
		try {
			obj = dao.obtenerAcciones(codigo,jerarquia,tipo_usuario);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject asignarAccionesPorVista(JSONObject json) {
		JSONObject obj = null;
		try {
			obj = dao.asignarAccionesPorVista(json);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
}