/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycompany.moduloseguridad.mysqldao;

import java.sql.Connection;
import java.sql.DriverManager;
import com.mycompany.moduloseguridad.dao.DAOFactory;
import com.mycompany.moduloseguridad.dao.ProyectoDAO;
import com.mycompany.moduloseguridad.dao.MenuDAO;
import com.mycompany.moduloseguridad.dao.TipoUsuarioDAO;
import com.mycompany.moduloseguridad.dao.UsuarioDAO;
import com.mycompany.moduloseguridad.utilities.dotenSrv;

public class MySQLDAOFactory extends DAOFactory {

	public static Connection getConnectionSQL(String base) {
		Connection conexion = null;
		String host = "";
		String port = "";
		String databaseName = "";
		String userSgbd = "";
		String passwordSgbd = "";
		if (base.equalsIgnoreCase("security")) {
			host = dotenSrv.obtenerValorVariableEntorno("MYSQL_SECURITY_DB_HOST");
			port = dotenSrv.obtenerValorVariableEntorno("MYSQL_SECURITY_DB_PORT");
			databaseName = dotenSrv.obtenerValorVariableEntorno("MYSQL_SECURITY_DB_NAME");
			userSgbd = dotenSrv.obtenerValorVariableEntorno("MYSQL_SECURITY_DB_USER");
			passwordSgbd = dotenSrv.obtenerValorVariableEntorno("MYSQL_SECURITY_DB_PASS");
			String url = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?characterEncoding=utf8&useSSL=false&zeroDateTimeBehavior=convertToNull";
//			System.out.println("Conectando a la base de datos : "+url+ " con el usuario : "+userSgbd+ " y password : "+passwordSgbd);
			try {
				Class.forName("com.mysql.jdbc.Driver");/*Produccion*/
				conexion = DriverManager.getConnection(url, userSgbd, passwordSgbd);
			} catch (Exception e) {
				System.out.println("Error al conectarse a la bd : "+e.getMessage());
			}
		}
		return conexion;
	}

	@Override
	public TipoUsuarioDAO getTipoUsuario() {
		return new TipoUsuarioMYSQLDAO();
	}

	@Override
	public ProyectoDAO getProyectoDAO() {
		return new ProyectoMYSQLDAO();
	}

	@Override
	public UsuarioDAO getUsuarioDAO() {
		return new UsuarioMYSQLDAO();
	}

	@Override
	public MenuDAO getMenuDAO() {
		return new MenuMYSQLDAO();
	}
}