/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycompany.moduloseguridad.dao;

import org.json.JSONArray;
import org.json.JSONObject;

import java.sql.SQLException;

/**
 * @author sistem17user
 */
public interface MenuDAO {

    JSONArray listarProyecto(int estado) throws Exception;

    JSONArray listarTipoDeUsuario(int proyecto) throws Exception;

    JSONArray listarTituloCompleto(int proyecto_detalle, int proyecto, int tipo) throws Exception;

    JSONArray listarModuloCompleto(int titulo, int proyecto_detalle, int proyecto, int tipo) throws Exception;

    JSONArray listarCategoriaCompleto(int modulo, int proyecto_detalle, int proyecto, int tipo) throws Exception;

    JSONArray listarSubCategoriaCompleto(int categoria, int proyecto_detalle, int proyecto, int tipo) throws Exception;

    JSONObject editarTitulo(JSONObject datos) throws Exception;

    JSONObject editarModulo(JSONObject datos) throws Exception;

    JSONObject editarCategoria(JSONObject datos) throws Exception;

    JSONObject editarSubCategoria(JSONObject datos) throws Exception;

    JSONObject nuevoTitulo(JSONObject datos) throws Exception;

    JSONObject nuevoModulo(JSONObject datos) throws Exception;

    JSONObject nuevoCategoria(JSONObject datos) throws Exception;

    JSONObject nuevoSubCategoria(JSONObject datos) throws Exception;

    JSONObject eliminarDetalleTitulo(JSONObject datos) throws Exception;

    JSONObject eliminarDetalleModulo(JSONObject datos) throws Exception;

    JSONObject eliminarDetalleCategoria(JSONObject datos) throws Exception;

    JSONObject eliminarDetalleSubCategoria(JSONObject datos) throws Exception;

    JSONObject cambiarOrdenTitulo(JSONObject datos) throws Exception;

    JSONObject cambiarOrdenModulo(JSONObject datos) throws Exception;

    JSONObject cambiarOrdenCategoria(JSONObject datos) throws Exception;

    JSONObject cambiarOrdenSubCategoria(JSONObject datos) throws Exception;

    JSONObject reconocerNombreSimilar(JSONObject datos) throws Exception;

    JSONObject nuevoTituloExistente(JSONObject datos) throws Exception;

    JSONObject nuevoModuloExistente(JSONObject datos) throws Exception;

    JSONObject nuevoCategoriaExistente(JSONObject datos) throws Exception;

    JSONObject nuevoSubCategoriaExistente(JSONObject datos) throws Exception;

    JSONObject validarEdicionTitulo(JSONObject datos) throws Exception;

    JSONObject validarEdicionModulo(JSONObject datos) throws Exception;

    JSONObject validarEdicionCategoria(JSONObject datos) throws Exception;

    JSONObject validarEdicionSubCategoria(JSONObject datos) throws Exception;

    JSONObject listarTitulo(JSONObject datos, String draw, String start, String length) throws Exception;

    JSONObject listarModulo(JSONObject datos, String draw, String start, String length) throws Exception;

    JSONObject listarCategoria(JSONObject datos, String draw, String start, String length) throws Exception;

    JSONObject listarSubCategoria(JSONObject datos, String draw, String start, String length) throws Exception;

    JSONObject validarElminarTitulo(JSONObject datos) throws Exception;

    JSONObject validarElminarModulo(JSONObject datos) throws Exception;

    JSONObject validarElminarCategoria(JSONObject datos) throws Exception;

    JSONObject validarElminarSubCategoria(JSONObject datos) throws Exception;

    JSONObject eliminarMenusAninado(JSONObject datos) throws Exception;

    JSONObject eliminarMenusAninadoGeneral(JSONObject datos) throws Exception;

    JSONArray obtenerAcciones(int codigo, int jerarquia, int tipo_usuario) throws Exception;

    JSONObject listarPermisosPorVista(JSONObject datos) throws Exception;

    JSONObject asignarAccionesPorVista(JSONObject json) throws SQLException;
}