/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import moduloSeguridad.services.MenuService;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author Felipe Escala
 */
public class MantenimientoMenuServlet extends HttpServlet {

	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		String accion = request.getParameter("accion");
		switch (accion) {
			case "listarProyecto":
				listarProyecto(request, response);
				break;
			case "listarTipoUsuario":
				listarTipoUsuario(request, response);
				break;
			case "listarMenu":
				listarMenu(request, response);
				break;
			case "editarMenu":
				editarMenu(request, response);
				break;
			case "nuevoMenu":
				nuevoTituloGeneral(request, response);
				break;
			case "eliminarDetalleMenu":
				eliminarDetalleMenu(request, response);
				break;
			case "cambiarOrden":
				cambiarOrden(request, response);
				break;
			case "reconocerNombreSimilar":
				reconocerNombreSimilar(request, response);
				break;
			case "nuevoMenuExistente":
				nuevoMenuExistente(request, response);
				break;
			case "validarEdicionMenu":
				validarEdicionMenu(request, response);
				break;
			case "listarMenuDetalle":
				listarMenuDetalle(request, response);
				break;
			case "validarEliminarDetalle":
				validarEliminarDetalle(request, response);
				break;
			case "eliminarMenusAninado":
				eliminarMenusAninado(request, response);
				break;
			default:
				break;
		}
	}

	private void listarProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONArray rs = srv.listarProyecto();
		out.println(rs);
	}

	private void listarTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		JSONArray rs = srv.listarTipoDeUsuario(codigo);
		out.println(rs);
	}

	private void listarMenu(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		int proyecto_detalle = Integer.parseInt(request.getParameter("codigo"));
		int tipo = Integer.parseInt(request.getParameter("tipo"));
		int proyecto = Integer.parseInt(request.getParameter("proyecto"));
		String draw = request.getParameter("draw");
		JSONObject rs = new JSONObject();
		JSONArray lista = new JSONArray();
		JSONArray listaTitulo = srv.listarTituloCompleto(proyecto_detalle, proyecto, tipo);
		int cantidad;
		int iTitulo = 0;
		for (int i = 0; i < listaTitulo.length(); i++) {
			int iModulo = 0;
			JSONObject obj1 = new JSONObject();
			JSONObject objTitulo = (JSONObject) listaTitulo.get(i);
			String nombreTitulo = objTitulo.getString("nombreTitulo");
			int codigoTitulo = objTitulo.getInt("codigoTitulo");
			int configuracionTitulo = objTitulo.getInt("configuracionTitulo");
			String iconoTitulo = objTitulo.getString("iconoTitulo");
			int ordenTitulo = objTitulo.getInt("ordenTitulo");
			iTitulo++;
			obj1.put("conta", iTitulo);
			obj1.put("jerarquia", 1);
			obj1.put("nombre", nombreTitulo);
			obj1.put("codigo", codigoTitulo);
			obj1.put("icono", iconoTitulo);
			obj1.put("url", "");
			obj1.put("tipo", "");
			obj1.put("configuracion", configuracionTitulo);
			obj1.put("padre", 0);
			obj1.put("orden", ordenTitulo);
			lista.put(obj1);
			JSONArray listaModulo = srv.listarModuloCompleto(codigoTitulo, proyecto_detalle, proyecto, tipo);
			for (int j = 0; j < listaModulo.length(); j++) {
				int iCategoria = 0;
				JSONObject obj2 = new JSONObject();
				JSONObject objModulo = (JSONObject) listaModulo.get(j);
				String nombreModulo = objModulo.getString("nombreModulo");
				int codigoModulo = objModulo.getInt("codigoModulo");
				int configuracionModulo = objModulo.getInt("configuracionModulo");
				String iconoModulo = objModulo.getString("iconoModulo");
				String urlModulo = objModulo.getString("urlModulo");
				int tipoModulo = objModulo.getInt("tipoModulo");
				int padreModulo = objModulo.getInt("codigoTitulo");
				int ordenModulo = objModulo.getInt("ordenModulo");
				iModulo++;
				obj2.put("conta", iModulo);
				obj2.put("jerarquia", 2);
				obj2.put("nombre", nombreModulo);
				obj2.put("codigo", codigoModulo);
				obj2.put("icono", iconoModulo);
				obj2.put("url", urlModulo);
				obj2.put("tipo", tipoModulo);
				obj2.put("configuracion", configuracionModulo);
				obj2.put("padre", padreModulo);
				obj2.put("orden", ordenModulo);
				lista.put(obj2);
				JSONArray listaCategoria = srv.listarCategoriaCompleto(codigoModulo, proyecto_detalle, proyecto, tipo);
				for (int k = 0; k < listaCategoria.length(); k++) {
					int iSubCategoria = 0;
					JSONObject obj3 = new JSONObject();
					JSONObject objCategoria = (JSONObject) listaCategoria.get(k);
					String nombreCategoria = objCategoria.getString("nombreCategoria");
					int codigoCategoria = objCategoria.getInt("codigoCategoria");
					int configuracionCategoria = objCategoria.getInt("configuracionCategoria");
					String urlCategoria = objCategoria.getString("urlCategoria");
					int tipoCategoria = objCategoria.getInt("tipoCategoria");
					int padreCategoria = objCategoria.getInt("codigoModulo");
					int ordenCategoria = objCategoria.getInt("ordenCategoria");
					iCategoria++;
					obj3.put("conta", iCategoria);
					obj3.put("jerarquia", 3);
					obj3.put("nombre", nombreCategoria);
					obj3.put("codigo", codigoCategoria);
					obj3.put("url", urlCategoria);
					obj3.put("icono", "");
					obj3.put("tipo", tipoCategoria);
					obj3.put("configuracion", configuracionCategoria);
					obj3.put("padre", padreCategoria);
					obj3.put("orden", ordenCategoria);
					lista.put(obj3);
					JSONArray listaSubCategoria = srv.listarSubCategoriaCompleto(codigoCategoria, proyecto_detalle, proyecto, tipo);
					for (int l = 0; l < listaSubCategoria.length(); l++) {
						JSONObject obj4 = new JSONObject();
						JSONObject objSubCategoria = (JSONObject) listaSubCategoria.get(l);
						String nombreSubCategoria = objSubCategoria.getString("nombreSubCategoria");
						int codigoSubCategoria = objSubCategoria.getInt("codigoSubCategoria");
						int configuracionSubCategoria = objSubCategoria.getInt("configuracionSubCategoria");
						String urlSubCategoria = objSubCategoria.getString("urlSubCategoria");
						int padreSubCategoria = objSubCategoria.getInt("codigoCategoria");
						int ordenSubCategoria = objSubCategoria.getInt("ordenSubCategoria");
						iSubCategoria++;
						obj4.put("conta", iSubCategoria);
						obj4.put("jerarquia", 4);
						obj4.put("nombre", nombreSubCategoria);
						obj4.put("codigo", codigoSubCategoria);
						obj4.put("url", urlSubCategoria);
						obj4.put("icono", "");
						obj4.put("tipo", "");
						obj4.put("configuracion", configuracionSubCategoria);
						obj4.put("padre", padreSubCategoria);
						obj4.put("orden", ordenSubCategoria);
						lista.put(obj4);
					}
				}
			}
		}
		cantidad = lista.length();
		rs.put("data", lista);
		rs.put("draw", draw);
		rs.put("recordsFiltered", cantidad);
		rs.put("recordsTotal", cantidad);
		out.print(rs);
	}

	private void editarMenu(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.editarTitulo(json);
				break;
			case 2:
				rs = srv.editarModulo(json);
				break;
			case 3:
				rs = srv.editarCategoria(json);
				break;
			case 4:
				rs = srv.editarSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void nuevoTituloGeneral(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.nuevoTitulo(json);
				break;
			case 2:
				rs = srv.nuevoModulo(json);
				break;
			case 3:
				rs = srv.nuevoCategoria(json);
				break;
			case 4:
				rs = srv.nuevoSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void eliminarDetalleMenu(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.eliminarDetalleTitulo(json);
				break;
			case 2:
				rs = srv.eliminarDetalleModulo(json);
				break;
			case 3:
				rs = srv.eliminarDetalleCategoria(json);
				break;
			case 4:
				rs = srv.eliminarDetalleSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void cambiarOrden(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.cambiarOrdenTitulo(json);
				break;
			case 2:
				rs = srv.cambiarOrdenModulo(json);
				break;
			case 3:
				rs = srv.cambiarOrdenCategoria(json);
				break;
			case 4:

				rs = srv.cambiarOrdenSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void reconocerNombreSimilar(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		rs = srv.reconocerNombreSimilar(json);
		out.println(rs);
	}

	private void nuevoMenuExistente(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.nuevoTituloExistente(json);
				break;
			case 2:
				rs = srv.nuevoModuloExistente(json);
				break;
			case 3:
				rs = srv.nuevoCategoriaExistente(json);
				break;
			case 4:
				rs = srv.nuevoSubCategoriaExistente(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void validarEdicionMenu(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.validarEdicionTitulo(json);
				break;
			case 2:
				rs = srv.validarEdicionModulo(json);
				break;
			case 3:
				rs = srv.validarEdicionCategoria(json);
				break;
			case 4:
				rs = srv.validarEdicionSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void listarMenuDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		String draw = request.getParameter("draw");
		String start = request.getParameter("start");
		String length = request.getParameter("length");
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.listarTitulo(json, draw, start, length);
				break;
			case 2:
				rs = srv.listarModulo(json, draw, start, length);
				break;
			case 3:
				rs = srv.listarCategoria(json, draw, start, length);
				break;
			case 4:
				rs = srv.listarSubCategoria(json, draw, start, length);
				break;
			default:
		}
		out.print(rs);
	}

	private void validarEliminarDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs = null;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int jerarquia = json.getInt("jerarquia");
		switch (jerarquia) {
			case 1:
				rs = srv.validarElminarTitulo(json);
				break;
			case 2:
				rs = srv.validarElminarModulo(json);
				break;
			case 3:
				rs = srv.validarElminarCategoria(json);
				break;
			case 4:
				rs = srv.validarElminarSubCategoria(json);
				break;
			default:
		}
		out.print(rs);
	}

	private void eliminarMenusAninado(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		MenuService srv = new MenuService();
		JSONObject rs;
		String jsonString = request.getParameter("json");
		JSONObject json = new JSONObject(jsonString);
		int configuracion = json.getInt("vista");
		if (configuracion != 0) {
			rs = srv.eliminarMenusAninado(json);
		} else {
			rs = srv.eliminarMenusAninadoGeneral(json);
		}
		out.print(rs);
	}

}
