/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.services;

import moduloSeguridad.dao.DAOFactory;
import moduloSeguridad.dao.TipoUsuarioDAO;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class TipoUsuarioService {

	DAOFactory fabrica = DAOFactory.getDAOFactory(DAOFactory.SQLSERVER);
	TipoUsuarioDAO dao = fabrica.getTipoUsuario();
        
        public JSONObject listarProyectos() {
		JSONObject obj = null;
		try {
			obj = dao.listarProyectos();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
        
        public JSONObject listarTiposUsuarios(int codigoProyecto) {
		JSONObject obj = null;
		try {
			obj = dao.listarTiposUsuarios(codigoProyecto);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
        
        public JSONObject asignarAcciones(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.asignarAcciones(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
        
        public JSONObject listarAcciones(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.listarAcciones(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
        
        public JSONObject listarCboAcciones() {
		JSONObject obj = null;
		try {
			obj = dao.listarCboAcciones();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
        
        public JSONObject activarDesactivarAccion(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.activarDesactivarAccion(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
        
        public JSONObject activarDesactivarTipoUsuario(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.activarDesactivarTipoUsuario(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONObject listadoPrincipal(String filtro,int filtrado, int proyecto, int vstart, int vlength, String draw) {
		JSONObject obj = null;
		try {
			obj = dao.listadoPrincipal(filtro,filtrado, proyecto, vstart, vlength, draw);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public int desactivarTipoUsuario(int codigo) {
		int rs = 0;
		try {
			rs = dao.desactivarTipoUsuario(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int activarTipoUsuario(int codigo) {
		int rs = 0;
		try {
			rs = dao.activarTipoUsuario(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int editarTipoUsuario(int codigo, String nombre) {
		int rs = 0;
		try {
			rs = dao.editarTipoUsuario(codigo, nombre);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int crearTipoUsuario(String nombre) {
		int rs = 0;
		try {
			rs = dao.crearTipoUsuario(nombre);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarTipoUsuario(int codigo) {
		int cant = 0;
		try {
			cant = dao.validarTipoUsuario(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return cant;
	}

	public int validarNombreTipoUsuario(String nombreInicial, String nombreIngreso, int tipo) {
		int cant = 0;
		try {
			cant = dao.validarNombreTipoUsuario(nombreInicial, nombreIngreso, tipo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return cant;
	}

};
