/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.dao;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public interface MenuDAO {

    public JSONArray listarProyecto() throws Exception;

    public JSONArray listarTipoDeUsuario(int proyecto) throws Exception;

    public JSONArray listarTituloCompleto(int proyecto_detalle, int proyecto, int tipo) throws Exception;

    public JSONArray listarModuloCompleto(int titulo, int proyecto_detalle, int proyecto, int tipo) throws Exception;

    public JSONArray listarCategoriaCompleto(int modulo, int proyecto_detalle, int proyecto, int tipo) throws Exception;

    public JSONArray listarSubCategoriaCompleto(int categoria, int proyecto_detalle, int proyecto, int tipo) throws Exception;

    public JSONObject editarTitulo(JSONObject datos) throws Exception;

    public JSONObject editarModulo(JSONObject datos) throws Exception;

    public JSONObject editarCategoria(JSONObject datos) throws Exception;

    public JSONObject editarSubCategoria(JSONObject datos) throws Exception;

    public JSONObject nuevoTitulo(JSONObject datos) throws Exception;

    public JSONObject nuevoModulo(JSONObject datos) throws Exception;

    public JSONObject nuevoCategoria(JSONObject datos) throws Exception;

    public JSONObject nuevoSubCategoria(JSONObject datos) throws Exception;

    public JSONObject eliminarDetalleTitulo(JSONObject datos) throws Exception;

    public JSONObject eliminarDetalleModulo(JSONObject datos) throws Exception;

    public JSONObject eliminarDetalleCategoria(JSONObject datos) throws Exception;

    public JSONObject eliminarDetalleSubCategoria(JSONObject datos) throws Exception;

    public JSONObject cambiarOrdenTitulo(JSONObject datos) throws Exception;

    public JSONObject cambiarOrdenModulo(JSONObject datos) throws Exception;

    public JSONObject cambiarOrdenCategoria(JSONObject datos) throws Exception;

    public JSONObject cambiarOrdenSubCategoria(JSONObject datos) throws Exception;

    public JSONObject reconocerNombreSimilar(JSONObject datos) throws Exception;

    public JSONObject nuevoTituloExistente(JSONObject datos) throws Exception;

    public JSONObject nuevoModuloExistente(JSONObject datos) throws Exception;

    public JSONObject nuevoCategoriaExistente(JSONObject datos) throws Exception;

    public JSONObject nuevoSubCategoriaExistente(JSONObject datos) throws Exception;

    public JSONObject validarEdicionTitulo(JSONObject datos) throws Exception;

    public JSONObject validarEdicionModulo(JSONObject datos) throws Exception;

    public JSONObject validarEdicionCategoria(JSONObject datos) throws Exception;

    public JSONObject validarEdicionSubCategoria(JSONObject datos) throws Exception;

    public JSONObject listarTitulo(JSONObject datos, String draw, String start, String length) throws Exception;

    public JSONObject listarModulo(JSONObject datos, String draw, String start, String length) throws Exception;

    public JSONObject listarCategoria(JSONObject datos, String draw, String start, String length) throws Exception;

    public JSONObject listarSubCategoria(JSONObject datos, String draw, String start, String length) throws Exception;

    public JSONObject validarElminarTitulo(JSONObject datos) throws Exception;

    public JSONObject validarElminarModulo(JSONObject datos) throws Exception;

    public JSONObject validarElminarCategoria(JSONObject datos) throws Exception;

    public JSONObject validarElminarSubCategoria(JSONObject datos) throws Exception;

    public JSONObject eliminarMenusAninado(JSONObject datos) throws Exception;

    public JSONObject eliminarMenusAninadoGeneral(JSONObject datos) throws Exception;
}
