   /* global bootbox */
    let nombreTipoUsuario = "";
    let codProyectoDetalle = 0;
    
    function activarDesactivarAccion(cod){
        return new Promise((resolve, reject) => {
           $.ajax({
              type: 'POST',
              url: "../servlet/TipoUsuarioServlet?accion=activarDesactivarAccion",
              dataType: 'json',
              data:{
                  codAccionDetalle: cod
              },
              success: function (data, textStatus, jqXHR) {
                 resolve(data);
              }, error: function (jqXHR, textStatus, errorThrown) {
                 reject("Error al listar las asignaciones.");
              }
           });
        }).then(data => {
                      if (data.status) {
                          $("#tblDetalleAcciones").DataTable().ajax.reload();
                      }
                  });
    }
    
    function activarDesactivarTipoUsuario(cod){
        return new Promise((resolve, reject) => {
           $.ajax({
              type: 'POST',
              url: "../servlet/TipoUsuarioServlet?accion=activarDesactivarTipoUsuario",
              dataType: 'json',
              data:{
                  codProyectoDetalle: cod
              },
              success: function (data, textStatus, jqXHR) {
                 resolve(data);
              }, error: function (jqXHR, textStatus, errorThrown) {
                 reject("Error al listar las asignaciones.");
              }
           });
        }).then(data => {
                      if (data.status) {
                          $("#tblTipoUsuario").DataTable().ajax.reload();
                      }
                  });
    }
    
    //tabla de listar acciones
    function listarTablaAcciones(cod){

       var jsonAcciones = {
          "codProyDetalle": cod
       };

       tablaDetalleAcciones = $("#tblDetalleAcciones").DataTable({
          "language": {
             "lengthMenu": "Mostrar: _MENU_",
             "zeroRecords": "&nbsp;&nbsp;&nbsp; No se encontraron resultados",
             "info": "&nbsp;&nbsp;&nbsp; Mostrando del _START_ al _END_ de un total de _TOTAL_ acciones",
             "infoEmpty": "&nbsp;&nbsp;&nbsp; Mostrando 0 de 0 registros",
             "search": "Filtrar:",
             "loadingRecords": "Cargando...",
             "processing": '<span style="width:100%;"><img src="http://www.snacklocal.com/images/ajaxload.gif"></span>',
             "scrollY": false,
             "paginate": {
                "first": "First",
                "last": "Last",
                "next": "Siguiente",
                "previous": "Anterior"
             }
          },
          dom: '<"datatable-scroll"t>r<"datatable-footers"ip>',
          "ajax": {
             type: 'POST',
             "url": '../servlet/TipoUsuarioServlet?accion=listarAcciones',
             data: jsonAcciones
          },
          "bSort": false,
          "bFilter": false,
          "serverSide": true,
          "processing": true,
          "aaSorting": [],
          "ordering": false,
          "bLengthChange": false,
          "bInfo": true,
          "paging": true,
          "iDisplayLength": 5,
          "columnDefs": [
             {targets: 0, orderable: false, width: "7%", className: "text-center"},
             {targets: 1, orderable: false, width: "30%", className: "text-left"},
             {targets: 2, orderable: false, width: "10%", className: "text-center"},
             {targets: 3, orderable: false, width: "10%", className: "text-center"}
          ],
          "columns": [
                {"data": "numeral"},
                {"data": "Accion"},
                {"data": "estado_detalle",
                  render: function (data, type, row) {
                     var retorno;
                     if (data === 0) {
                        retorno = "<span class='label label-danger' style='color: white'>INACTIVO</span>";
                     } else if (data === 1) {
                        retorno = '<span class="label label-success" style="color: white">ACTIVO</span>';
                     }
                     return retorno;
                  }
               },

            {"data": "estado_detalle",
                  render: function (data, type, row) {
                     var retorno;
                     if (data === 0) {
                        retorno = '<span data-toggle="tooltip" title="Activar" style="color:green;cursor:pointer;" class="bttnActivarAccion" style="cursor: pointer"> <i class="glyphicon glyphicon-off text-green-800"></i> &nbsp;&nbsp;&nbsp; </span>';
                     } else if (data === 1) {
                        retorno = '<span data-toggle="tooltip" title="Desactivar" style="color:red;cursor:pointer;" class="bttnDesactivarAccion" style="cursor: pointer"> <i class="glyphicon glyphicon-off text-red-800"></i> &nbsp;&nbsp;&nbsp; </span>';
                     }
                     return retorno;
                  }
            }
          ]

       });
       
       obtenener_data_tablaAcciones("#tblDetalleAcciones tbody",tablaDetalleAcciones);
    }
    
    var obtenener_data_tablaAcciones = function(tbody, tabla){
         var table = $('#tblDetalleAcciones').DataTable();
         $('#tblDetalleAcciones tbody').off('click');

         $("tbody").on('click', '.bttnDesactivarAccion', function() {

             var data = tabla.row($(this).parents('tr')).data();
             
             activarDesactivarAccion(data.cod_accion_detalle);

         });
         
         $("tbody").on('click', '.bttnActivarAccion', function() {

             var data = tabla.row($(this).parents('tr')).data();
             
             activarDesactivarAccion(data.cod_accion_detalle);

         });
     }
    
    
   //cargar el combo de tipo de usuario dependiendo del proyecto elegido
   $("#cboProyectos").on("change", function(){
      
      let codProy = $("#cboProyectos").val();
      
      if(codProy != 0){
          cargarTiposUsuarioPorProyecto(parseInt(codProy));
      }
      
   });
   
   
   function segundaCarga() {
      cargarProyectos();
      //datosTipoUsuario.listarTipoUsuario();
      soloLetras('txtTipoDeUsuario');
      editarTipoUsuario();
      desactivarTipoUsuario();
      activarTipoUsuario();
      submitKey('formTipoUsuario', '#btnBuscar');
   }
   
   function cargarProyectos(){
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: '../servlet/TipoUsuarioServlet?accion=listarProyectos',
                dataType: "json",
                success: function (data, textStatus, jqXHR) {
                    resolve(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    reject('Error en la petición');
                }
            });
        })
                .then(data => {
                    let print = '';
                    if (data.status) {
                        let print = "";
                        print += '<option value="0">[TODOS]</option>';
                        var lista = data.data;
                        lista.forEach(v => {
                            print += '<option value="' + v.codigoProyecto +'">'+v.nombreProyecto+'</option>';
                        });
                        $("#cboProyectos").html(print);
                        
                        $("#cboProyectos").prop("disabled", false);
                    } 
                });
   }
   
   function cargarTiposUsuarioPorProyecto(codigoProyecto){
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: '../servlet/TipoUsuarioServlet?accion=listarTiposUsuarios',
                dataType: "json",
                data: {
                    codigoProy:codigoProyecto
                },
                success: function (data, textStatus, jqXHR) {
                    resolve(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    reject('Error en la petición');
                }
            });
        })
                .then(data => {
                    let print = '';
                    if (data.status) {
                        let print = "";
                        print += '<option value="0">[TODOS]</option>';
                        var lista = data.data;
                        lista.forEach(v => {
                            print += '<option value="' + v.codTipoUsuario +'">'+v.nomTipoUsuario+'</option>';
                        });
                        $("#cboTipoUsuarios").html(print);
                    } 
                });
   }


   var datosTipoUsuario = {
       listarTipoUsuario: function () {
           
         var filtro = $('#cboTipoUsuarios').val();
         var cboProyecto = $("#cboProyectos").val();
         
         var tipoFiltrado = 0;
         
         if(filtro == 0 && cboProyecto != 0){
             tipoFiltrado = 1;//solo buscara por proyecto
         }else if(filtro != 0 && cboProyecto == 0){
             tipoFiltrado = 2;//solo buscara por proyecto y tipodeusuario
         }
         
         var json = {
            "filtro": filtro,
            "filtrado":tipoFiltrado,
            "valorCboProyecto":cboProyecto
         };
         
         tabla = $("#tblTipoUsuario").DataTable({
            "language": {
               "lengthMenu": "Mostrar: _MENU_",
               "zeroRecords": "&nbsp;&nbsp;&nbsp; No se encontraron resultados",
               "info": "&nbsp;&nbsp;&nbsp; Mostrando del _START_ al _END_ de un total de _TOTAL_ Tipos de Usuarios",
               "infoEmpty": "&nbsp;&nbsp;&nbsp; Mostrando 0 de 0 registros",
               "search": "Filtrar:",
               "loadingRecords": "Cargando...",
               "processing": '<span style="width:100%;"><img src="http://www.snacklocal.com/images/ajaxload.gif"></span>',
               "scrollY": false,
               "paginate": {
                  "first": "First",
                  "last": "Last",
                  "next": "Siguiente",
                  "previous": "Anterior"
               }
            },
            dom: '<"datatable-scroll"t>r<"datatable-footers"ip>',
            "ajax": {
               type: 'POST',
               "url": '../servlet/TipoUsuarioServlet?accion=listadoPrincipal',
               data: json
            },
            "bSort": false,
            "bFilter": false,
            "serverSide": true,
            "processing": true,
            "aaSorting": [],
            "ordering": false,
            "bLengthChange": false,
            "bInfo": true,
            "paging": true,
            "iDisplayLength": 15,
            "columnDefs": [
               {targets: 0, orderable: false, width: "7%", className: "text-center"},
               {targets: 1, orderable: false, width: "10%", className: "text-center"},
               {targets: 2, orderable: false, width: "20%"},
               {targets: 3, orderable: false, width: "10%", className: "text-center"},
               {targets: 4, orderable: false, width: "7%", className: "text-center"}
            ],
            "columns": [
               {"data": "numeral"},
               {"data": "Proyecto"},
               {"data": "Tipo_Usuario"},
               {"data": "est",
                  render: function (data, type, row) {
                     var retorno;
                     if (data === false) {
                        retorno = "<span class='label label-danger' style='color: white'>INACTIVO</span>";
                     } else if (data === true) {
                        retorno = '<span class="label label-success" style="color: white">ACTIVO</span>';
                     }
                     return retorno;
                  }
               },
               {"data": "est", "render": function (data, type, row) {
                     let retorno = ``;
                     if (data === true) {
                        retorno += `
                                            <span data-toggle="tooltip" class="bttnDesactivarTipUsuario" title="Desactivar" style="cursor: pointer"> <i class='desactivar icon-user-block text-danger-800'></i> </span>`;
                     } else {
                        retorno += `
                                            <span data-toggle="tooltip" class="bttnActivarTipUsuario" title="Activar" style="cursor: pointer"> <i class='activar icon-user-check text-success-800'></i> </span>`;
                     }
                     retorno += `
                                            <span data-toggle="tooltip" title="Detalle" style="cursor: pointer"> <i class='bttnDetalle glyphicon glyphicon-cog text-success-800'></i> </span>`;
                     return retorno;
                  }

               }
            ]

         });
         obtenener_data("#tblTipoUsuario tbody",tabla);
      }
      
   };
   
   var obtenener_data = function(tbody, tabla){
        var table = $('#tblTipoUsuario').DataTable();
        $('#tblTipoUsuario tbody').off('click');

        $("tbody").on('click', '.bttnDetalle', function() {
            
            var data = tabla.row($(this).parents('tr')).data();
            
            nombreTipoUsuario = data.Tipo_Usuario;
            codProyectoDetalle = data.cod_proyecto_detalle;
            
            modalListadoAcciones(data.cod_proyecto_detalle, data.Tipo_Usuario);
            
        });
        
        $("tbody").on('click', '.bttnActivarTipUsuario', function() {
            
            var data = tabla.row($(this).parents('tr')).data();
            
            activarDesactivarTipoUsuario(data.cod_proyecto_detalle);
            
        });
        
        $("tbody").on('click', '.bttnDesactivarTipUsuario', function() {
            
            var data = tabla.row($(this).parents('tr')).data();
            
            activarDesactivarTipoUsuario(data.cod_proyecto_detalle);
            
        });
    }
    
    function modalListadoAcciones(codProyDetalle, nomTipoUsuario){
            var listaDetalleAcciones = bootbox.dialog({
                
            title: "<span><i class='ace-icon fa fa-tags'></i> ASIGNAR ACCIONES POR TIPO DE USUARIO</span>",
            headerClass: "modal-bg-primary",
            className: "tablaListadoAcciones",
            size: "large",
            message: `<div class="panel panel-primary">
                              <div class="panel-heading" style="padding: 8px 15px">
                                   <h6 class="panel-title" style="font-size: 15px; font-family: inherit"><i class="fa fa-list"></i>&nbsp; ${nomTipoUsuario}</h6>
                                   <div class="heading-elements">                                                                
                                       <button id="bttnAsignarAcciones"  type="button"  class="btn bg-slate-600 border-slate-800 btn-xs" onclick="asignarAcciones(${codProyDetalle})"><i class="glyphicon glyphicon-plus"></i>&nbsp; Asignar Acciones</button>
                                   </div>                        
                               </div>
                            <div class="table-responsive">
                                <table class="table table-responsive table-striped table-hover table-bordered" style ="width: 100%" id="tblDetalleAcciones">                                                 
                                    <thead class="">
                                        <tr>
                                            <th class="text-center">Nº</th>
                                            <th class="text-center">ACCIONES</th>
                                            <th class="text-center">ESTADO</th>
                                            <th class="text-center">ACCIONES</th>                                                                                                         
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>`,
            buttons: {
               si: {
                  label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cerrar",
                  className: "btn bg-danger border-danger-600 btn-xs",
                  callback: function () {
                  }
               }
            }
            });
            
            listaDetalleAcciones.init(function () {
                listarTablaAcciones(codProyDetalle);
            });
    }
    

    
   let flagBusqueda = false;
   $('#tblTipoUsuario').on('draw.dt', function () {
      $('[data-toggle="tooltip"]').tooltip();
   });

   function recargar() {
      $("#tblTipoUsuario").DataTable().destroy();
      datosTipoUsuario.listarTipoUsuario();
   }

   function refrescar() {
      $("#tblTipoUsuario").DataTable().ajax.reload(null, false)
   }

   var validar = 0;
   $('#btnBuscar').click(function () {
      validar = $('#formTipoUsuario').validate({
         rules: {
            txtBusqueda:
                    {required: true}
         },
         messages: {
            txtBusqueda:
                    {required: "<b>&times; Ingrese una Búsqueda</b>"}
         }
      });
      if (validar.form()) {
         recargar();
      }
   });

   $('#btnLimpiar').click(function () {
      $("#cboProyectos").val("0");
      $("#cboTipoUsuarios").val("0");
      if (validar !== 0) {
         validar.resetForm();
      }
      recargar();
   });

   function validCaracForm() {
      new Input({el: '#editarNombre', param: 'alphanumeric'}).validate();
   }

   function editarTipoUsuario() {
      $('#tblTipoUsuario tbody').on('click', '.editar', function () {
         var table = $("#tblTipoUsuario").DataTable();
         var data = table.row($(this).parents('tr')).data();
         var codigo = data["codigoTipoUsuario"];
         var campo = data["nombreTipoUsuario"];
         var numeral = data["numeral"];
         validarTipoUsuario(codigo)
                 .then((data) => {
                    if (data === 0) {
                       var editarTipoUsuario = bootbox.dialog({
                          title: "<span><i class='ace-icon fa fa-tags'></i> EDITAR TIPO DE USUARIO</span>",
                          headerClass: "modal-bg-primary",
                          size: "small",
                          message: `<form id="formEditarTipoUsuario" onsubmit="return false" autocomplete="off">
                                    <div class='col-md-12'>
                                        <div class="form-group">
                                            <label style="font-size: small">
                                                Nombre: 
                                            </label>
                                            <span id="spanAterik" class="text-danger"> (*)</span>
                                            <input type="text" id="editarNombre" name="txtBusqueda" class="form-control" value="${campo}" placeholder="INGRESE NOMBRE DEL TIPO DE USUARIO" style="text-transform:uppercase;">
                                            <br>
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>
                                        </div>
                                    </div> 
                                </form>`,
                          buttons: {
                             si: {
                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; Editar",
                                className: "btn bg-primary border-primary-600 btn-xs buttonOk",
                                callback: function () {
                                   var nombre = $('#editarNombre').val();
                                   var mayuscula = nombre.toUpperCase();
                                   var json = {
                                      "nombre": mayuscula,
                                      "codigo": codigo
                                   };
                                   var validar = $("#formEditarTipoUsuario").validate({
                                      rules: {
                                         txtBusqueda:
                                                 {required: true}
                                      },
                                      messages: {
                                         txtBusqueda:
                                                 {required: "<b>&times; Seleccione una Búsqueda</b>"}
                                      }
                                   });
                                   if (validar.form()) {
                                      validarNombreTipoUsuario(mayuscula, campo, 1)
                                              .then((data) => {
                                                 if (data === 0) {
                                                    bootbox.dialog({
                                                       className: "dialogExtraSmall",
                                                       headerClass: "modal-bg-primary",
                                                       title: "<i class='ace-icon fa fa-check-circle white'></i> <span class='white'>Conformidad</span>",
                                                       message: "¿Está seguro de editar este tipo de Usuario?",
                                                       buttons: {
                                                          si: {
                                                             label: "<i class='fa fa-check bigger-110'></i>&nbsp; Si",
                                                             className: "btn-primary",
                                                             callback: function () {
                                                                $.ajax({
                                                                   type: 'POST',
                                                                   url: "../servlet/TipoUsuarioServlet?accion=editarTipoUsuario",
                                                                   dataType: 'JSON',
                                                                   data: json,
                                                                   success: function (data) {
                                                                      if (data === 1) {
                                                                         bootbox.dialog({
                                                                            className: "dialogExtraSmall",
                                                                            title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                                                            headerClass: "modal-bg-success",
                                                                            message: "Tipo de Usuario correctamente modificado",
                                                                            buttons: {
                                                                               si: {
                                                                                  label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                                                                  className: "btn-success",
                                                                                  callback: function () {
                                                                                     refrescar();
                                                                                  }
                                                                               }
                                                                            }
                                                                         });
                                                                      } else {
                                                                         bootbox.dialog({
                                                                            title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                                            headerClass: "modal-bg-warning",
                                                                            message: "Ha ocurrido un error",
                                                                            buttons: {
                                                                               si: {
                                                                                  label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                                                                  className: "btn-warning",
                                                                                  callback: function () {
                                                                                     refrescar();
                                                                                  }
                                                                               }
                                                                            }
                                                                         });
                                                                      }
                                                                   }
                                                                });
                                                             }
                                                          }, no: {
                                                             label: "<i class='fa fa-times bigger-110'></i>&nbsp; No",
                                                             className: "btn-danger",
                                                             callback: function () {
                                                                $(`#tblTipoUsuario tbody .click${numeral}`).click();
                                                             }
                                                          }
                                                       }
                                                    });
                                                 } else {
                                                    bootbox.dialog({
                                                       className: "dialogExtraSmall",
                                                       title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                                       headerClass: "modal-bg-warning",
                                                       message: "¡El nombre ingresado está en uso!",
                                                       buttons: {
                                                          si: {
                                                             label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                                             className: "btn-warning",
                                                             callback: function () {
                                                                $(`#tblTipoUsuario tbody .click${numeral}`).click();
                                                             }
                                                          }
                                                       }
                                                    });
                                                 }
                                              });

                                   } else {
                                      return false;
                                   }

                                }

                             },
                             no: {
                                label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
                                className: "btn bg-danger border-danger-600 btn-xs",
                                callback: function () {
                                }
                             }
                          }
                       });
                       editarTipoUsuario.init(function () {
                          validCaracForm();
                          submitKey('formEditarTipoUsuario', '.buttonOk');
                       });
                    } else {
                       bootbox.dialog({
                          className: "dialogExtraSmall",
                          title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                          headerClass: "modal-bg-warning",
                          message: "El tipo de usuario seleccionado está en uso",
                          buttons: {
                             si: {
                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                className: "btn-warning",
                                callback: function () {
                                }
                             }
                          }
                       });
                    }
                 });
      });
   }

   $('#btnNuevoTipoUsuario').on('click', function () {
      var nuevoTipoUsuario = bootbox.dialog({
         title: "<span><i class='ace-icon fa fa-tags'></i> CREAR TIPO DE USUARIO</span>",
         headerClass: "modal-bg-primary",
         size: "small",
         message: `<form id="formCrearTipoUsuario" onsubmit="return false" autocomplete="off">
                                    <div class='col-md-12'>
                                        <div class="form-group">
                                            <label style="font-size: small">
                                                Nombre: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                            <input type="text" id="crearNombre" name="txtBusqueda" class="form-control" value="" placeholder="INGRESE NOMBRE DEL TIPO DE USUARIO" style="text-transform:uppercase;">
                                            <br>
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>
                                        </div>
                                    </div> 
                                </form>`,
         buttons: {
            confirm: {
               label: "<i class='fa fa-check bigger-110'></i>&nbsp; Crear",
               className: "btn-primary buttonOk",
               callback: function () {
                  var nombre = $('#crearNombre').val();
                  var mayuscula = nombre.toUpperCase();
                  var json = {
                     "nombre": mayuscula
                  };
                  var validar = $("#formCrearTipoUsuario").validate({
                     rules: {
                        txtBusqueda:
                                {required: true}
                     },
                     messages: {
                        txtBusqueda:
                                {required: "<b>&times; Seleccione una Búsqueda</b>"}
                     }
                  });
                  if (validar.form()) {
                     validarNombreTipoUsuario(mayuscula, '', 0)
                             .then((data) => {
                                if (data === 0) {
                                   $.ajax({
                                      type: 'POST',
                                      url: "../servlet/TipoUsuarioServlet?accion=crearTipoUsuario",
                                      dataType: 'JSON',
                                      data: json,
                                      success: function (data) {
                                         if (data === 1) {
                                            bootbox.dialog({
                                               className: "dialogExtraSmall",
                                               title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                               headerClass: "modal-bg-success",
                                               message: "Tipo de Usuario correctamente creado",
                                               buttons: {
                                                  si: {
                                                     label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                                     className: "btn-success",
                                                     callback: function () {
                                                        refrescar();
                                                     }
                                                  }
                                               }
                                            });
                                         } else {
                                            bootbox.dialog({
                                               title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                               headerClass: "modal-bg-warning",
                                               message: "Ha ocurrido un error",
                                               buttons: {
                                                  si: {
                                                     label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                                     className: "btn-warning",
                                                     callback: function () {
                                                        refrescar();
                                                     }
                                                  }
                                               }
                                            });
                                         }
                                      }
                                   });
                                   refrescar();
                                } else {
                                   bootbox.dialog({
                                      className: "dialogExtraSmall",
                                      title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                      headerClass: "modal-bg-warning",
                                      message: "El nombre ingresado está en uso",
                                      buttons: {
                                         si: {
                                            label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                            className: "btn-warning",
                                            callback: function () {
                                               $('#btnNuevoTipoUsuario').click();
                                            }
                                         }
                                      }
                                   });
                                }
                             });
                  } else {
                     return false;
                  }
               }
            },
            cancel: {
               label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
               className: "btn-danger",
               callback: function () {
               }
            }
         }
      });
      nuevoTipoUsuario.init(function () {
         new Input({el: '#crearNombre', param: 'alphanumeric'}).validate();
         submitKey('formCrearTipoUsuario', '.buttonOk');
      });
   });

   function activarTipoUsuario() {
      $('#tblTipoUsuario tbody').on('click', '.activar', function () {
         var table = $("#tblTipoUsuario").DataTable();
         var data = table.row($(this).parents('tr')).data();
         var codigo = data["codigoTipoUsuario"];
         var json = {
            "codigo": codigo
         };
         $.ajax({
            type: 'POST',
            url: "../servlet/TipoUsuarioServlet?accion=activarTipoUsuario",
            dataType: 'JSON',
            data: json,
            success: function (data) {
               if (data === 1) {
                  bootbox.dialog({
                     className: "dialogExtraSmall",
                     title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                     headerClass: "modal-bg-success",
                     message: "Estado correctamente modificado",
                     buttons: {
                        si: {
                           label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                           className: "btn-success",
                           callback: function () {
                              refrescar();
                           }
                        }
                     }
                  });
               } else {
                  bootbox.dialog({
                     title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                     headerClass: "modal-bg-warning",
                     message: "Ha ocurrido un error",
                     buttons: {
                        si: {
                           label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                           className: "btn-warning",
                           callback: function () {
                           }
                        }
                     }
                  });
               }
            }
         });
      });
   }

   function desactivarTipoUsuario() {
      $('#tblTipoUsuario tbody').on('click', '.desactivar', function () {
         var table = $("#tblTipoUsuario").DataTable();
         var data = table.row($(this).parents('tr')).data();
         var codigo = data["codigoTipoUsuario"];
         var json = {
            "codigo": codigo
         };
         validarTipoUsuario(codigo)
                 .then((data) => {
                    if (data === 0) {
                       $.ajax({
                          type: 'POST',
                          url: "../servlet/TipoUsuarioServlet?accion=desactivarTipoUsuario",
                          dataType: 'JSON',
                          data: json,
                          success: function (data) {
                             if (data === 1) {
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                   headerClass: "modal-bg-success",
                                   message: "Estado correctamente modificado",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                         className: "btn-success",
                                         callback: function () {
                                            refrescar();
                                         }
                                      }
                                   }
                                });
                             } else {
                                bootbox.dialog({
                                   className: "dialogExtraSmall",
                                   title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                   headerClass: "modal-bg-warning",
                                   message: "Ha ocurrido un error",
                                   buttons: {
                                      si: {
                                         label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                         className: "btn-warning",
                                         callback: function () {
                                            refrescar();
                                         }
                                      }
                                   }
                                });
                             }
                          }
                       });
                    } else {
                       bootbox.dialog({
                          className: "dialogExtraSmall",
                          title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                          headerClass: "modal-bg-warning",
                          message: "El tipo de usuario seleccionado está en uso",
                          buttons: {
                             si: {
                                label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                className: "btn-warning",
                                callback: function () {
                                }
                             }
                          }
                       });
                    }
                 });
      });
   }

   function validarTipoUsuario(codigo) {
      let json = {
         codigo: codigo
      };
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/TipoUsuarioServlet?accion=validarTipoUsuario",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
               resolve(data);
            }, error: function (jqXHR, textStatus, errorThrown) {
               reject("Error al validar tipo de usuario");
            }
         });
      });
   }

   function validarNombreTipoUsuario(nombreIngreso, nombreInicial, tipo) {
      let json = {
         nombreIngreso: nombreIngreso,
         nombreInicial: nombreInicial,
         tipo: tipo
      };
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/TipoUsuarioServlet?accion=validarNombreTipoUsuario",
            dataType: 'json',
            data: json,
            success: function (data, textStatus, jqXHR) {
               resolve(data);
            }, error: function (jqXHR, textStatus, errorThrown) {
               reject("Error al validar nombre tipo de usuario");
            }
         });
      });
   }
   
   function listarCboAcciones(){
      return new Promise((resolve, reject) => {
         $.ajax({
            type: 'POST',
            url: "../servlet/TipoUsuarioServlet?accion=listarCboAcciones",
            dataType: 'json',
            success: function (data, textStatus, jqXHR) {
               resolve(data);
            }, error: function (jqXHR, textStatus, errorThrown) {
               reject("Error al listar las asignaciones.");
            }
         });
      }).then(data => {
                    let print = '';
                    if (data.status) {
                        let print = "";
                        var lista = data.data;
                        lista.forEach(v => {
                            print += '<option value="' + v.codAccion +'">'+v.nombreAccion+'</option>';
                        });
                        $("#cboListadoAcciones").html(print);
                        $("#cboListadoAcciones").editableSelect();
                    } 
                });
   }
   
   
    function asignarAcciones(codDetalleProyecto){
        $(".tablaListadoAcciones").addClass("hide");
        var listadoAcciones = bootbox.dialog({
         title: "<span><i class='ace-icon fa fa-tags'></i> ASIGNAR ACCION - "+nombreTipoUsuario+"</span>",
         headerClass: "modal-bg-primary",
         size: "small",
         message: `<form id="formCrearTipoUsuario" onsubmit="return false" autocomplete="off">
                                    <div class='col-md-12'>
                                        <div class="form-group">
                                            <label style="font-size: small">
                                                Acciones: 
                                            </label>
                                            <span id="spanAterik" class="asterisk"> (*)</span>
                                                <select class="form-control" id="cboListadoAcciones" name="cboListAcciones">
                                                </select>
                                            <br>
                                            <div class="text-right" style="font-size: small"> 
                                                <span class="text-danger">(*) </span>  Campo obligatorio
                                            </div>
                                        </div>
                                    </div> 
                                </form>`,
         buttons: {
            confirm: {
               label: "<i class='fa fa-check bigger-110'></i>&nbsp; Asignar",
               className: "btn-primary buttonOk",
               callback: function () {
                  //var cboNomAccion = $('select[name="cboListAcciones"] option:selected').text();
                  var cboNomAccion = $('#cboListadoAcciones').val();

                  if(cboNomAccion !== ""){
                      crearAcciones(codDetalleProyecto,cboNomAccion);
                  }else{
                      alert("Tienes que asignar una accion valida.");
                      $(".tablaListadoAcciones").removeClass("hide");
                  }
               }
            },
            cancel: {
               label: "<i class='fa fa-times bigger-110'></i>&nbsp; Cancelar",
               className: "btn-danger",
               callback: function () {
                   $(".tablaListadoAcciones").removeClass("hide");
               }
            }
         }
      });
      
        listadoAcciones.init(function () {
            //cargar el combo de acciones
            listarCboAcciones();
        });
     }
     
     
     function crearAcciones(codProyDetalle, accion){
        return new Promise((resolve, reject) => {
           $.ajax({
              type: 'POST',
              url: "../servlet/TipoUsuarioServlet?accion=asignarAcciones",
              dataType: 'json',
              data:{
                  codigoProyDetalle: codProyDetalle,
                  nomAccion: accion
              },
              success: function (data, textStatus, jqXHR) {
                 resolve(data);
              }, error: function (jqXHR, textStatus, errorThrown) {
                 reject("Error al listar las asignaciones.");
              }
           });
        }).then(data => {
                      if (data.status) {
                            bootbox.dialog({
                                className: "dialogExtraSmall",
                                title: "<i class='ace-icon fa fa-tags white'></i> <span class='white'>Notificación</span>",
                                headerClass: "modal-bg-success",
                                message: data.message,
                                buttons: {
                                   si: {
                                      label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                      className: "btn-success",
                                      callback: function () {
                                        //modalListadoAcciones(codProyDetalle, nombreTipoUsuario);
                                        $(".tablaListadoAcciones").removeClass("hide");
                                        $("#tblDetalleAcciones").DataTable().ajax.reload();
                                      }
                                   }
                                }
                             });
                      }else{
                            bootbox.dialog({
                                title: "<i class='ace-icon fa fa-exclamation-circle white'></i> <span class='white'>Advertencia</span>",
                                headerClass: "modal-bg-warning",
                                message: "Ha ocurrido un error",
                                buttons: {
                                   si: {
                                      label: "<i class='fa fa-check bigger-110'></i>&nbsp; OK",
                                      className: "btn-warning",
                                      callback: function () {
                                         $(".tablaListadoAcciones").removeClass("hide");
                                         $("#tblDetalleAcciones").DataTable().ajax.reload();
                                      }
                                   }
                                }
                             });
                      } 
                  });
     }
