/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.utilities;
import java.io.File;
import java.util.Locale;

/**
 *
 * @author Aaron
 */
public class OsUtils {
    // cached result of OS detection
    protected static String detectedOS;
    public static String getOperatingSysstemType() {
        if (detectedOS == null) {
            String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            if ((OS.contains("mac")) || (OS.contains("darwin"))) {
                detectedOS = "MacOS";
            } else if (OS.contains("win")) {
                detectedOS = "Windows";
            } else if (OS.contains("nux")) {
                detectedOS = "Linux";
            } else {
                detectedOS = "Other";
            }
        }
        return detectedOS;
    }
    public static String getDotEnvPath(String projectName) {
        String path = "";
        String detectedOs = OsUtils.getOperatingSysstemType();
        switch (detectedOs) {
            case "MacOS":
                path = "";
                break;
            case "Windows":
                char[] alphabet = "abcdefghijklmnopqrstuvwxyz".toCharArray();
                for (char letter : alphabet) {
                    path = letter + ":/dotenv/" + projectName;
                    File directory = new File(path);
                    if (directory.exists()) {
                        break;
                    }
                }
                break;
            case "Linux":
                path = "/opt/dotenv/"+ projectName;
                break;
        }
        return path;
    }
}
