/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.sqlserverdao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import moduloSeguridad.dao.UsuarioDAO;
import moduloSeguridad.utilities.GeneralVariables;
import moduloSeguridad.utilities.ResponseHelper;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class UsuarioSqlServerDAO implements UsuarioDAO {

	@Override
	public JSONArray listarUsuario(JSONObject datos, int vstart, int vlength, int draw) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		JSONArray lista = new JSONArray();
		String busqueda01;
                
		try {
			switch (datos.getString("tipo")) {
				case "1":
					busqueda01 = " and a.usu like '%" + datos.getString("filtro") + "%' ";
					break;
				case "2":
					busqueda01 = " and pd.cod_proyecto = " + datos.getString("filtro") + " ";
					break;
				case "3":
					busqueda01 = " and ud.cod_proyecto_detalle = " + datos.getString("filtro") + " ";
					break;
				default:
					busqueda01 = "";
					break;
			}
			if (!datos.getBoolean("estado")) {
				busqueda01 += " and a.est  = 1 ";
			} else {
				busqueda01 += " and a.est  = 0 ";
			}
			query = " WITH tablaOrdenada AS (SELECT a.cod_usuario, a.cod_trabajador, a.usu, a.est, ROW_NUMBER() OVER (ORDER BY a.cod_usuario) AS cantidad FROM usuario AS a "
				+ " LEFT JOIN usuario_detalle AS ud ON ud.cod_usuario = a.cod_usuario "
				+ " LEFT JOIN proyecto_detalle AS pd ON pd.cod_proyecto_detalle = ud.cod_proyecto_detalle "
				+ " WHERE  1= 1 "
				+ " " + busqueda01 + " "
				+ " GROUP BY a.cod_usuario, a.cod_trabajador, a.usu, a.est) "
                                + " select cod_usuario, cod_trabajador, usu, est, cantidad from tablaOrdenada "
				+ " where cantidad BETWEEN "+vstart+" and "+vlength*draw
                                + " ORDER BY usu ASC";
			con = SqlServerDAOFactory.getConnectionSQL(base);
                        
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			int conta = vstart + 1;
			while (rs.next()) {
				JSONObject obj = new JSONObject();
				obj.put("numeral", conta);
				obj.put("codigoUsuario", rs.getInt(1));
				obj.put("codigoTrabajador", rs.getString(2));
				obj.put("usuario", rs.getString(3));
				obj.put("estadoUsuario", rs.getInt(4));
				lista.put(obj);
				conta++;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return lista;
	}

	@Override
	public int cantidadRegistros(JSONObject datos) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		int cant = 0;
		String query = "";
		String busqueda = "";
		try {
			switch (datos.getString("tipo")) {
				case "1":
					busqueda = " and a.usu like '%" + datos.getString("filtro") + "%' ";
					break;
				case "2":
					busqueda = " and pd.cod_proyecto = " + datos.getString("filtro") + " ";
					break;
				case "3":
					busqueda = " and ud.cod_proyecto_detalle = " + datos.getString("filtro") + " ";
					break;
				default:
					busqueda = "";
					break;
			}
			if (!datos.getBoolean("estado")) {
				busqueda += " and a.est  = 1 ";
			} else {
				busqueda += " and a.est  = 0 ";
			}
			query = " SELECT COUNT(*) as cant  FROM usuario AS a "
				+ " LEFT JOIN usuario_detalle AS ud ON ud.cod_usuario = a.cod_usuario "
				+ " LEFT JOIN proyecto_detalle AS pd ON pd.cod_proyecto_detalle = ud.cod_proyecto_detalle "
				+ " WHERE 1 = 1  " + busqueda + " "
				+ " GROUP BY a.cod_usuario ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
				cant++;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public int editarUsuario(int codigo, String usuario, String clave) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update usuario "
				+ " set usu = upper('" + usuario + "'),"
				+ " con = '" + clave + "'"
				+ " where cod_usuario = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int activarUsuario(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update usuario "
				+ " set est = 1 "
				+ " where cod_usuario = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int desactivarUsuario(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update usuario "
				+ " set est = 0 "
				+ " where cod_usuario = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
			if (rs == 1) {
				query = " update usuario_detalle "
					+ " set  est = 0 "
					+ " where cod_usuario = " + codigo;
			}
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return 1;
	}

	@Override
	public int crearUsuario(String codigoTrabajador, String usuario, String clave) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " insert into usuario (cod_trabajador, usu, con, est) "
				+ " values ('" + codigoTrabajador + "', upper('" + usuario + "'), '" + clave + "', 1) ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int validarUsuario(String codigoTrabajador) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		int cant = 0;
		String query = "";
		try {
			query = " select count(*) as cant "
				+ " from usuario "
				+ " where cod_trabajador = '" + codigoTrabajador + "'";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public int eliminarUsuario(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " delete from usuario "
				+ " where cod_usuario = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public JSONObject listarUsuarioDetalle(String filtro, int vstart, int vlength, String draw) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		JSONObject obj = new JSONObject();
		JSONArray lista = new JSONArray();
		ResultSet rs = null;
		String query = "";
		int conta = vstart;
		try {
			query = " select ud.cod_usuario_detalle, ud.est, p.nom, tu.nom from usuario_detalle as ud "
				+ " inner join proyecto_detalle as pd "
				+ " on ud.cod_proyecto_detalle = pd.cod_proyecto_detalle "
				+ " inner join proyecto as p "
				+ " on p.cod_proyecto = pd.cod_proyecto "
				+ " inner join tipo_usuario as tu "
				+ " on tu.cod_tipo_usuario = pd.cod_tipo_usuario "
				+ " where ud.cod_usuario = " + filtro + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
				conta++;
				JSONObject x = new JSONObject();
				x.put("numeral", conta);
				x.put("codigoUsuarioDetalle", rs.getInt(1));
				x.put("estadoUsuarioDetalle", rs.getInt(2));
				x.put("nombreProyecto", rs.getString(3));
				x.put("nombreTipoUsuario", rs.getString(4));
				lista.put(x);
			}
			int cantRegistro = 0;
			String query2 = " select count(*) as cant "
				+ " from usuario_detalle "
				+ " where cod_usuario = " + filtro;
			PreparedStatement pst2 = null;
			ResultSet rs2 = null;
			pst2 = con.prepareStatement(query2);
			rs2 = pst2.executeQuery();
			rs2.next();
			cantRegistro = rs2.getInt("cant");

			obj.put("data", lista);
			obj.put("recordsTotal", cantRegistro);
			obj.put("recordsFiltered", cantRegistro);
			obj.put("draw", draw);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return obj;
	}

	@Override
	public int eliminarUsuarioDetalle(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " delete from usuario_detalle "
				+ " where cod_usuario_detalle = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int activarUsuarioDetalle(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update usuario_detalle "
				+ " set est = 1 "
				+ " where cod_usuario_detalle = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int desactivarUsuarioDetalle(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update usuario_detalle "
				+ " set est = 0 "
				+ " where cod_usuario_detalle = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int asignarProyectoUsuario(int usuario, int proyectoDetalle) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " insert into usuario_detalle "
				+ " (cod_usuario, cod_proyecto_detalle, est) "
				+ " values(" + usuario + ", " + proyectoDetalle + ", 1) ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public JSONArray listarProyecto() throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		JSONArray lista = new JSONArray();
		try {
			query = "select pd.cod_proyecto, p.nom from proyecto_detalle as pd "
				+ "inner join proyecto as p "
				+ "on p.cod_proyecto = pd.cod_proyecto "
				+ "group by pd.cod_proyecto, p.nom ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
				JSONObject obj = new JSONObject();
				obj.put("codigoProyecto", rs.getInt(1));
				obj.put("nombreProyecto", rs.getString(2));
				lista.put(obj);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return lista;
	}

	@Override
	public JSONArray listarTipoDeUsuario(int proyecto, int usuario) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		JSONArray lista = new JSONArray();
		String valid;
		if (usuario != -1) {
			valid = " AND pd.cod_proyecto_detalle NOT IN ( "
				+ " SELECT "
				+ " ud.cod_proyecto_detalle "
				+ " FROM "
				+ " usuario_detalle AS ud "
				+ " WHERE ud.cod_usuario = " + usuario + ""
				+ " AND ud.est = 1  "
				+ " ) ";
		} else {
			valid = "";
		}
		try {
			query = "SELECT "
				+ "	pd.cod_proyecto_detalle, "
				+ "	tu.nom "
				+ "FROM "
				+ "	proyecto_detalle AS pd "
				+ "INNER JOIN tipo_usuario AS tu ON pd.cod_tipo_usuario = tu.cod_tipo_usuario "
				+ "WHERE "
				+ "	cod_proyecto = " + proyecto + " "
				+ valid;
			System.out.println("LISTADO TIPO USUARIO ---> " + query);
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
				JSONObject obj = new JSONObject();
				obj.put("codigoDetalle", rs.getInt(1));
				obj.put("nombreTipoUsuario", rs.getString(2));
				lista.put(obj);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return lista;
	}

	@Override
	public int validarUsuarioDependencia(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		int cant = 0;
		String query = "";
		try {
			query = " select count(*) as cant from usuario_detalle "
				+ " where cod_usuario = " + codigo + " ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public int validarNombreUsuario(String nombre) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		int cant = 0;
		String query = "";
		try {
			query = " select count(*) as cant from usuario "
				+ " where upper(usu) = upper('" + nombre + "')";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public int validarAsignacion(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		int cant = 0;
		String query = "";
		try {
			query = " select count(*) as cant from auditoria "
				+ " where cod_usuario_detalle = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(GeneralVariables.nameDB);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public JSONObject listarUsuarioManual(JSONObject datos) throws Exception {
		JSONObject jreturn;
		JSONArray lista = new JSONArray();
		JSONObject data = new JSONObject();
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rSet = null;
		int rs = 0;
		String sql = "";
		String condicion = "";
		ResponseHelper response = new ResponseHelper();
		try {
			if (datos.has("estado")) {
				if (datos.getBoolean("estado")) {
					condicion = " where a.est = 0";
				} else {
					condicion = " where a.est = 1";
				}
			}
			con = SqlServerDAOFactory.getConnectionSQL(GeneralVariables.nameDB);
			sql = " SELECT a.cod_usuario, a.cod_trabajador, a.usu, a.est FROM usuario as a" + condicion;
			pst = con.prepareStatement(sql);
			rSet = pst.executeQuery();
			int conta = 1;
			while (rSet.next()) {
				JSONObject obj = new JSONObject();
				obj.put("numeral", conta++);
				obj.put("codigoUsuario", rSet.getInt(1));
				obj.put("codigoTrabajador", rSet.getString(2));
				obj.put("usuario", rSet.getString(3));
				obj.put("estadoUsuario", rSet.getInt(4));
				lista.put(obj);
			}
			response.setResults(lista);
			response.setStatus(true);
		} catch (Exception e) {
			e.printStackTrace();
			response.setStatus(false);
			response.setMessage("Error --->" + e.getMessage());
		} finally {
			try {
				if (rSet != null) {
					rSet.close();
				}
				if (pst != null) {
					pst.close();
				}
				if (con != null) {
					con.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
				response.setStatus(false);
				response.setMessage("Error --->" + e.getMessage());
			}
		}
		return new JSONObject(response);
	}
}
