/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.sqlserverdao;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import moduloSeguridad.utilities.GeneralMethods;
//import static moduloSeguridad.utilities.GeneralMethods.getMaxSize;
import moduloSeguridad.dao.TipoUsuarioDAO;
import moduloSeguridad.utilities.DAOHelper;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class TipoUsuarioSqlServerDAO implements TipoUsuarioDAO {
    
	@Override
	public JSONObject listarProyectos() throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		String busqueda = "";
		JSONObject jsonReturn = new JSONObject();
		JSONArray lista = new JSONArray();
		try {
                        query = "select cod_proyecto, nom from proyecto where proyecto.est = 1;";
                        
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
                            JSONObject obj = new JSONObject();
                            obj.put("codigoProyecto", rs.getString(1));
                            obj.put("nombreProyecto", rs.getString(2));
                            lista.put(obj);
			}

			jsonReturn.put("data", lista);
                        jsonReturn.put("status", true);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return jsonReturn;
	}
        
        @Override
	public JSONObject listarTiposUsuarios(int codigoProyecto) throws Exception {
                
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		String busqueda = "";
		JSONObject jsonReturn = new JSONObject();
		JSONArray lista = new JSONArray();
                
		try {
                        query = "select proyecto_detalle.cod_tipo_usuario, tipo_usuario.nom\n" +
                        "from proyecto_detalle \n" +
                        "inner join tipo_usuario on proyecto_detalle.cod_tipo_usuario = tipo_usuario.cod_tipo_usuario\n" +
                        "where proyecto_detalle.cod_proyecto = " + codigoProyecto;
                        
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
                            JSONObject obj = new JSONObject();
                            obj.put("codTipoUsuario", rs.getString(1));
                            obj.put("nomTipoUsuario", rs.getString(2));
                            lista.put(obj);
			}

			jsonReturn.put("data", lista);
                        jsonReturn.put("status", true);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return jsonReturn;
	}

	@Override
	public JSONObject listadoPrincipal(String filtro, int filtrado, int proyecto, int vstart, int vlength, String draw) throws Exception {
		String base = "security";
		Connection cnx = null;
		String query = "";
                JSONArray arrayjson = new JSONArray();
                JSONObject response = new JSONObject();
                int total = 0;
                
		try {
                    
                    cnx = SqlServerDAOFactory.getConnectionSQL(base);
                    String sql = "{CALL SP_TA_GESTIÓN_USUARIO(?,?,?,?,?,?,?,?,?,?)}";

                    JSONArray params = new JSONArray()
                            .put(1)
                            .put(proyecto)
                            .put(filtro)
                            .put(0)
                            .put(0)
                            .put(0)
                            .put(vstart)
                            .put(vlength)
                            .put(String.class)
                            .put(Integer.class);

                    arrayjson = DAOHelper.queryProcedure(cnx, sql, params);
                    total = params.getInt(1);
                    
                    response.put("data", arrayjson);
                    response.put("draw", draw);
                    response.put("recordsTotal", total);
                    response.put("recordsFiltered", total);
                    response.put("status", true);
                    response.put("message", "Se ha ejecutado el litado principal correctamente.");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return response;
	}
        
	@Override
	public JSONObject asignarAcciones(JSONObject datos) throws Exception {
		String base = "security";
		Connection cnx = null;
		String query = "";
                JSONArray arrayjson = new JSONArray();
                JSONObject response = new JSONObject();
                String mensaje = "";
		try {
                    
                    cnx = SqlServerDAOFactory.getConnectionSQL(base);
                    String sql = "{CALL SP_TA_GESTIÓN_USUARIO(?,?,?,?,?,?,?,?,?,?)}";

                    JSONArray params = new JSONArray()
                            .put(3)
                            .put(0)
                            .put(0)
                            .put(datos.getInt("codProyectoDetalle"))
                            .put(datos.getString("nomAccion"))
                            .put(0)
                            .put(0)
                            .put(0)
                            .put(String.class)
                            .put(Integer.class);

                    arrayjson = DAOHelper.queryProcedure(cnx, sql, params);

                    mensaje = params.getString(0);
                    
                    response.put("status", true);
                    response.put("message", mensaje);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return response;
	}
        
        @Override
	public JSONObject listarAcciones(JSONObject datos) throws Exception {
                
		String base = "security";
		Connection cnx = null;
		String query = "";
                JSONArray arrayjson = new JSONArray();
                JSONObject response = new JSONObject();
                int total = 0;
                
		try {
                    
                    cnx = SqlServerDAOFactory.getConnectionSQL(base);
                    String sql = "{CALL SP_TA_GESTIÓN_USUARIO(?,?,?,?,?,?,?,?,?,?)}";

                    JSONArray params = new JSONArray()
                            .put(2)
                            .put(0)
                            .put(0)
                            .put(datos.getInt("proyectoDetalle"))
                            .put(0)
                            .put(0)
                            .put(datos.getInt("start"))
                            .put(datos.getInt("length"))
                            .put(String.class)
                            .put(Integer.class);
                            

                    arrayjson = DAOHelper.queryProcedure(cnx, sql, params);
                    total = params.getInt(1);

                    response.put("data", arrayjson);
                    response.put("draw", datos.getInt("draw"));
                    response.put("recordsTotal", total);
                    response.put("recordsFiltered", total);
                    response.put("status", true);
                    response.put("message", "Se ha ejecutado el litado de acciones correctamente.");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return response;
	}
        
        @Override
	public JSONObject activarDesactivarAccion(JSONObject datos) throws Exception {
                
		String base = "security";
		Connection cnx = null;
		String query = "";
                JSONArray arrayjson = new JSONArray();
                JSONObject response = new JSONObject();
                
		try {
                    
                    cnx = SqlServerDAOFactory.getConnectionSQL(base);
                    String sql = "{CALL SP_TA_GESTIÓN_USUARIO(?,?,?,?,?,?,?,?,?,?)}";

                    JSONArray params = new JSONArray()
                            .put(4)
                            .put(0)
                            .put(0)
                            .put(0)
                            .put(0)
                            .put(datos.getInt("codigoAccionDetalle"))
                            .put(0)
                            .put(0)
                            .put(String.class)
                            .put(Integer.class);

                    arrayjson = DAOHelper.queryProcedure(cnx, sql, params);

                    response.put("status", true);
                    response.put("message", "Se ha cambiado el estado correctamente.");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return response;
	}
        
        @Override
	public JSONObject activarDesactivarTipoUsuario(JSONObject datos) throws Exception {
                
		String base = "security";
		Connection cnx = null;
		String query = "";
                JSONArray arrayjson = new JSONArray();
                JSONObject response = new JSONObject();
                
		try {
                    
                    cnx = SqlServerDAOFactory.getConnectionSQL(base);
                    String sql = "{CALL SP_TA_GESTIÓN_USUARIO(?,?,?,?,?,?,?,?,?,?)}";

                    JSONArray params = new JSONArray()
                            .put(5)
                            .put(0)
                            .put(0)
                            .put(datos.getInt("codigoProyectoDetalle"))
                            .put(0)
                            .put(0)
                            .put(0)
                            .put(0)
                            .put(String.class)
                            .put(Integer.class);

                    arrayjson = DAOHelper.queryProcedure(cnx, sql, params);

                    response.put("status", true);
                    response.put("message", "Se ha cambiado el estado correctamente.");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return response;
	}
        
      @Override
	public JSONObject listarCboAcciones() throws Exception {
                
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		String busqueda = "";
		JSONObject jsonReturn = new JSONObject();
		JSONArray lista = new JSONArray();
		try {
                        query = "select *from accion;";
                        
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
                            JSONObject obj = new JSONObject();
                            obj.put("codAccion", rs.getString(1));
                            obj.put("nombreAccion", rs.getString(2));
                            lista.put(obj);
			}

			jsonReturn.put("data", lista);
                        jsonReturn.put("status", true);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return jsonReturn;
	}

	@Override
	public int activarTipoUsuario(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update tipo_usuario "
				+ " set est = 1"
				+ " where cod_tipo_usuario = " + codigo + " ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int desactivarTipoUsuario(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update tipo_usuario "
				+ " set est = 0"
				+ " where cod_tipo_usuario = " + codigo + " ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int editarTipoUsuario(int codigo, String nombre) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update tipo_usuario "
				+ " set nom = '" + nombre + "'"
				+ " where cod_tipo_usuario = " + codigo + " ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int crearTipoUsuario(String nombre) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
//	    DatabaseMetaData metadata = con.getMetaData();
//	    ResultSet rst = metadata.getColumns(null, null, "titulo", "nom");
			query = " insert into tipo_usuario (nom, est)"
				+ " values ('" + nombre + "', 1) ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int validarTipoUsuario(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		int cant = 0;
		String query = "";
		try {
			query = " select count(*) as cant from tipo_usuario as tu "
				+ " inner join proyecto_detalle as pd "
				+ " on pd.cod_tipo_usuario = tu.cod_tipo_usuario "
				+ " inner join proyecto as p "
				+ " on p.cod_proyecto = pd.cod_proyecto "
				+ " where tu.cod_tipo_usuario = " + codigo + " "
				+ " and p.est = 1 ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public int validarNombreTipoUsuario(String nombreInicial, String nombreIngreso, int tipo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		int cant = 0;
		String query = "";
		try {
			query = " select COUNT(*) as cant from tipo_usuario "
				+ " where UPPER(nom) = UPPER('" + nombreIngreso + "') "
				+ " and est = 1 ";
			if (tipo == 1) {
				query += " and nom != '" + nombreInicial + "' ";
			}
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
			cant = 2;
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}
}
