/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.sqlserverdao;

import java.sql.Connection;
import java.sql.DriverManager;
import moduloSeguridad.dao.DAOFactory;
import moduloSeguridad.dao.ProyectoDAO;
import moduloSeguridad.dao.MenuDAO;
import moduloSeguridad.dao.TipoUsuarioDAO;
import moduloSeguridad.dao.UsuarioDAO;
import moduloSeguridad.utilities.dotenSrv;

/**
 *
 * @author Felipe
 *
 */
public class SqlServerDAOFactory extends DAOFactory {

	public static Connection getConnectionSQL(String base) {
		Connection conexion = null;
                String host = "";
                String port = "";
                String databaseName = "";
                String userSgbd = "";
                String passwordSgbd = "";
		if (base.equalsIgnoreCase("security")) {
			/*String user = "###########";
			String pwd = "########";
			String url = "jdbc:sqlserver://172.16.0.6:1433;databaseName=security";*/
//			String url = "jdbc:sqlserver://172.16.2.40:1433;databaseName=Security";                       
                        host = dotenSrv.obtenerValorVariableEntorno("SQLSERVER_SECURITY_DB_HOST");
                        port = dotenSrv.obtenerValorVariableEntorno("SQLSERVER_SECURITY_DB_PORT");
                        databaseName = dotenSrv.obtenerValorVariableEntorno("SQLSERVER_SECURITY_DB_NAME");
                        userSgbd = dotenSrv.obtenerValorVariableEntorno("SQLSERVER_SECURITY_DB_USER");
                        passwordSgbd = dotenSrv.obtenerValorVariableEntorno("SQLSERVER_SECURITY_DB_PASS");
                        String url = "jdbc:sqlserver://"+host+":"+port+";databaseName="+databaseName;
			try {
				Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
				conexion = DriverManager.getConnection(url, userSgbd, passwordSgbd);
			} catch (Exception e) {
				e.printStackTrace();
				System.out.println("Error al conectarse a la bd");
			}
		}
		return conexion;
	}

	@Override
	public TipoUsuarioDAO getTipoUsuario() {
		return new TipoUsuarioSqlServerDAO();
	}

	@Override
	public ProyectoDAO getProyectoDAO() {
		return new ProyectoSqlServerDAO();
	}

	@Override
	public UsuarioDAO getUsuarioDAO() {
		return new UsuarioSqlServerDAO();
	}

	@Override
	public MenuDAO getMenuDAO() {
		return new MenuSqlServerDAO();
	}
}
