/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.sqlserverdao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import moduloSeguridad.utilities.ResponseHelper;
import moduloSeguridad.dao.ProyectoDAO;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class ProyectoSqlServerDAO implements ProyectoDAO {

	@Override
	public JSONObject listarProyecto(JSONObject datos, int vstart, int vlength, String draw) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		String busqueda = "";
		JSONObject jsonReturn = new JSONObject();
		JSONArray lista = new JSONArray();
		int conta = vstart;
		try {
			String filtro = datos.getString("filtro");
			if (filtro.equals("")) {
				busqueda = "";
			} else {
				busqueda = " and nom like '%" + filtro + "%'";
			}
			if (datos.getBoolean("status")) {
				busqueda += "and est = 0";
			} else {
				busqueda += "and est = 1";
			}
			query = " select TOP " + vlength + " cod_proyecto, nom, est, url from proyecto "
				+ " where cod_proyecto NOT IN "
				+ " ( "
				+ " SELECT top " + vstart + " "
				+ " cod_proyecto from proyecto ORDER BY cod_proyecto) "
				+ " " + busqueda + " ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
				conta++;
				JSONObject obj = new JSONObject();
				obj.put("numeral", conta);
				obj.put("codigoProyecto", rs.getString(1));
				obj.put("nombreProyecto", rs.getString(2));
				obj.put("estadoProyecto", rs.getInt(3));
				obj.put("urlProyecto", rs.getString(4));
				lista.put(obj);
			}
			int cantRegistro = 0;
			String query2 = " select count(*) as cant "
				+ " from proyecto "
				+ " where 1 = 1 "
				+ " " + busqueda + " ";
			PreparedStatement pst2 = null;
			ResultSet rs2 = null;
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query2);
			rs = pst.executeQuery();
			rs.next();
			cantRegistro = rs.getInt("cant");

			jsonReturn.put("data", lista);
			jsonReturn.put("recordsTotal", cantRegistro);
			jsonReturn.put("recordsFiltered", cantRegistro);
			jsonReturn.put("draw", draw);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return jsonReturn;
	}

	@Override
	public int editarProyecto(int codigo, String nombre, String url) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update proyecto "
				+ " set nom = '" + nombre + "', "
				+ " url = '" + url + "' "
				+ " where cod_proyecto = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int activarProyecto(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update proyecto "
				+ " set est = 1 "
				+ " where cod_proyecto = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int desactivarProyecto(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update proyecto "
				+ " set est = 0 "
				+ " where cod_proyecto = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public JSONObject asignarDetalle(int proyecto, int tipoUsuario) throws Exception {
		JSONObject jsonReturn;
		ResponseHelper response = new ResponseHelper();
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		ResultSet rsLlave = null;
		String query = "";
		try {
			con = SqlServerDAOFactory.getConnectionSQL(base);
			con.setAutoCommit(false);
			query = " insert into proyecto_detalle (cod_proyecto, cod_tipo_usuario, est) "
				+ " values (" + proyecto + ", " + tipoUsuario + ", 1) ";
			pst = con.prepareStatement(query, Statement.RETURN_GENERATED_KEYS);
			rs = pst.executeUpdate();
			if (rs >= 1) {
				rsLlave = pst.getGeneratedKeys();
				rsLlave.next();
				int codigo = rsLlave.getInt(1);
				JSONObject json = new JSONObject();
				json.put("codigo", codigo);
				con.commit();
				response.setStatus(true);
				response.setMessage("Se registro correctamente.");
				response.setData(json);
			} else {
				con.rollback();
				response.setMessage("error al registrar");
				response.setStatus(false);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		jsonReturn = new JSONObject(response);
		return jsonReturn;
	}

	@Override
	public JSONObject listarDetalle(String filtro, int vstart, int vlength, String draw) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		String busqueda = "";
		JSONObject jsonReturn = new JSONObject();
		JSONArray lista = new JSONArray();
		int conta = vstart;
		try {
			query = " select TOP " + vlength + " tu.nom, pd.est, pd.cod_proyecto_detalle from proyecto_detalle as pd "
				+ " inner join tipo_usuario as tu "
				+ " on tu.cod_tipo_usuario = pd.cod_tipo_usuario "
				+ " where cod_proyecto_detalle NOT IN "
				+ " ( "
				+ " SELECT top " + vstart + " "
				+ " cod_proyecto_detalle from proyecto_detalle ORDER BY cod_proyecto_detalle) "
				+ " and cod_proyecto = " + filtro + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
				conta++;
				JSONObject obj = new JSONObject();
				obj.put("numeral", conta);
				obj.put("nombreDetalle", rs.getString(1));
				obj.put("estadoDetalle", rs.getInt(2));
				obj.put("codigoDetalle", rs.getInt(3));
				lista.put(obj);
			}
			int cantRegistro = 0;
			String query2 = " select count(*) as cant "
				+ " from proyecto_detalle "
				+ " where cod_proyecto = " + filtro + " ";
			PreparedStatement pst2 = null;
			ResultSet rs2 = null;
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query2);
			rs = pst.executeQuery();
			rs.next();
			cantRegistro = rs.getInt("cant");

			jsonReturn.put("data", lista);
			jsonReturn.put("recordsTotal", cantRegistro);
			jsonReturn.put("recordsFiltered", cantRegistro);
			jsonReturn.put("draw", draw);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return jsonReturn;
	}

	@Override
	public int crearProyecto(String nombre, String url) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " insert into proyecto (nom, url, est)"
				+ " values ('" + nombre + "', '" + url + "', 1) ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int activarDetalle(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update proyecto_detalle "
				+ " set est = 1 "
				+ " where cod_proyecto_detalle = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int desactivarDetalle(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " update proyecto_detalle "
				+ " set est = 0 "
				+ " where cod_proyecto_detalle = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public JSONArray listarTipoUsuario(int proyecto) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		JSONArray array = new JSONArray();
		try {
			query = " select cod_tipo_usuario, nom   from tipo_usuario as tu where tu.cod_tipo_usuario "
				+ " not in (select pd.cod_tipo_usuario from proyecto_detalle as pd "
				+ " where pd.cod_proyecto = " + proyecto + ") "
				+ " and est = 1 ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
				JSONObject obj = new JSONObject();
				obj.put("codigoTipoUsuario", rs.getInt(1));
				obj.put("nombreTipoUsuario", rs.getString(2));
				array.put(obj);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return array;
	}

	@Override
	public int eliminarDetalle(int codigoDetalle) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		String query = "";
		try {
			query = " delete from proyecto_detalle "
				+ " where cod_proyecto_detalle = " + codigoDetalle + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public JSONArray validarProyecto(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		JSONArray lista = new JSONArray();
		String query = "";
		int cant = 0;
		try {
			query = " select ud.cod_usuario_detalle from proyecto as p\n"
				+ "inner join proyecto_detalle as pd \n"
				+ "on pd.cod_proyecto = p.cod_proyecto\n"
				+ "inner join usuario_detalle as ud \n"
				+ "on ud.cod_proyecto_detalle = pd.cod_proyecto_detalle\n"
				+ "where p.cod_proyecto = " + codigo + "\n"
				+ "and ud.est = 1 ";
			System.out.println("QUERY " + query);
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			while (rs.next()) {
				lista.put(rs.getInt(1));
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return lista;
	}

	@Override
	public int validarNombreProyecto(String nombreNuevo, String nombreActual, int tipo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		int cant = 0;
		try {
			query = " select count(*) as cant "
				+ " from proyecto "
				+ " where UPPER(nom) = UPPER('" + nombreNuevo + "')"
				+ " and est = 1 ";
			if (tipo == 1) {
				query += " and nom != '" + nombreActual + "' ";
			}
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public int validarUrlProyecto(String urlNuevo, String urlActual, int tipo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		String query = "";
		int cant = 0;
		try {
			query = " select count(*) as cant "
				+ " from proyecto "
				+ " where UPPER(url) = UPPER('" + urlNuevo + "')"
				+ " and est = 1 ";
			if (tipo == 1) {
				query += " and url != '" + urlActual + "' ";
			}
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public int validarDetalle(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rs = null;
		int cant = 0;
		String query = "";
		try {
			query = " select count(*) as cant from usuario_detalle "
				+ " where cod_proyecto_detalle = " + codigo + " "
				+ " and est = 1 ";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rs = pst.executeQuery();
			rs.next();
			cant = rs.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return cant;
	}

	@Override
	public int validarMenuDetalle(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		ResultSet rsQuery = null;
		String query = "";
		try {
			query = " select count(*) as cant from titulo_configuracion "
				+ " where cod_proyecto_detalle = " + codigo + "";
			con = SqlServerDAOFactory.getConnectionSQL(base);
			pst = con.prepareStatement(query);
			rsQuery = pst.executeQuery();
			rsQuery.next();
			rs = rsQuery.getInt("cant");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int eliminarMenuDetalle(int codigo) throws Exception {
		String base = "security";
		Connection con = null;
		PreparedStatement pst = null;
		int rs = 0;
		ResultSet rsQuery = null;
		String query = "";
		try {
			con = SqlServerDAOFactory.getConnectionSQL(base);
			query = " delete from titulo_configuracion "
				+ " where cod_proyecto_detalle = " + codigo + "";
			pst = con.prepareStatement(query);
			rs = pst.executeUpdate();
			query = " delete from modulo_configuracion "
				+ " where cod_proyecto_detalle = " + codigo + "";
			pst = con.prepareStatement(query);
			rs += pst.executeUpdate();
			query = " delete from categoria_configuracion "
				+ " where cod_proyecto_detalle = " + codigo + "";
			pst = con.prepareStatement(query);
			rs += pst.executeUpdate();
			query = " delete from subcategoria_configuracion "
				+ " where cod_proyecto_detalle = " + codigo + "";
			pst = con.prepareStatement(query);
			rs += pst.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			con.close();
			pst.close();
		}
		return rs;
	}

	@Override
	public int desactivarUsuarioDetalle(int codigo) throws Exception {
		int resultado = 0;
		Connection con = null;
		PreparedStatement pst = null;
		ResultSet rSet = null;
		int rs = 0;
		String sql = "";
		ResponseHelper response = new ResponseHelper();
		try {
			con = SqlServerDAOFactory.getConnectionSQL("security");
//			con.setAutoCommit(false);
			sql = " update usuario_detalle\n"
				+ "set est = 0\n"
				+ "where cod_usuario_detalle in (\n"
				+ "select ud.cod_usuario_detalle from proyecto as p\n"
				+ "inner join proyecto_detalle as pd \n"
				+ "on pd.cod_proyecto = p.cod_proyecto\n"
				+ "inner join usuario_detalle as ud \n"
				+ "on ud.cod_proyecto_detalle = pd.cod_proyecto_detalle\n"
				+ "where p.cod_proyecto = " + codigo + "\n"
				+ "and ud.est = 1\n"
				+ ") ";
			pst = con.prepareStatement(sql);
			rs = pst.executeUpdate();
			if (rs > 0) {
				sql = " update proyecto_detalle\n"
					+ "set est = 0\n"
					+ "where cod_proyecto_detalle in (\n"
					+ "select pd.cod_proyecto_detalle from proyecto as p\n"
					+ "inner join proyecto_detalle as pd \n"
					+ "on pd.cod_proyecto = p.cod_proyecto\n"
					+ "where p.cod_proyecto = " + codigo + "\n"
					+ "and pd.est = 1\n"
					+ ") ";
				pst = con.prepareStatement(sql);
				rs = pst.executeUpdate();
				if (rs > 0) {
					resultado = 1;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			response.setStatus(false);
			response.setMessage("Error --->" + e.getMessage());
		} finally {
			try {
				if (rSet != null) {
					rSet.close();
				}
				if (pst != null) {
					pst.close();
				}
				if (con != null) {
					con.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
				response.setStatus(false);
				response.setMessage("Error --->" + e.getMessage());
			}
		}
		return resultado;
	}

}
