/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.sqlserverdao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import moduloSeguridad.utilities.ResponseHelper;
import moduloSeguridad.dao.MenuDAO;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class MenuSqlServerDAO implements MenuDAO {

    @Override
    public JSONArray listarProyecto() throws Exception {
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rs = null;
	String query = "";
	JSONArray lista = new JSONArray();
	try {
	    query = "select pd.cod_proyecto, p.nom from proyecto_detalle as pd "
		    + "inner join proyecto as p "
		    + "on p.cod_proyecto = pd.cod_proyecto "
		    + "group by pd.cod_proyecto, p.nom ";
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    pst = con.prepareStatement(query);
	    rs = pst.executeQuery();
	    while (rs.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigoProyecto", rs.getInt(1));
		obj.put("nombreProyecto", rs.getString(2));
		lista.put(obj);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	} finally {
	    con.close();
	    pst.close();
	}
	return lista;
    }

    @Override
    public JSONArray listarTipoDeUsuario(int proyecto) throws Exception {
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rs = null;
	String query = "";
	JSONArray lista = new JSONArray();
	try {
	    query = " select pd.cod_proyecto_detalle, tu.nom from proyecto_detalle as pd "
		    + "inner join tipo_usuario as tu "
		    + "on pd.cod_tipo_usuario = tu.cod_tipo_usuario "
		    + "where cod_proyecto = " + proyecto + "";
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    pst = con.prepareStatement(query);
	    rs = pst.executeQuery();
	    while (rs.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigoDetalle", rs.getInt(1));
		obj.put("nombreTipoUsuario", rs.getString(2));
		lista.put(obj);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	} finally {
	    con.close();
	    pst.close();
	}
	return lista;
    }

    @Override
    public JSONArray listarTituloCompleto(int proyecto_detalle, int proyecto, int tipo) throws Exception {
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rs = null;
	String query = "";
	String extra = "";
	JSONArray lista = new JSONArray();
	try {
	    if (proyecto_detalle == 0) {
		if (tipo == 1) {
		    extra = " -1  ";
		}
		query = "select t.cod_titulo, t.nom, t.ico, t.est, 0, 0, count(*) as cant "
			+ "from titulo_configuracion  tc "
			+ "left join proyecto_detalle as pd "
			+ "on tc.cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ "inner join titulo as t "
			+ "on t.cod_titulo = tc.cod_titulo "
			+ "where pd.cod_proyecto = " + proyecto + " "
			+ "group by  t.cod_titulo, t.nom, t.ico, t.est "
			+ "HAVING COUNT(*) =  "
			+ "( "
			+ "select COUNT(*) " + extra + " "
			+ "from proyecto_detalle "
			+ "where cod_proyecto = " + proyecto + " "
			+ ") ";
	    } else {
		query = " select t.cod_titulo, t.nom, t.ico, t.est, tc.cod_titulo_configuracion, tc.ord from titulo as t "
			+ " inner join titulo_configuracion as tc "
			+ " on tc.cod_titulo = t.cod_titulo "
			+ " where tc.cod_proyecto_detalle = " + proyecto_detalle + ""
			+ " order by ord ";
	    }
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    pst = con.prepareStatement(query);
	    rs = pst.executeQuery();
	    while (rs.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigoTitulo", rs.getInt(1));
		obj.put("nombreTitulo", rs.getString(2));
		obj.put("iconoTitulo", rs.getString(3));
		obj.put("estadoTitulo", rs.getString(4));
		obj.put("configuracionTitulo", rs.getString(5));
		obj.put("ordenTitulo", rs.getString(6));
		lista.put(obj);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	} finally {
	    con.close();
	    pst.close();
	}
	return lista;
    }

    @Override
    public JSONArray listarModuloCompleto(int titulo, int proyecto_detalle, int proyecto, int tipo) throws Exception {
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rs = null;
	String query = "";
	String extra = "";
	JSONArray lista = new JSONArray();
	try {
	    if (proyecto_detalle == 0) {
		if (tipo == 1) {
		    extra = " -1  ";
		}
		query = "select m.esvisible, m.cod_modulo, m.cod_titulo, m.nom, m.ico, m.url, m.tip, m.est, 0, 0, count(*) as cant "
			+ "from modulo_configuracion  mc "
			+ "left join proyecto_detalle as pd "
			+ "on mc.cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ "inner join modulo as m "
			+ "on m.cod_modulo = mc.cod_modulo "
			+ "where pd.cod_proyecto = " + proyecto + " "
			+ "and m.cod_titulo = " + titulo + " "
			+ "group by  m.cod_modulo, m.cod_titulo, m.nom, m.ico, m.url, m.tip, m.est\n"
			+ "HAVING COUNT(*) =  "
			+ "( "
			+ "select COUNT(*)  " + extra + " "
			+ "from proyecto_detalle "
			+ "where cod_proyecto = " + proyecto + " "
			+ ") ";
	    } else {
		query = " select m.esvisible, m.cod_modulo, m.cod_titulo, m.nom, m.ico, m.url, m.tip, m.est, mc.cod_modulo_configuracion, mc.ord from modulo as m"
			+ " inner join modulo_configuracion as mc"
			+ " on m.cod_modulo = mc.cod_modulo "
			+ " where cod_proyecto_detalle = " + proyecto_detalle + " "
			+ " and cod_titulo = " + titulo + ""
			+ " order by ord ";
	    }
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    pst = con.prepareStatement(query);
	    rs = pst.executeQuery();
	    while (rs.next()) {
		JSONObject obj = new JSONObject();
                obj.put("esVisible", rs.getBoolean(1));
		obj.put("codigoModulo", rs.getInt(2));
		obj.put("codigoTitulo", rs.getInt(3));
		obj.put("nombreModulo", rs.getString(4));
		obj.put("iconoModulo", rs.getString(5));
		obj.put("urlModulo", rs.getString(6));
		obj.put("tipoModulo", rs.getInt(7));
		obj.put("estadoModulo", rs.getInt(8));
		obj.put("configuracionModulo", rs.getString(9));
		obj.put("ordenModulo", rs.getString(10));
		lista.put(obj);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	} finally {
	    con.close();
	    pst.close();
	}
	return lista;
    }

    @Override
    public JSONArray listarCategoriaCompleto(int modulo, int proyecto_detalle, int proyecto, int tipo) throws Exception {
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rs = null;
	String query = "";
	String extra = "";
	JSONArray lista = new JSONArray();
	try {
	    if (proyecto_detalle == 0) {
		if (tipo == 1) {
		    extra = " -1  ";
		}
		query = "select c.cod_modulo, c.cod_categoria, c.nom, c.url, c.tip, c.est, 0, 0, count(*) as cant   "
			+ "from categoria_configuracion  tc "
			+ "left join proyecto_detalle as pd "
			+ "on tc.cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ "inner join categoria as c "
			+ "on c.cod_categoria = tc.cod_categoria "
			+ "where pd.cod_proyecto = " + proyecto + " "
			+ "and c.cod_modulo = " + modulo + " "
			+ "group by c.cod_modulo, c.cod_categoria, c.nom, c.url, c.tip, c.est "
			+ "HAVING COUNT(*) =  "
			+ "( "
			+ "select COUNT(*)   " + extra + " "
			+ "from proyecto_detalle "
			+ "where cod_proyecto = " + proyecto + "  "
			+ ") ";
	    } else {
		query = " select c.cod_modulo, c.cod_categoria, c.nom, c.url, c.tip, c.est, cc.cod_categoria_configuracion, cc.ord from categoria as c "
			+ " inner join categoria_configuracion as cc"
			+ " on cc.cod_categoria = c.cod_categoria "
			+ " where cod_proyecto_detalle = " + proyecto_detalle + " "
			+ " and cod_modulo = " + modulo + ""
			+ " order by ord ";
	    }
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    pst = con.prepareStatement(query);
	    rs = pst.executeQuery();
	    while (rs.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigoModulo", rs.getInt(1));
		obj.put("codigoCategoria", rs.getInt(2));
		obj.put("nombreCategoria", rs.getString(3));
		obj.put("urlCategoria", rs.getString(4));
		obj.put("tipoCategoria", rs.getInt(5));
		obj.put("estadoCategoria", rs.getString(6));
		obj.put("configuracionCategoria", rs.getString(7));
		obj.put("ordenCategoria", rs.getString(8));
		lista.put(obj);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	} finally {
	    con.close();
	    pst.close();
	}
	return lista;
    }

    @Override
    public JSONArray listarSubCategoriaCompleto(int categoria, int proyecto_detalle, int proyecto, int tipo) throws Exception {
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rs = null;
	String query = "";
	String extra = "";
	JSONArray lista = new JSONArray();
	try {
	    if (proyecto_detalle == 0) {
		if (tipo == 1) {
		    extra = " -1  ";
		}
		query = "select s.cod_subcategoria, s.cod_categoria, s.nom, s.url, s.est, 0, 0, count(*) as cant "
			+ "from subcategoria_configuracion  sc "
			+ "left join proyecto_detalle as pd "
			+ "on sc.cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ "inner join subcategoria as s "
			+ "on s.cod_subcategoria = sc.cod_subcategoria "
			+ "where pd.cod_proyecto =  " + proyecto + " "
			+ "and s.cod_categoria = " + categoria + " "
			+ "group by s.cod_subcategoria, s.cod_categoria, s.nom, s.url, s.est "
			+ "HAVING COUNT(*) =  "
			+ "( "
			+ "select COUNT(*) " + extra + " "
			+ "from proyecto_detalle "
			+ "where cod_proyecto = " + proyecto + " "
			+ ") ";
	    } else {
		query = " select s.cod_subcategoria, s.cod_categoria, s.nom, s.url, s.est, sc.cod_subcategoria_configuracion, sc.ord from subcategoria as s"
			+ " inner join subcategoria_configuracion as sc "
			+ " on sc.cod_subcategoria = s.cod_subcategoria "
			+ " where cod_proyecto_detalle = " + proyecto_detalle + " "
			+ " and cod_categoria = " + categoria + ""
			+ " order by ord ";
	    }
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    pst = con.prepareStatement(query);
	    rs = pst.executeQuery();
	    while (rs.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigoSubCategoria", rs.getInt(1));
		obj.put("codigoCategoria", rs.getInt(2));
		obj.put("nombreSubCategoria", rs.getString(3));
		obj.put("urlSubCategoria", rs.getString(4));
		obj.put("estadoSubCategoria", rs.getString(5));
		obj.put("configuracionSubCategoria", rs.getString(6));
		obj.put("ordenSubCategoria", rs.getString(7));
		lista.put(obj);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	} finally {
	    con.close();
	    pst.close();
	}
	return lista;
    }

    @Override
    public JSONObject editarTitulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	String base = "security";
	Connection con = null;
	PreparedStatement pstEditarTitulo = null;
	int rsTitulo = 0;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    String sql
		    = " update titulo "
		    + " set nom = RTRIM(UPPER(?)), "
		    + " ico = RTRIM(?) "
		    + " where cod_titulo = ? ";

	    pstEditarTitulo = con.prepareStatement(sql);
	    pstEditarTitulo.setString(1, datos.getString("nombre"));
	    pstEditarTitulo.setString(2, datos.getString("icono"));
	    pstEditarTitulo.setInt(3, datos.getInt("codigo"));
	    rsTitulo = pstEditarTitulo.executeUpdate();

	    if (rsTitulo == 1) {
		response.setMessage("Se actualizo correctamente");
		response.setStatus(true); // ACTUALIZO
	    } else {
		response.setMessage("Error al actualizar");
		response.setStatus(false); // ERROR
	    }

	} catch (SQLException e) {
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pstEditarTitulo != null) {
		    pstEditarTitulo.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject editarModulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	String base = "security";
	Connection con = null;
	PreparedStatement pstEditarModulo = null;
	int rsModulo = 0;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
            
            int visible = 0;
            //validando el visible
            if(datos.getBoolean("esVisible")){
                visible = 1;
            }
            
	    String sql
		    = " update modulo "
		    + " set nom = RTRIM(UPPER(?)), "
		    + " ico = RTRIM(?), "
		    + " tip = ?, "
                    + " esvisible = ?, "
		    + " url = RTRIM(?) "
		    + " where cod_modulo = ? ";

	    pstEditarModulo = con.prepareStatement(sql);
	    pstEditarModulo.setString(1, datos.getString("nombre"));
	    pstEditarModulo.setString(2, datos.getString("icono"));
	    pstEditarModulo.setInt(3, datos.getInt("tipo"));
            pstEditarModulo.setInt(4, visible);
	    pstEditarModulo.setString(5, datos.getString("url"));
	    pstEditarModulo.setInt(6, datos.getInt("codigo"));
	    rsModulo = pstEditarModulo.executeUpdate();

	    if (rsModulo == 1) {
		response.setMessage("Se actualizo correctamente");
		response.setStatus(true); // ACTUALIZO
	    } else {
		response.setMessage("Error al actualizar");
		response.setStatus(false); // ERROR
	    }

	} catch (SQLException e) {
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pstEditarModulo != null) {
		    pstEditarModulo.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject editarCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	String base = "security";
	Connection con = null;
	PreparedStatement pstEditarCategoria = null;
	int rsCategoria = 0;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    String sql
		    = " update categoria "
		    + " set nom = RTRIM(UPPER(?)), "
		    + " tip = ?, "
		    + " url = RTRIM(?) "
		    + " where cod_categoria = ? ";

	    pstEditarCategoria = con.prepareStatement(sql);
	    pstEditarCategoria.setString(1, datos.getString("nombre"));
	    pstEditarCategoria.setInt(2, datos.getInt("tipo"));
	    pstEditarCategoria.setString(3, datos.getString("url"));
	    pstEditarCategoria.setInt(4, datos.getInt("codigo"));
	    rsCategoria = pstEditarCategoria.executeUpdate();

	    if (rsCategoria == 1) {
		response.setMessage("Se actualizo correctamente");
		response.setStatus(true); // ACTUALIZO
	    } else {
		response.setMessage("Error al actualizar");
		response.setStatus(false); // ERROR
	    }

	} catch (SQLException e) {
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pstEditarCategoria != null) {
		    pstEditarCategoria.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject editarSubCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	String base = "security";
	Connection con = null;
	PreparedStatement pstEditarSubCategoria = null;
	int rsSubCategoria = 0;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    String sql
		    = " update subcategoria "
		    + " set nom = RTRIM(UPPER(?)), "
		    + " url = RTRIM(?) "
		    + " where cod_subcategoria = ? ";

	    pstEditarSubCategoria = con.prepareStatement(sql);
	    pstEditarSubCategoria.setString(1, datos.getString("nombre"));
	    pstEditarSubCategoria.setString(2, datos.getString("url"));
	    pstEditarSubCategoria.setInt(3, datos.getInt("codigo"));
	    rsSubCategoria = pstEditarSubCategoria.executeUpdate();

	    if (rsSubCategoria == 1) {
		response.setMessage("Se actualizo correctamente");
		response.setStatus(true); // ACTUALIZO
	    } else {
		response.setMessage("Error al actualizar");
		response.setStatus(false); // ERROR
	    }

	} catch (SQLException e) {
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pstEditarSubCategoria != null) {
		    pstEditarSubCategoria.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject nuevoTitulo(JSONObject datos) {
	JSONObject jsonReturn;
//        JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " insert into titulo (nom, ico, est) "
		    + " values(upper(?), ?, 1) ";
	    pst = con.prepareStatement(sql, Statement.RETURN_GENERATED_KEYS);
	    pst.setString(1, datos.getString("nombre"));
	    pst.setString(2, datos.getString("icono"));
	    rs = pst.executeUpdate();
	    if (rs > 0) {
		rsLlave = pst.getGeneratedKeys();
		rsLlave.next();
		int titulo = rsLlave.getInt(1);
		sql = " insert into titulo_configuracion (cod_titulo,cod_proyecto_detalle, ord,est) "
			+ " select ?, cod_proyecto_detalle, "
			+ " ( "
			+ " select isnull((select top 1 isnull(ord + 1, 1) from titulo_configuracion "
			+ " where cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ " order by ord desc ), 1) "
			+ " ), 1 "
			+ " from proyecto_detalle as pd ";
		if (datos.getInt("tipo") == 1) {
		    sql += " where cod_proyecto_detalle = ? ";
		} else {
		    sql += " where cod_proyecto = ? ";
		}
		pst = con.prepareStatement(sql);
		pst.setInt(1, titulo);
		pst.setInt(2, datos.getInt("proyecto"));
		rs = pst.executeUpdate();
		if (rs == 0) {
		    con.rollback();
		    response.setMessage("error al insertar titulo_configuración");
		    response.setStatus(false);
		} else {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		}

	    } else {
		con.rollback();
		response.setMessage("error al insertar titulo");
		response.setStatus(false);
	    }

	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject nuevoCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
//        JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " insert into categoria (cod_modulo, nom, tip, url, est) "
		    + "values(?, upper(?), ?, ?, 1) ";
	    pst = con.prepareStatement(sql, Statement.RETURN_GENERATED_KEYS);
	    pst.setInt(1, datos.getInt("padre"));
	    pst.setString(2, datos.getString("nombre"));
	    pst.setInt(3, datos.getInt("tipoMenu"));
	    pst.setString(4, datos.getString("url"));
	    rs = pst.executeUpdate();
	    if (rs > 0) {
		rsLlave = pst.getGeneratedKeys();
		rsLlave.next();
		int titulo = rsLlave.getInt(1);
		sql = " insert into categoria_configuracion (cod_categoria,cod_proyecto_detalle, ord,est) "
			+ " select ?, cod_proyecto_detalle, "
			+ " ( "
			+ " select isnull((select top 1 isnull(ord + 1, 1) from categoria_configuracion "
			+ " where cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ " order by ord desc ), 1) "
			+ " ), 1 "
			+ " from proyecto_detalle as pd ";
		if (datos.getInt("tipo") == 1) {
		    sql += " where cod_proyecto_detalle = ? ";
		} else {
		    sql += " where cod_proyecto = ? ";
		}
		pst = con.prepareStatement(sql);
		pst.setInt(1, titulo);
		pst.setInt(2, datos.getInt("proyecto"));
		rs = pst.executeUpdate();
		if (rs == 0) {
		    con.rollback();
		    response.setMessage("error al insertar categoria_configuración");
		    response.setStatus(false);
		} else {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		}

	    } else {
		con.rollback();
		response.setMessage("error al insertar categoria");
		response.setStatus(false);
	    }

	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject nuevoModulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
//        JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " insert into modulo (cod_titulo, nom, ico, tip, url, est) "
		    + " values(?, upper(?), ?, ?, ?, 1) ";
	    pst = con.prepareStatement(sql, Statement.RETURN_GENERATED_KEYS);
	    pst.setInt(1, datos.getInt("padre"));
	    pst.setString(2, datos.getString("nombre"));
	    pst.setString(3, datos.getString("icono"));
	    pst.setInt(4, datos.getInt("tipoMenu"));
	    pst.setString(5, datos.getString("url"));
	    rs = pst.executeUpdate();
	    if (rs > 0) {
		rsLlave = pst.getGeneratedKeys();
		rsLlave.next();
		int titulo = rsLlave.getInt(1);
		sql = " insert into modulo_configuracion (cod_modulo,cod_proyecto_detalle, ord,est) "
			+ " select ?, cod_proyecto_detalle, "
			+ " ( "
			+ " select isnull((select top 1 isnull(ord + 1, 1) from modulo_configuracion "
			+ " where cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ " order by ord desc ), 1) "
			+ " ), 1 "
			+ " from proyecto_detalle as pd ";
		if (datos.getInt("tipo") == 1) {
		    sql += " where cod_proyecto_detalle = ? ";
		} else {
		    sql += " where cod_proyecto = ? ";
		}
		pst = con.prepareStatement(sql);
		pst.setInt(1, titulo);
		pst.setInt(2, datos.getInt("proyecto"));
		rs = pst.executeUpdate();
		if (rs == 0) {
		    con.rollback();
		    response.setMessage("error al insertar modulo_configuración");
		    response.setStatus(false);
		} else {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		}

	    } else {
		con.rollback();
		response.setMessage("error al insertar modulo");
		response.setStatus(false);
	    }

	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject nuevoSubCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
//        JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " insert into subcategoria (cod_categoria, nom, url, est) "
		    + " values(?, upper(?), ?, 1) ";
	    pst = con.prepareStatement(sql, Statement.RETURN_GENERATED_KEYS);
	    pst.setInt(1, datos.getInt("padre"));
	    pst.setString(2, datos.getString("nombre"));
	    pst.setString(3, datos.getString("url"));
	    rs = pst.executeUpdate();
	    if (rs > 0) {
		rsLlave = pst.getGeneratedKeys();
		rsLlave.next();
		int titulo = rsLlave.getInt(1);
		sql = " insert into subcategoria_configuracion (cod_subcategoria,cod_proyecto_detalle, ord,est) "
			+ " select ?, cod_proyecto_detalle, "
			+ " ( "
			+ " select isnull((select top 1 isnull(ord + 1, 1) from subcategoria_configuracion "
			+ " where cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ " order by ord desc ), 1) "
			+ " ), 1 "
			+ " from proyecto_detalle as pd ";
		if (datos.getInt("tipo") == 1) {
		    sql += " where cod_proyecto_detalle = ? ";
		} else {
		    sql += " where cod_proyecto = ? ";
		}
		pst = con.prepareStatement(sql);
		pst.setInt(1, titulo);
		pst.setInt(2, datos.getInt("proyecto"));
		rs = pst.executeUpdate();
		if (rs == 0) {
		    con.rollback();
		    response.setMessage("error al insertar subcategoria_configuración");
		    response.setStatus(false);
		} else {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		}

	    } else {
		con.rollback();
		response.setMessage("error al insertar subcategoria");
		response.setStatus(false);
	    }

	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject cambiarOrdenTitulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	int rsTitulo = 0;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    String sql
		    = " update titulo_configuracion "
		    + " set ord = ? "
		    + " where cod_titulo_configuracion = ? ";

	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("ordenB"));
	    pst.setInt(2, datos.getInt("configuracionA"));
	    rsTitulo = pst.executeUpdate();

	    if (rsTitulo >= 1) {
		pst.setInt(1, datos.getInt("ordenA"));
		pst.setInt(2, datos.getInt("configuracionB"));
		rsTitulo = pst.executeUpdate();

		if (rsTitulo >= 1) {
		    response.setMessage("Se actualizo correctamente");
		    response.setStatus(true); // ACTUALIZO
		} else {
		    response.setMessage("Error al actualizar");
		    response.setStatus(false); // ERROR
		}
	    } else {
		response.setMessage("Error al actualizar");
		response.setStatus(false); // ERROR
	    }

	} catch (SQLException e) {
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pst != null) {
		    pst.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject cambiarOrdenModulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	int rsTitulo = 0;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    String sql
		    = " update modulo_configuracion "
		    + " set ord = ? "
		    + " where cod_modulo_configuracion = ? ";

	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("ordenB"));
	    pst.setInt(2, datos.getInt("configuracionA"));
	    rsTitulo = pst.executeUpdate();
	    if (rsTitulo >= 1) {
		pst.setInt(1, datos.getInt("ordenA"));
		pst.setInt(2, datos.getInt("configuracionB"));
		rsTitulo = pst.executeUpdate();
		if (rsTitulo >= 1) {
		    response.setMessage("Se actualizo correctamente");
		    response.setStatus(true); // ACTUALIZO
		} else {
		    response.setMessage("Error al actualizar");
		    response.setStatus(false); // ERROR
		}
	    } else {
		response.setMessage("Error al actualizar");
		response.setStatus(false); // ERROR
	    }

	} catch (SQLException e) {
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pst != null) {
		    pst.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject cambiarOrdenCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	int rsTitulo = 0;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    String sql
		    = " update categoria_configuracion "
		    + " set ord = ? "
		    + " where cod_categoria_configuracion = ? ";
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("ordenB"));
	    pst.setInt(2, datos.getInt("configuracionA"));
	    rsTitulo = pst.executeUpdate();
	    if (rsTitulo >= 1) {
		pst.setInt(1, datos.getInt("ordenA"));
		pst.setInt(2, datos.getInt("configuracionB"));
		rsTitulo = pst.executeUpdate();
		if (rsTitulo >= 1) {
		    response.setMessage("Se actualizo correctamente");
		    response.setStatus(true); // ACTUALIZO
		} else {
		    response.setMessage("Error al actualizar");
		    response.setStatus(false); // ERROR
		}
	    } else {
		response.setMessage("Error al actualizar");
		response.setStatus(false); // ERROR
	    }

	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pst != null) {
		    pst.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject cambiarOrdenSubCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	int rsTitulo = 0;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    String sql
		    = " update subcategoria_configuracion "
		    + " set ord = ? "
		    + " where cod_subcategoria_configuracion = ? ";
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("ordenB"));
	    pst.setInt(2, datos.getInt("configuracionA"));
	    rsTitulo = pst.executeUpdate();

	    if (rsTitulo >= 1) {
		pst.setInt(1, datos.getInt("ordenA"));
		pst.setInt(2, datos.getInt("configuracionB"));
		rsTitulo = pst.executeUpdate();

		if (rsTitulo >= 1) {
		    response.setMessage("Se actualizo correctamente");
		    response.setStatus(true); // ACTUALIZO
		} else {
		    response.setMessage("Error al actualizar");
		    response.setStatus(false); // ERROR
		}
	    } else {
		response.setMessage("Error al actualizar");
		response.setStatus(false); // ERROR
	    }

	} catch (SQLException e) {
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pst != null) {
		    pst.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject reconocerNombreSimilar(JSONObject datos) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	JSONObject obj = new JSONObject();
//	JSONObject retorno = new JSONObject();
//	JSONArray array = new JSONArray();
	String base = "security";
	String sql = "";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rs = null;
	int cant;
	ResponseHelper response = new ResponseHelper();
	String cadena = "";
	String condicion = "";
	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    switch (datos.getInt("jerarquia")) {
		case 1:
		    cadena = "titulo, ico, '', ''";
		    break;
		case 2:
		    cadena = "modulo, ico, tip, url";
		    condicion = " and cod_titulo = " + datos.getInt("padre") + " ";
		    break;
		case 3:
		    cadena = "categoria, '', tip, url";
		    condicion = " and cod_modulo = " + datos.getInt("padre") + " ";
		    break;
		case 4:
		    cadena = "subcategoria, '', '', url";
		    condicion = " and cod_categoria = " + datos.getInt("padre") + " ";
		    break;
		default:
		    break;
	    }
	    sql = " SELECT count(*) as cant FROM " + datos.getString("tabla") + " "
		    + " WHERE SIMILARITY_1_1_0.JaroWinkler(UPPER(nom),UPPER('" + datos.getString("nombre") + "')) >= 0.75 "
		    + " " + condicion + " ";
	    pst = con.prepareStatement(sql);
	    rs = pst.executeQuery();
	    rs.next();
	    cant = rs.getInt("cant");
	    if (cant >= 1) {
		sql
			= " SELECT top 1 nom, cod_" + cadena + " FROM " + datos.getString("tabla") + " "
			+ " WHERE SIMILARITY_1_1_0.JaroWinkler(UPPER(nom),UPPER(?)) >= 0.75 "
			+ " " + condicion + " "
			+ " ORDER BY SIMILARITY_1_1_0.Levenshtein(UPPER(nom), UPPER(?)) DESC ";
		pst = con.prepareStatement(sql);
		pst.setString(1, datos.getString("nombre"));
		pst.setString(2, datos.getString("nombre"));
		rs = pst.executeQuery();
		rs.next();

		obj.put("nombre", rs.getString(1));
		obj.put("codigo", rs.getInt(2));
		obj.put("icono", rs.getString(3));
		obj.put("tipo", rs.getString(4));
		obj.put("url", rs.getString(5));

		response.setMessage("Hay coincidencias");
		response.setStatus(true);
		response.setData(obj);
	    } else {
		response.setMessage("No hay coincidencias");
		response.setStatus(false);
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (con != null) {
		    con.close();
		}
		if (pst != null) {
		    pst.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error al actualizar -> " + e.getMessage() + "[" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject nuevoTituloExistente(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
//        JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " select count(*) as cant from titulo_configuracion  as tc "
		    + " inner join proyecto_detalle as pd "
		    + " on pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
		    + " where cod_titulo = ? ";
	    if (datos.getInt("tipo") == 1) {
		sql += " and pd.cod_proyecto_detalle = ? ";
	    } else {
		sql += " and pd.cod_proyecto = ? ";
	    }
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("codigo"));
	    pst.setInt(2, datos.getInt("proyecto"));
	    rsLlave = pst.executeQuery();
	    rsLlave.next();
	    cant = rsLlave.getInt("cant");
	    if (cant == 0) {
		sql = " insert into titulo_configuracion (cod_titulo,cod_proyecto_detalle, ord,est) "
			+ " select ?, cod_proyecto_detalle, "
			+ " ( "
			+ " select isnull((select top 1 isnull(ord + 1, 1) from titulo_configuracion "
			+ " where cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ " order by ord desc ), 1) "
			+ " ), 1 "
			+ " from proyecto_detalle as pd ";
		if (datos.getInt("tipo") == 1) {
		    sql += " where cod_proyecto_detalle = ? ";
		} else {
		    sql += " where cod_proyecto = ? ";
		}
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("proyecto"));
		rs = pst.executeUpdate();
		if (rs == 0) {
		    con.rollback();
		    response.setMessage("Ha ocurrido un error");
		    response.setStatus(false);
		} else {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		}
	    } else {
		con.rollback();
		response.setMessage("Este título ya existe en este proyecto");
		response.setStatus(false);
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject nuevoModuloExistente(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
//        JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " select count(*) as cant from modulo_configuracion  as tc "
		    + " inner join proyecto_detalle as pd "
		    + " on pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
		    + " where cod_modulo = ? ";
	    if (datos.getInt("tipo") == 1) {
		sql += " and pd.cod_proyecto_detalle = ? ";
	    } else {
		sql += " and pd.cod_proyecto = ? ";
	    }
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("codigo"));
	    pst.setInt(2, datos.getInt("proyecto"));
	    rsLlave = pst.executeQuery();
	    rsLlave.next();
	    int cant = rsLlave.getInt("cant");
	    if (cant == 0) {
		sql = " insert into modulo_configuracion (cod_modulo,cod_proyecto_detalle, ord,est) "
			+ " select ?, cod_proyecto_detalle, "
			+ " ( "
			+ " select isnull((select top 1 isnull(ord + 1, 1) from modulo_configuracion "
			+ " where cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ " order by ord desc ), 1) "
			+ " ), 1 "
			+ " from proyecto_detalle as pd ";
		if (datos.getInt("tipo") == 1) {
		    sql += " where cod_proyecto_detalle = ? ";
		} else {
		    sql += " where cod_proyecto = ? ";
		}
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("proyecto"));
		rs = pst.executeUpdate();
		if (rs == 0) {
		    con.rollback();
		    response.setMessage("error al insertar modulo_configuración");
		    response.setStatus(false);
		} else {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		}
	    } else {
		con.rollback();
		response.setMessage("Este Modulo ya existe en este proyecto");
		response.setStatus(false);
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject nuevoCategoriaExistente(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " select count(*) as cant from categoria_configuracion  as tc "
		    + " inner join proyecto_detalle as pd "
		    + " on pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
		    + " where cod_categoria = ? ";
	    if (datos.getInt("tipo") == 1) {
		sql += " and pd.cod_proyecto_detalle = ? ";
	    } else {
		sql += " and pd.cod_proyecto = ? ";
	    }
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("codigo"));
	    pst.setInt(2, datos.getInt("proyecto"));
	    rsLlave = pst.executeQuery();
	    rsLlave.next();
	    int cant = rsLlave.getInt("cant");
	    if (cant == 0) {
		sql = " insert into categoria_configuracion (cod_categoria,cod_proyecto_detalle, ord,est) "
			+ " select ?, cod_proyecto_detalle, "
			+ " ( "
			+ " select isnull((select top 1 isnull(ord + 1, 1) from categoria_configuracion "
			+ " where cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ " order by ord desc ), 1) "
			+ " ), 1 "
			+ " from proyecto_detalle as pd ";
		if (datos.getInt("tipo") == 1) {
		    sql += " where cod_proyecto_detalle = ? ";
		} else {
		    sql += " where cod_proyecto = ? ";
		}
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("proyecto"));
		rs = pst.executeUpdate();
		if (rs == 0) {
		    con.rollback();
		    response.setMessage("error al insertar categoria_configuración");
		    response.setStatus(false);
		} else {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		}
	    } else {
		con.rollback();
		response.setMessage("Esta Categoria ya existe en este proyecto");
		response.setStatus(false);
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject nuevoSubCategoriaExistente(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
//        JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " select count(*) as cant from subcategoria_configuracion  as tc "
		    + " inner join proyecto_detalle as pd "
		    + " on pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
		    + " where cod_subcategoria = ? ";
	    if (datos.getInt("tipo") == 1) {
		sql += " and pd.cod_proyecto_detalle = ? ";
	    } else {
		sql += " and pd.cod_proyecto = ? ";
	    }
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("codigo"));
	    pst.setInt(2, datos.getInt("proyecto"));
	    rsLlave = pst.executeQuery();
	    rsLlave.next();
	    int cant = rsLlave.getInt("cant");
	    if (cant == 0) {
		sql = " insert into subcategoria_configuracion (cod_subcategoria,cod_proyecto_detalle, ord,est) "
			+ " select ?, cod_proyecto_detalle, "
			+ " ( "
			+ " select isnull((select top 1 isnull(ord + 1, 1) from subcategoria_configuracion "
			+ " where cod_proyecto_detalle = pd.cod_proyecto_detalle "
			+ " order by ord desc ), 1) "
			+ " ), 1 "
			+ " from proyecto_detalle as pd ";
		if (datos.getInt("tipo") == 1) {
		    sql += " where cod_proyecto_detalle = ? ";
		} else {
		    sql += " where cod_proyecto = ? ";
		}
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("proyecto"));
		rs = pst.executeUpdate();
		if (rs == 0) {
		    con.rollback();
		    response.setMessage("error al insertar subcategoria_configuración");
		    response.setStatus(false);
		} else {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		}
	    } else {
		con.rollback();
		response.setMessage("Esta Subcategoria ya existe en este proyecto");
		response.setStatus(false);
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject validarEdicionTitulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	int cant;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " select count(*) as cant, cod_proyecto from proyecto_detalle as pd "
		    + " inner join titulo_configuracion as tc "
		    + " on tc.cod_proyecto_detalle = pd.cod_proyecto_detalle"
		    + " inner join titulo as t "
		    + " on t.cod_titulo = tc.cod_titulo "
		    + " where t.cod_titulo = ? "
		    + " group by pd.cod_proyecto ";
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("codigo"));
	    rsLlave = pst.executeQuery();
	    while (rsLlave.next()) {
		JSONObject obj = new JSONObject();
		obj.put("cant", rsLlave.getInt("cant"));
		data.put(obj);
	    }
	    if (data.length() > 1) {
		con.rollback();
		response.setMessage("error al insertar modulo_configuración");
		response.setStatus(false);
	    } else {
		con.commit();
		response.setStatus(true);
		response.setMessage("Se registro correctamente.");
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject validarEdicionModulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	int cant;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " select count(*) as cant, cod_proyecto from proyecto_detalle as pd "
		    + " inner join modulo_configuracion as tc "
		    + " on tc.cod_proyecto_detalle = pd.cod_proyecto_detalle"
		    + " inner join modulo as t "
		    + " on t.cod_modulo = tc.cod_modulo "
		    + " where t.cod_modulo = ? "
		    + " group by pd.cod_proyecto ";
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("codigo"));
	    rsLlave = pst.executeQuery();
	    while (rsLlave.next()) {
		JSONObject obj = new JSONObject();
		obj.put("cant", rsLlave.getInt("cant"));
		data.put(obj);
	    }
	    if (data.length() > 1) {
		con.rollback();
		response.setMessage("error al insertar modulo_configuración");
		response.setStatus(false);
	    } else {
		con.commit();
		response.setStatus(true);
		response.setMessage("Se registro correctamente.");
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject validarEdicionCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	int cant;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " select count(*) as cant, cod_proyecto from proyecto_detalle as pd "
		    + " inner join categoria_configuracion as tc "
		    + " on tc.cod_proyecto_detalle = pd.cod_proyecto_detalle"
		    + " inner join categoria as t "
		    + " on t.cod_categoria = tc.cod_categoria "
		    + " where t.cod_categoria = ? "
		    + " group by pd.cod_proyecto ";
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("codigo"));
	    rsLlave = pst.executeQuery();
	    while (rsLlave.next()) {
		JSONObject obj = new JSONObject();
		obj.put("cant", rsLlave.getInt("cant"));
		data.put(obj);
	    }
	    if (data.length() > 1) {
		con.rollback();
		response.setMessage("error al insertar modulo_configuración");
		response.setStatus(false);
	    } else {
		con.commit();
		response.setStatus(true);
		response.setMessage("Se registro correctamente.");
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject validarEdicionSubCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	int cant;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    sql = " select count(*) as cant, cod_proyecto from proyecto_detalle as pd "
		    + " inner join subcategoria_configuracion as tc "
		    + " on tc.cod_proyecto_detalle = pd.cod_proyecto_detalle"
		    + " inner join subcategoria as t "
		    + " on t.cod_subcategoria = tc.cod_subcategoria "
		    + " where t.cod_subcategoria = ? "
		    + " group by pd.cod_proyecto ";
	    pst = con.prepareStatement(sql);
	    pst.setInt(1, datos.getInt("codigo"));
	    rsLlave = pst.executeQuery();
	    while (rsLlave.next()) {
		JSONObject obj = new JSONObject();
		obj.put("cant", rsLlave.getInt("cant"));
		data.put(obj);
	    }
	    if (data.length() > 1) {
		con.rollback();
		response.setMessage("error al insertar modulo_configuración");
		response.setStatus(false);
	    } else {
		con.commit();
		response.setStatus(true);
		response.setMessage("Se registro correctamente.");
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject listarTitulo(JSONObject datos, String draw, String start, String length) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant = 0;
	String sql;
	ResponseHelper response = new ResponseHelper();
	String existencia = "";
	if (datos.getInt("detalle") == 0) {
	    existencia = " and pd.cod_proyecto = " + datos.getInt("proyecto") + " ";
	} else {
	    existencia = " and tc.cod_proyecto_detalle = " + datos.getInt("detalle") + " ";
	}
	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    sql = "select top " + length + " a.cod_titulo, a.nom, a.ico, "
		    + "ISNULL( "
		    + "(select count(*) as cant from titulo_configuracion as tc  "
		    + "inner join proyecto_detalle as pd  "
		    + "on pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
		    + "where tc.cod_titulo = a.cod_titulo "
		    + existencia + "), 0) "
		    + "from titulo as a "
		    + "where a.cod_titulo not in  "
		    + "(select top " + start + " b.cod_titulo from titulo as b "
		    + "ORDER BY 1 desc) "
		    + "ORDER BY 1 desc ; ";
	    pst = con.prepareStatement(sql);
	    rsLlave = pst.executeQuery();
	    while (rsLlave.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigo", rsLlave.getInt(1));
		obj.put("nombre", rsLlave.getString(2));
		obj.put("icono", rsLlave.getString(3));
		obj.put("tipo", 0);
		obj.put("url", "");
		obj.put("existencia", rsLlave.getInt(4));
		data.put(obj);
	    }
	    sql = " select count(*) as cant from titulo ";
	    pst = con.prepareStatement(sql);
	    rsLlave = pst.executeQuery();
	    rsLlave.next();
	    cant = rsLlave.getInt("cant");
	    if (data.length() < 1) {
		response.setMessage("Error al listar");
		response.setStatus(false);
	    } else {
		response.setStatus(true);
		response.setMessage("Se listo correctamente.");
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn.put("data", data);
	jsonReturn.put("recordsFiltered", cant);
	jsonReturn.put("recordsTotal", cant);
	jsonReturn.put("draw", draw);

	return jsonReturn;
    }

    @Override
    public JSONObject listarModulo(JSONObject datos, String draw, String start, String length) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant = 0;
	String sql;
	ResponseHelper response = new ResponseHelper();
	String condicion = " and cod_titulo = " + datos.getInt("padre") + " ";
	String existencia;
	if (datos.getInt("detalle") == 0) {
	    existencia = " and pd.cod_proyecto = " + datos.getInt("proyecto") + " ";
	} else {
	    existencia = " and mc.cod_proyecto_detalle = " + datos.getInt("detalle") + " ";
	}
	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    sql = " select top " + length + " a.cod_modulo, a.nom, a.ico, a.tip, a.url, "
		    + " ISNULL(  "
		    + " (select count(*) as cant  "
		    + " from modulo_configuracion as mc   "
		    + " inner join proyecto_detalle as pd   "
		    + " on pd.cod_proyecto_detalle = mc.cod_proyecto_detalle  "
		    + " where mc.cod_modulo = a.cod_modulo "
		    + existencia + " ), 0)  "
		    + " from modulo as a  "
		    + " where a.cod_modulo not in   "
		    + " (select top " + start + " b.cod_modulo from modulo as b "
		    + " where 1 = 1 " + condicion
		    + " ORDER BY 1 desc)  "
		    + condicion
		    + " ORDER BY 1 desc ; ";
	    pst = con.prepareStatement(sql);
	    rsLlave = pst.executeQuery();
	    while (rsLlave.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigo", rsLlave.getInt(1));
		obj.put("nombre", rsLlave.getString(2));
		obj.put("icono", rsLlave.getString(3));
		obj.put("tipo", rsLlave.getInt(4));
		obj.put("url", rsLlave.getString(5));
		obj.put("existencia", rsLlave.getInt(6));
		data.put(obj);
	    }
	    sql = "select count(*) as cant from modulo as a "
		    + " where 1 = 1 " + condicion + " ";
	    pst = con.prepareStatement(sql);
	    rsLlave = pst.executeQuery();
	    rsLlave.next();
	    cant = rsLlave.getInt("cant");
	    if (data.length() > 1) {
		response.setMessage("Error al listar");
		response.setStatus(false);
	    } else {
		response.setStatus(true);
		response.setMessage("Se listo correctamente.");
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn.put("data", data);
	jsonReturn.put("recordsFiltered", cant);
	jsonReturn.put("recordsTotal", cant);
	jsonReturn.put("draw", draw);

	return jsonReturn;
    }

    @Override
    public JSONObject listarCategoria(JSONObject datos, String draw, String start, String length) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant = 0;
	String sql;
	ResponseHelper response = new ResponseHelper();
	String condicion = " and cod_modulo = " + datos.getInt("padre") + " ";
	String existencia;
	if (datos.getInt("detalle") == 0) {
	    existencia = " and pd.cod_proyecto = " + datos.getInt("proyecto") + " ";
	} else {
	    existencia = " and cc.cod_proyecto_detalle = " + datos.getInt("detalle") + " ";
	}
	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    sql = "select top " + length + " a.cod_categoria, a.nom, a.tip, a.url, "
		    + "ISNULL(  "
		    + "(select count(*) as cant  "
		    + "from categoria_configuracion as cc   "
		    + "inner join proyecto_detalle as pd   "
		    + "on pd.cod_proyecto_detalle = cc.cod_proyecto_detalle "
		    + "where cc.cod_categoria = a.cod_categoria "
		    + existencia + " ), 0)  "
		    + "from categoria as a  "
		    + "where a.cod_categoria not in   "
		    + "(select top " + start + " b.cod_categoria from categoria as b  "
		    + "where 1 = 1 " + condicion
		    + "ORDER BY 1 desc)  "
		    + condicion
		    + "ORDER BY 1 desc ; ";
	    pst = con.prepareStatement(sql);
	    rsLlave = pst.executeQuery();
	    while (rsLlave.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigo", rsLlave.getInt(1));
		obj.put("nombre", rsLlave.getString(2));
		obj.put("icono", "");
		obj.put("tipo", rsLlave.getInt(3));
		obj.put("url", rsLlave.getString(4));
		obj.put("existencia", rsLlave.getInt(5));
		data.put(obj);
	    }
	    sql = "select count(*) as cant from categoria "
		    + " where 1 = 1 " + condicion + " ";
	    pst = con.prepareStatement(sql);
	    rsLlave = pst.executeQuery();
	    rsLlave.next();
	    cant = rsLlave.getInt("cant");
	    if (data.length() > 1) {
		response.setMessage("Error al listar");
		response.setStatus(false);
	    } else {
		response.setStatus(true);
		response.setMessage("Se listo correctamente.");
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn.put("data", data);
	jsonReturn.put("recordsFiltered", cant);
	jsonReturn.put("recordsTotal", cant);
	jsonReturn.put("draw", draw);

	return jsonReturn;
    }

    @Override
    public JSONObject listarSubCategoria(JSONObject datos, String draw, String start, String length) throws Exception {
	JSONObject jsonReturn = new JSONObject();
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant = 0;
	String sql;
	ResponseHelper response = new ResponseHelper();
	String condicion = " and cod_categoria = " + datos.getInt("padre") + " ";
	String existencia;
	if (datos.getInt("detalle") == 0) {
	    existencia = " and pd.cod_proyecto = " + datos.getInt("proyecto") + " ";
	} else {
	    existencia = " and sc.cod_proyecto_detalle = " + datos.getInt("detalle") + " ";
	}
	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    sql = "select top " + length + " a.cod_subcategoria, a.nom, a.url, "
		    + "ISNULL(  "
		    + "(select count(*) as cant  "
		    + "from subcategoria_configuracion as sc   "
		    + "inner join proyecto_detalle as pd   "
		    + "on pd.cod_proyecto_detalle = sc.cod_proyecto_detalle "
		    + "where sc.cod_subcategoria = a.cod_subcategoria "
		    + existencia + " ), 0)  "
		    + "from subcategoria as a  "
		    + "where a.cod_subcategoria not in   "
		    + "(select top " + start + " b.cod_subcategoria from subcategoria as b  "
		    + "where 1 = 1 " + condicion
		    + "ORDER BY 1 desc)  "
		    + condicion
		    + "ORDER BY 1 desc ; ";
	    pst = con.prepareStatement(sql);
	    rsLlave = pst.executeQuery();
	    while (rsLlave.next()) {
		JSONObject obj = new JSONObject();
		obj.put("codigo", rsLlave.getInt(1));
		obj.put("nombre", rsLlave.getString(2));
		obj.put("icono", "");
		obj.put("tipo", 0);
		obj.put("url", rsLlave.getString(3));
		obj.put("existencia", rsLlave.getInt(4));
		data.put(obj);
	    }
	    sql = "select count(*) as cant from subcategoria "
		    + " where 1 = 1 " + condicion + " ";
	    pst = con.prepareStatement(sql);
	    rsLlave = pst.executeQuery();
	    rsLlave.next();
	    cant = rsLlave.getInt("cant");
	    if (data.length() > 1) {
		response.setMessage("Error al listar");
		response.setStatus(false);
	    } else {
		response.setStatus(true);
		response.setMessage("Se listo correctamente.");
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn.put("data", data);
	jsonReturn.put("recordsFiltered", cant);
	jsonReturn.put("recordsTotal", cant);
	jsonReturn.put("draw", draw);

	return jsonReturn;
    }

    @Override
    public JSONObject validarElminarTitulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant;
	String sql;
	ResponseHelper response = new ResponseHelper();
	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    if (datos.getInt("configuracion") != 0) {
		sql = "select count(*) as cant from modulo as s "
			+ "inner join modulo_configuracion as sc "
			+ "on sc.cod_modulo = s.cod_modulo "
			+ "where cod_titulo = ? "
			+ "and sc.cod_proyecto_detalle = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("prodetail"));
		rsLlave = pst.executeQuery();
		rsLlave.next();
		cant = rsLlave.getInt("cant");
		if (cant == 0) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("Primero elimina los Modulos dependientes");
		    response.setStatus(false);
		}
	    } else {
		sql = "select count(*) as cant from modulo as s "
			+ "inner join modulo_configuracion as sc "
			+ "on sc.cod_modulo = s.cod_modulo "
			+ "inner join proyecto_detalle as pd "
			+ "on pd.cod_proyecto_detalle = sc.cod_proyecto_detalle "
			+ "where cod_titulo = ? "
			+ "and cod_proyecto = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("proyecto"));
		rsLlave = pst.executeQuery();
		rsLlave.next();
		cant = rsLlave.getInt("cant");
		if (cant == 0) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("Primero elimina los Modulos dependientes");
		    response.setStatus(false);
		}
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject eliminarDetalleTitulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    if (datos.getInt("configuracion") != 0) {
		sql = " delete from titulo_configuracion "
			+ " where cod_titulo_configuracion = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("configuracion"));
		rs = pst.executeUpdate();
		if (rs >= 1) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("error al insertar subcategoria");
		    response.setStatus(false);
		}
	    } else {
		sql = " DELETE tc "
			+ " FROM titulo_configuracion as tc "
			+ " INNER JOIN proyecto_detalle as pd "
			+ " ON pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
			+ " WHERE pd.cod_proyecto = ? "
			+ " and tc.cod_titulo = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("proyecto"));
		pst.setInt(2, datos.getInt("codigo"));
		rs = pst.executeUpdate();
		if (rs >= 1) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("error al insertar subcategoria");
		    response.setStatus(false);
		}
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject validarElminarModulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant;
	String sql;
	ResponseHelper response = new ResponseHelper();
	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    if (datos.getInt("configuracion") != 0) {
		sql = "select count(*) as cant from categoria as s "
			+ "inner join categoria_configuracion as sc "
			+ "on sc.cod_categoria = s.cod_categoria "
			+ "where cod_modulo = ? "
			+ "and sc.cod_proyecto_detalle = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("prodetail"));
		rsLlave = pst.executeQuery();
		rsLlave.next();
		cant = rsLlave.getInt("cant");
		if (cant == 0) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("Primero elimina los Modulos dependientes");
		    response.setStatus(false);
		}
	    } else {
		sql = "select count(*) as cant from categoria as s "
			+ "inner join categoria_configuracion as sc "
			+ "on sc.cod_categoria = s.cod_categoria "
			+ "inner join proyecto_detalle as pd "
			+ "on pd.cod_proyecto_detalle = sc.cod_proyecto_detalle "
			+ "where cod_modulo = ? "
			+ "and cod_proyecto = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("proyecto"));
		rsLlave = pst.executeQuery();
		rsLlave.next();
		cant = rsLlave.getInt("cant");
		if (cant == 0) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("Primero elimina los Modulos dependientes");
		    response.setStatus(false);
		}
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject eliminarDetalleModulo(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    if (datos.getInt("configuracion") != 0) {
		sql = " delete from modulo_configuracion "
			+ " where cod_modulo_configuracion = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("configuracion"));
		rs = pst.executeUpdate();
		if (rs >= 1) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("error al insertar subcategoria");
		    response.setStatus(false);
		}
	    } else {
		sql = " DELETE tc "
			+ " FROM modulo_configuracion as tc "
			+ " INNER JOIN proyecto_detalle as pd "
			+ " ON pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
			+ " WHERE pd.cod_proyecto = ? "
			+ " and tc.cod_modulo = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("proyecto"));
		pst.setInt(2, datos.getInt("codigo"));
		rs = pst.executeUpdate();
		if (rs >= 1) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("error al insertar subcategoria");
		    response.setStatus(false);
		}
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject validarElminarCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int cant;
	String sql;
	ResponseHelper response = new ResponseHelper();
	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    if (datos.getInt("configuracion") != 0) {
		sql = "select count(*) as cant from subcategoria as s "
			+ "inner join subcategoria_configuracion as sc "
			+ "on sc.cod_subcategoria = s.cod_subcategoria "
			+ "where cod_categoria = ? "
			+ "and sc.cod_proyecto_detalle = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("prodetail"));
		rsLlave = pst.executeQuery();
		rsLlave.next();
		cant = rsLlave.getInt("cant");
		if (cant == 0) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("Primero elimina los Modulos dependientes");
		    response.setStatus(false);
		}
	    } else {
		sql = "select count(*) as cant from subcategoria as s "
			+ "inner join subcategoria_configuracion as sc "
			+ "on sc.cod_subcategoria = s.cod_subcategoria "
			+ "inner join proyecto_detalle as pd "
			+ "on pd.cod_proyecto_detalle = sc.cod_proyecto_detalle "
			+ "where cod_categoria = ? "
			+ "and cod_proyecto = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("codigo"));
		pst.setInt(2, datos.getInt("proyecto"));
		rsLlave = pst.executeQuery();
		rsLlave.next();
		cant = rsLlave.getInt("cant");
		if (cant == 0) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("Primero elimina los Modulos dependientes");
		    response.setStatus(false);
		}
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject eliminarDetalleCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    if (datos.getInt("configuracion") != 0) {
		sql = " delete from categoria_configuracion "
			+ " where cod_categoria_configuracion = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("configuracion"));
		rs = pst.executeUpdate();
		if (rs >= 1) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("error al insertar subcategoria");
		    response.setStatus(false);
		}
	    } else {
		sql = " DELETE tc "
			+ " FROM categoria_configuracion as tc "
			+ " INNER JOIN proyecto_detalle as pd "
			+ " ON pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
			+ " WHERE pd.cod_proyecto = ? "
			+ " and tc.cod_categoria = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("proyecto"));
		pst.setInt(2, datos.getInt("codigo"));
		rs = pst.executeUpdate();
		if (rs >= 1) {
		    con.commit();
		    response.setStatus(true);
		    response.setMessage("Se registro correctamente.");
		} else {
		    con.rollback();
		    response.setMessage("error al insertar subcategoria");
		    response.setStatus(false);
		}
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject validarElminarSubCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	ResponseHelper response = new ResponseHelper();
	response.setStatus(true);
	response.setMessage("Se registro correctamente.");
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject eliminarDetalleSubCategoria(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	JSONArray data = new JSONArray();
	String base = "security";
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rsLlave;
	int rs;
	String sql;
	ResponseHelper response = new ResponseHelper();

	try {
	    con = SqlServerDAOFactory.getConnectionSQL(base);
	    con.setAutoCommit(false);
	    if (datos.getInt("configuracion") != 0) {
		sql = " delete from subcategoria_configuracion "
			+ " where cod_subcategoria_configuracion = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("configuracion"));
	    } else {
		sql = " DELETE tc "
			+ " FROM subcategoria_configuracion as tc "
			+ " INNER JOIN proyecto_detalle as pd "
			+ " ON pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
			+ " WHERE pd.cod_proyecto = ? "
			+ " and tc.cod_subcategoria = ? ";
		pst = con.prepareStatement(sql);
		pst.setInt(1, datos.getInt("proyecto"));
		pst.setInt(2, datos.getInt("codigo"));
	    }
	    rs = pst.executeUpdate();
	    if (rs >= 1) {
		con.commit();
		response.setStatus(true);
		response.setMessage("Se registro correctamente.");
	    } else {
		con.rollback();
		response.setMessage("error al insertar subcategoria");
		response.setStatus(false);
	    }

	} catch (SQLException e) {
	    response.setStatus(false);
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}

	jsonReturn = new JSONObject(response);

	return jsonReturn;
    }

    @Override
    public JSONObject eliminarMenusAninadoGeneral(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rSet = null;
	int rsInt = 0;
	ResponseHelper response = new ResponseHelper();
	String sql;
	JSONArray rs;
	try {
	    con = SqlServerDAOFactory.getConnectionSQL("SECURITY");
	    con.setAutoCommit(false);
	    JSONArray arrayTitulos = datos.getJSONArray("titulos");
	    JSONArray arrayModulos = datos.getJSONArray("modulos");
	    JSONArray arrayCategorias = datos.getJSONArray("categorias");
	    JSONArray arraySubCategorias = datos.getJSONArray("subcategorias");
	    sql = " DELETE tc "
		    + " FROM subcategoria_configuracion as tc "
		    + " INNER JOIN proyecto_detalle as pd "
		    + " ON pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
		    + " WHERE pd.cod_proyecto = ? "
		    + " and tc.cod_subcategoria = ? ";
	    pst = con.prepareStatement(sql);
	    for (int i = 0; i < arraySubCategorias.length(); i++) {
		pst.setInt(1, arraySubCategorias.getJSONObject(i).getInt("proyecto"));
		pst.setInt(2, arraySubCategorias.getJSONObject(i).getInt("codigo"));
		pst.addBatch();
	    }
	    rs = new JSONArray(pst.executeBatch());
	    if (rs.length() == arraySubCategorias.length()) {
		sql = " DELETE tc "
			+ " FROM categoria_configuracion as tc "
			+ " INNER JOIN proyecto_detalle as pd "
			+ " ON pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
			+ " WHERE pd.cod_proyecto = ? "
			+ " and tc.cod_categoria = ? ";
		pst = con.prepareStatement(sql);
		for (int i = 0; i < arrayCategorias.length(); i++) {
		    pst.setInt(1, arrayCategorias.getJSONObject(i).getInt("proyecto"));
		    pst.setInt(2, arrayCategorias.getJSONObject(i).getInt("codigo"));
		    pst.addBatch();
		}
		rs = new JSONArray(pst.executeBatch());
		if (rs.length() == arrayCategorias.length()) {
		    sql = " DELETE tc "
			    + " FROM modulo_configuracion as tc "
			    + " INNER JOIN proyecto_detalle as pd "
			    + " ON pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
			    + " WHERE pd.cod_proyecto = ? "
			    + " and tc.cod_modulo = ? ";
		    pst = con.prepareStatement(sql);
		    for (int i = 0; i < arrayModulos.length(); i++) {
			pst.setInt(1, arrayModulos.getJSONObject(i).getInt("proyecto"));
			pst.setInt(2, arrayModulos.getJSONObject(i).getInt("codigo"));
			pst.addBatch();
		    }
		    rs = new JSONArray(pst.executeBatch());
		    if (rs.length() == arrayModulos.length()) {
			sql = " DELETE tc "
				+ " FROM titulo_configuracion as tc "
				+ " INNER JOIN proyecto_detalle as pd "
				+ " ON pd.cod_proyecto_detalle = tc.cod_proyecto_detalle "
				+ " WHERE pd.cod_proyecto = ? "
				+ " and tc.cod_titulo = ? ";
			pst = con.prepareStatement(sql);
			for (int i = 0; i < arrayTitulos.length(); i++) {
			    pst.setInt(1, arrayTitulos.getJSONObject(i).getInt("proyecto"));
			    pst.setInt(2, arrayTitulos.getJSONObject(i).getInt("codigo"));
			    pst.addBatch();
			}
			rs = new JSONArray(pst.executeBatch());
			if (rs.length() == arrayTitulos.length()) {
			    con.commit();
			    response.setStatus(true);
			    response.setMessage("Se elimino correctamente.");
			} else {
			    con.rollback();
			    response.setMessage("error al eliminar titulo");
			    response.setStatus(false);
			}
		    } else {
			con.rollback();
			response.setMessage("error al eliminar modulo");
			response.setStatus(false);
		    }
		} else {
		    con.rollback();
		    response.setMessage("error al eliminar categoria");
		    response.setStatus(false);
		}
	    } else {
		con.rollback();
		response.setMessage("error al eliminar subcategoria");
		response.setStatus(false);
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    response.setStatus(false);
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

    @Override
    public JSONObject eliminarMenusAninado(JSONObject datos) throws Exception {
	JSONObject jsonReturn;
	Connection con = null;
	PreparedStatement pst = null;
	ResultSet rSet = null;
	int rsInt = 0;
	ResponseHelper response = new ResponseHelper();
	String sql;
	JSONArray rs;
	try {
	    con = SqlServerDAOFactory.getConnectionSQL("SECURITY");
	    con.setAutoCommit(false);
	    JSONArray arrayTitulos = datos.getJSONArray("titulos");
	    JSONArray arrayModulos = datos.getJSONArray("modulos");
	    JSONArray arrayCategorias = datos.getJSONArray("categorias");
	    JSONArray arraySubCategorias = datos.getJSONArray("subcategorias");
	    sql = " delete from subcategoria_configuracion "
		    + " where cod_subcategoria_configuracion = ? ";
	    pst = con.prepareStatement(sql);
	    for (int i = 0; i < arraySubCategorias.length(); i++) {
		pst.setInt(1, arraySubCategorias.getJSONObject(i).getInt("configuracion"));
		pst.addBatch();
	    }
	    rs = new JSONArray(pst.executeBatch());
	    if (rs.length() == arraySubCategorias.length()) {
		sql = " delete from categoria_configuracion "
			+ " where cod_categoria_configuracion = ? ";
		pst = con.prepareStatement(sql);
		for (int i = 0; i < arrayCategorias.length(); i++) {
		    pst.setInt(1, arrayCategorias.getJSONObject(i).getInt("configuracion"));
		    pst.addBatch();
		}
		rs = new JSONArray(pst.executeBatch());
		if (rs.length() == arrayCategorias.length()) {
		    sql = " delete from modulo_configuracion "
			    + " where cod_modulo_configuracion = ? ";
		    pst = con.prepareStatement(sql);
		    for (int i = 0; i < arrayModulos.length(); i++) {
			pst.setInt(1, arrayModulos.getJSONObject(i).getInt("configuracion"));
			pst.addBatch();
		    }
		    rs = new JSONArray(pst.executeBatch());
		    if (rs.length() == arrayModulos.length()) {
			sql = " delete from titulo_configuracion "
				+ " where cod_titulo_configuracion = ? ";
			pst = con.prepareStatement(sql);
			for (int i = 0; i < arrayTitulos.length(); i++) {
			    pst.setInt(1, arrayTitulos.getJSONObject(i).getInt("configuracion"));
			    pst.addBatch();
			}
			rs = new JSONArray(pst.executeBatch());
			if (rs.length() == arrayTitulos.length()) {
			    con.commit();
			    response.setStatus(true);
			    response.setMessage("Se elimino correctamente.");
			} else {
			    con.rollback();
			    response.setMessage("error al eliminar titulo");
			    response.setStatus(false);
			}
		    } else {
			con.rollback();
			response.setMessage("error al eliminar modulo");
			response.setStatus(false);
		    }
		} else {
		    con.rollback();
		    response.setMessage("error al eliminar categoria");
		    response.setStatus(false);
		}
	    } else {
		con.rollback();
		response.setMessage("error al eliminar subcategoria");
		response.setStatus(false);
	    }
	} catch (SQLException e) {
	    e.printStackTrace();
	    response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    response.setStatus(false);
	} finally {
	    try {
		if (pst != null) {
		    pst.close();
		}
		if (con != null) {
		    con.close();
		}
	    } catch (SQLException e) {
		e.printStackTrace();
		response.setStatus(false);
		response.setMessage("Error -> " + e.getMessage() + " [" + e.getErrorCode() + "]");
	    }
	}
	jsonReturn = new JSONObject(response);
	return jsonReturn;
    }

}
