/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import moduloSeguridad.services.TipoUsuarioService;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class TipoUsuarioServlet extends HttpServlet {

	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		String accion = request.getParameter("accion");
		switch (accion) {
			case "listarProyectos":
				listarProyectos(request, response);
				break;
			case "listarTiposUsuarios":
				listarTiposUsuarios(request, response);
				break;
			case "asignarAcciones":
				asignarAcciones(request, response);
				break;
			case "listarAcciones":
				listarAcciones(request, response);
				break;
			case "listarCboAcciones":
				listarCboAcciones(request, response);
				break;
			case "listadoPrincipal":
				listadoPrincipal(request, response);
				break;
			case "activarDesactivarAccion":
				activarDesactivarAccion(request, response);
				break;
			case "activarDesactivarTipoUsuario":
				activarDesactivarTipoUsuario(request, response);
				break;
			case "desactivarTipoUsuario":
				desactivarTipoUsuario(request, response);
				break;
			case "editarTipoUsuario":
				editarTipoUsuario(request, response);
				break;
			case "crearTipoUsuario":
				crearTipoUsuario(request, response);
				break;
			case "validarTipoUsuario":
				validarTipoUsuario(request, response);
				break;
			case "validarNombreTipoUsuario":
				validarNombreTipoUsuario(request, response);
				break;
			default:
				break;
		}
	}
        
        private void listarProyectos(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            TipoUsuarioService service = new TipoUsuarioService();
            JSONObject json = service.listarProyectos();
            out.println(json);
        }
        
        private void listarTiposUsuarios(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            
            int codigoProyecto = Integer.parseInt(request.getParameter("codigoProy"));
            
            TipoUsuarioService service = new TipoUsuarioService();
            JSONObject json = service.listarTiposUsuarios(codigoProyecto);
            out.println(json);
        }
        
        private void asignarAcciones(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            
            JSONObject obj = new JSONObject()
                    .put("codProyectoDetalle", Integer.parseInt(request.getParameter("codigoProyDetalle")))
                    .put("nomAccion", request.getParameter("nomAccion"));
            
            TipoUsuarioService service = new TipoUsuarioService();
            JSONObject json = service.asignarAcciones(obj);
            out.println(json);
        }
        
        private void activarDesactivarAccion(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            
            JSONObject obj = new JSONObject().put("codigoAccionDetalle", Integer.parseInt(request.getParameter("codAccionDetalle")));
            
            TipoUsuarioService service = new TipoUsuarioService();
            JSONObject json = service.activarDesactivarAccion(obj);
            out.println(json);
        }
        
        private void activarDesactivarTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            
            JSONObject obj = new JSONObject().put("codigoProyectoDetalle", Integer.parseInt(request.getParameter("codProyectoDetalle")));
            
            TipoUsuarioService service = new TipoUsuarioService();
            JSONObject json = service.activarDesactivarTipoUsuario(obj);
            out.println(json);
        }
        
        private void listarCboAcciones(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            
            TipoUsuarioService service = new TipoUsuarioService();
            JSONObject json = service.listarCboAcciones();
            out.println(json);
        }
        
        private void listarAcciones(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentType("application/json");
            PrintWriter out = response.getWriter();
            
            String draw = request.getParameter("draw");
            int vstart = Integer.parseInt(request.getParameter("start"));
            int vlength = Integer.parseInt(request.getParameter("length"));
                
            JSONObject obj = new JSONObject()
                    .put("draw",draw)
                    .put("start",vstart)
                    .put("length",vlength)
                    .put("proyectoDetalle", Integer.parseInt(request.getParameter("codProyDetalle")));
            
            TipoUsuarioService service = new TipoUsuarioService();
            JSONObject json = service.listarAcciones(obj);
            out.println(json);
        }

	private void listadoPrincipal(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		TipoUsuarioService service = new TipoUsuarioService();
                
		String filtro = request.getParameter("filtro");
                int filtrado = Integer.parseInt(request.getParameter("filtrado"));
                int cboProyecto = Integer.parseInt(request.getParameter("valorCboProyecto"));
                
		String draw = request.getParameter("draw");
		int vstart = Integer.parseInt(request.getParameter("start"));
		int vlength = Integer.parseInt(request.getParameter("length"));
                
		JSONObject json = service.listadoPrincipal(filtro, filtrado, cboProyecto, vstart, vlength, draw);
		out.println(json);
	}

	private void activarTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		TipoUsuarioService service = new TipoUsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.activarTipoUsuario(codigo);
		out.println(rs);
	}

	private void desactivarTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		TipoUsuarioService service = new TipoUsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.desactivarTipoUsuario(codigo);
		out.println(rs);
	}

	private void editarTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		TipoUsuarioService service = new TipoUsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		String nombre = request.getParameter("nombre");
		int rs = service.editarTipoUsuario(codigo, nombre);
		out.println(rs);
	}

	private void crearTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		TipoUsuarioService service = new TipoUsuarioService();
		String nombre = request.getParameter("nombre");
		int rs = service.crearTipoUsuario(nombre);
		out.println(rs);
	}

	private void validarTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		TipoUsuarioService service = new TipoUsuarioService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.validarTipoUsuario(codigo);
		out.print(rs);
	}

	private void validarNombreTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		TipoUsuarioService service = new TipoUsuarioService();
		String nombreIngreso = request.getParameter("nombreIngreso");
		String nombreInicial = request.getParameter("nombreInicial");
		int tipo = Integer.parseInt(request.getParameter("tipo"));
		int rs = service.validarNombreTipoUsuario(nombreInicial, nombreIngreso, tipo);
		out.print(rs);
	}

}
