/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import moduloSeguridad.services.ProyectoService;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author Felipe Escala
 */
public class ProyectoServlet extends HttpServlet {

	@Override
	protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html");
		String accion = request.getParameter("accion");
		switch (accion) {
			case "listarProyecto":
				listarProyecto(request, response);
				break;
			case "editarProyecto":
				editarProyecto(request, response);
				break;
			case "activarProyecto":
				activarProyecto(request, response);
				break;
			case "desactivarProyecto":
				desactivarProyecto(request, response);
				break;
			case "asignarDetalle":
				asignarDetalle(request, response);
				break;
			case "listarDetalle":
				listarDetalle(request, response);
				break;
			case "crearProyecto":
				crearProyecto(request, response);
				break;
			case "activarDetalle":
				activarDetalle(request, response);
				break;
			case "desactivarDetalle":
				desactivarDetalle(request, response);
				break;
			case "listarTipoUsuario":
				listarTipoUsuario(request, response);
				break;
			case "eliminarDetalle":
				eliminarDetalle(request, response);
				break;
			case "validarProyecto":
				validarProyecto(request, response);
				break;
			case "validarNombreProyecto":
				validarNombreProyecto(request, response);
				break;
			case "validarUrlProyecto":
				validarUrlProyecto(request, response);
				break;
			case "validarDetalle":
				validarDetalle(request, response);
				break;
			case "validarMenuDetalle":
				validarMenuDetalle(request, response);
				break;
			case "eliminarMenuDetalle":
				eliminarMenuDetalle(request, response);
				break;
			case "desactivarUsuarioDetalle":
				desactivarUsuarioDetalle(request, response);
				break;
			default:
				break;
		}
	}

	private void listarProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		String jsonString = request.getParameter("json");
		System.out.println("CADENA JSON " + jsonString);
		String draw = request.getParameter("draw");
		int vstart = Integer.parseInt(request.getParameter("start"));
		int vlength = Integer.parseInt(request.getParameter("length"));
		JSONObject json = service.listarProyecto(new JSONObject(jsonString), vstart, vlength, draw);
		out.println(json);
	}

	private void editarProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		String url = request.getParameter("url");
		String nombre = request.getParameter("nombre");
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.editarProyecto(codigo, nombre, url);
		out.println(rs);
	}

	private void activarProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.activarProyecto(codigo);
		out.println(rs);
	}

	private void desactivarProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.desactivarProyecto(codigo);
		out.println(rs);
	}

	private void asignarDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int proyecto = Integer.parseInt(request.getParameter("proyecto"));
		int tipoUsuario = Integer.parseInt(request.getParameter("tipoUsuario"));
		JSONObject rs = service.asignarDetalle(proyecto, tipoUsuario);
		out.println(rs);
	}

	private void listarDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		String filtro = request.getParameter("filtro");
		String draw = request.getParameter("draw");
		int vstart = Integer.parseInt(request.getParameter("start"));
		int vlength = Integer.parseInt(request.getParameter("length"));
		JSONObject json = service.listarDetalle(filtro, vstart, vlength, draw);
		out.println(json);
	}

	private void crearProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		String url = request.getParameter("url");
		String nombre = request.getParameter("nombre");
		int rs = service.crearProyecto(nombre, url);
		out.println(rs);
	}

	private void activarDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.activarDetalle(codigo);
		out.println(rs);
	}

	private void desactivarDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.desactivarDetalle(codigo);
		out.println(rs);
	}

	private void listarTipoUsuario(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int proyecto = Integer.parseInt(request.getParameter("proyecto"));
		JSONArray rs = service.listarTipoUsuario(proyecto);
		out.println(rs);
	}

	private void eliminarDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int proyecto = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.eliminarDetalle(proyecto);
		out.println(rs);
	}

	private void validarProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int proyecto = Integer.parseInt(request.getParameter("codigo"));
		JSONArray rs = service.validarProyecto(proyecto);
		out.println(rs);
	}

	private void validarNombreProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		String nuevo = request.getParameter("nuevo");
		String actual = request.getParameter("actual");
		int tipo = Integer.parseInt(request.getParameter("tipo"));
		int rs = service.validarNombreProyecto(nuevo, actual, tipo);
		out.println(rs);
	}

	private void validarUrlProyecto(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		String nuevo = request.getParameter("nuevo");
		String actual = request.getParameter("actual");
		int tipo = Integer.parseInt(request.getParameter("tipo"));
		int rs = service.validarUrlProyecto(nuevo, actual, tipo);
		out.println(rs);
	}

	private void validarDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.validarDetalle(codigo);
		out.println(rs);
	}

	private void validarMenuDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.validarMenuDetalle(codigo);
		out.println(rs);
	}

	private void eliminarMenuDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.eliminarMenuDetalle(codigo);
		out.println(rs);
	}

	private void desactivarUsuarioDetalle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setContentType("application/json");
		PrintWriter out = response.getWriter();
		ProyectoService service = new ProyectoService();
		int codigo = Integer.parseInt(request.getParameter("codigo"));
		int rs = service.desactivarUsuarioDetalle(codigo);
		out.println(rs);
	}

}
