/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.services;

import moduloSeguridad.dao.DAOFactory;
import moduloSeguridad.dao.UsuarioDAO;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class UsuarioService {

	DAOFactory fabrica = DAOFactory.getDAOFactory(DAOFactory.SQLSERVER);
	UsuarioDAO dao = fabrica.getUsuarioDAO();

	public JSONArray listarUsuario(JSONObject datos, int vstart, int vlength, int draw) {
		JSONArray array = null;
		try {
			array = dao.listarUsuario(datos, vstart, vlength, draw);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return array;
	}

	public int cantidadRegistros(JSONObject datos) {
		int rs = 0;
		try {
			rs = dao.cantidadRegistros(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int editarUsuario(int codigo, String usuario, String clave) {
		int rs = 0;
		try {
			rs = dao.editarUsuario(codigo, usuario, clave);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int desactivarUsuario(int codigo) {
		int rs = 0;
		try {
			rs = dao.desactivarUsuario(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int activarUsuario(int codigo) {
		int rs = 0;
		try {
			rs = dao.activarUsuario(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int crearUsuario(String codigoTrabajador, String usuario, String clave) {
		int rs = 0;
		try {
			rs = dao.crearUsuario(codigoTrabajador, usuario, clave);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarUsuario(String codigoTrabajador) {
		int rs = 0;
		try {
			rs = dao.validarUsuario(codigoTrabajador);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int eliminarUsuario(int codigo) {
		int rs = 0;
		try {
			rs = dao.eliminarUsuario(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public JSONObject listarUsuarioDetalle(String filtro, int vstart, int vlength, String draw) {
		JSONObject rs = null;
		try {
			rs = dao.listarUsuarioDetalle(filtro, vstart, vlength, draw);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int eliminarUsuarioDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.eliminarUsuarioDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int activarUsuarioDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.activarUsuarioDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int desactivarUsuarioDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.desactivarUsuarioDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public JSONArray listarTipoDeUsuario(int proyecto, int usuario) {
		JSONArray obj = null;
		try {
			obj = dao.listarTipoDeUsuario(proyecto, usuario);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public JSONArray listarProyecto() {
		JSONArray obj = null;
		try {
			obj = dao.listarProyecto();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public int asignarProyectoUsuario(int usuario, int proyectoDetalle) {
		int rs = 0;
		try {
			rs = dao.asignarProyectoUsuario(usuario, proyectoDetalle);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarUsuarioDependencia(int codigo) {
		int rs = 0;
		try {
			rs = dao.validarUsuarioDependencia(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarNombreUsuario(String nombre) {
		int rs = 0;
		try {
			rs = dao.validarNombreUsuario(nombre);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarAsignacion(int codigo) {
		int rs = 0;
		try {
			rs = dao.validarAsignacion(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public JSONObject listarUsuarioManual(JSONObject datos) {
		JSONObject obj = null;
		try {
			obj = dao.listarUsuarioManual(datos);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
}
