/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.services;

import moduloSeguridad.dao.DAOFactory;
import moduloSeguridad.dao.ProyectoDAO;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public class ProyectoService {

	DAOFactory fabrica = DAOFactory.getDAOFactory(DAOFactory.SQLSERVER);
	ProyectoDAO dao = fabrica.getProyectoDAO();

	public JSONObject listarProyecto(JSONObject filtro, int vstart, int vlength, String draw) {
		JSONObject obj = null;
		try {
			obj = dao.listarProyecto(filtro, vstart, vlength, draw);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public int editarProyecto(int codigo, String nombre, String url) {
		int rs = 0;
		try {
			rs = dao.editarProyecto(codigo, nombre, url);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int desactivarProyecto(int codigo) {
		int rs = 0;
		try {
			rs = dao.desactivarProyecto(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int activarProyecto(int codigo) {
		int rs = 0;
		try {
			rs = dao.activarProyecto(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public JSONObject asignarDetalle(int proyecto, int tipoUsuario) {
		JSONObject rs = null;
		try {
			rs = dao.asignarDetalle(proyecto, tipoUsuario);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public JSONObject listarDetalle(String filtro, int vstart, int vlength, String draw) {
		JSONObject obj = new JSONObject();
		try {
			obj = dao.listarDetalle(filtro, vstart, vlength, draw);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public int crearProyecto(String nombre, String url) {
		int rs = 0;
		try {
			rs = dao.crearProyecto(nombre, url);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int activarDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.activarDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int desactivarDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.desactivarDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public JSONArray listarTipoUsuario(int proyecto) {
		JSONArray array = null;
		try {
			array = dao.listarTipoUsuario(proyecto);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return array;
	}

	public int eliminarDetalle(int codigoDetalle) {
		int rs = 0;
		try {
			rs = dao.eliminarDetalle(codigoDetalle);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public JSONArray validarProyecto(int codigo) {
		JSONArray rs = null;
		try {
			rs = dao.validarProyecto(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarNombreProyecto(String nombreNuevo, String nombreActual, int tipo) {
		int rs = 0;
		try {
			rs = dao.validarNombreProyecto(nombreNuevo, nombreActual, tipo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarUrlProyecto(String urlNuevo, String urlActual, int tipo) {
		int rs = 0;
		try {
			rs = dao.validarUrlProyecto(urlNuevo, urlActual, tipo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.validarDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int validarMenuDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.validarMenuDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int eliminarMenuDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.eliminarMenuDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

	public int desactivarUsuarioDetalle(int codigo) {
		int rs = 0;
		try {
			rs = dao.desactivarUsuarioDetalle(codigo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return rs;
	}

}
